/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ModuleI18nUtil;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ModuleTypeI18nUtil;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeProvider;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.osgi.framework.Bundle;

public class ModuleTypeResourceBundleProvider
extends AbstractResourceBundleProvider<ModuleType>
implements ModuleTypeProvider {
    public ModuleTypeResourceBundleProvider() {
        this.listeners = new LinkedList();
        this.path = String.valueOf(PATH) + "/moduletypes/";
    }

    public Collection<ModuleType> getAll() {
        return this.providedObjectsHolder.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public <T extends ModuleType> T getModuleType(String UID, Locale locale) {
        return (T)this.getPerLocale((ModuleType)this.providedObjectsHolder.get(UID), locale);
    }

    public Collection<ModuleType> getModuleTypes(Locale locale) {
        ArrayList<ModuleType> moduleTypesList = new ArrayList<ModuleType>();
        for (ModuleType mt : this.providedObjectsHolder.values()) {
            moduleTypesList.add(this.getPerLocale(mt, locale));
        }
        return moduleTypesList;
    }

    @Override
    protected String getUID(ModuleType parsedObject) {
        return parsedObject.getUID();
    }

    private ModuleType getPerLocale(ModuleType defModuleType, Locale locale) {
        if (locale == null || defModuleType == null || this.i18nProvider == null) {
            return defModuleType;
        }
        String uid = defModuleType.getUID();
        Bundle bundle = this.getBundle(uid);
        String llabel = ModuleTypeI18nUtil.getLocalizedModuleTypeLabel(this.i18nProvider, bundle, uid, defModuleType.getLabel(), locale);
        String ldescription = ModuleTypeI18nUtil.getLocalizedModuleTypeDescription(this.i18nProvider, bundle, uid, defModuleType.getDescription(), locale);
        List<ConfigDescriptionParameter> lconfigDescriptions = this.getLocalizedConfigurationDescription(this.i18nProvider, defModuleType.getConfigurationDescriptions(), bundle, uid, "module-type", locale);
        if (defModuleType instanceof ActionType) {
            return this.createLocalizedActionType((ActionType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        if (defModuleType instanceof ConditionType) {
            return this.createLocalizedConditionType((ConditionType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        if (defModuleType instanceof TriggerType) {
            return this.createLocalizedTriggerType((TriggerType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        return null;
    }

    private ActionType createLocalizedActionType(ActionType at, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Input> inputs = ModuleTypeI18nUtil.getLocalizedInputs(this.i18nProvider, at.getInputs(), bundle, moduleTypeUID, locale);
        List<Output> outputs = ModuleTypeI18nUtil.getLocalizedOutputs(this.i18nProvider, at.getOutputs(), bundle, moduleTypeUID, locale);
        ActionType lat = null;
        if (at instanceof CompositeActionType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeActionType)at).getChildren(), bundle, moduleTypeUID, "module-type", locale);
            lat = new CompositeActionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, at.getTags(), at.getVisibility(), inputs, outputs, modules);
        } else {
            lat = new ActionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, at.getTags(), at.getVisibility(), inputs, outputs);
        }
        return lat;
    }

    private ConditionType createLocalizedConditionType(ConditionType ct, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Input> inputs = ModuleTypeI18nUtil.getLocalizedInputs(this.i18nProvider, ct.getInputs(), bundle, moduleTypeUID, locale);
        ConditionType lct = null;
        if (ct instanceof CompositeConditionType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeConditionType)ct).getChildren(), bundle, moduleTypeUID, "module-type", locale);
            lct = new CompositeConditionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, ct.getTags(), ct.getVisibility(), inputs, modules);
        } else {
            lct = new ConditionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, ct.getTags(), ct.getVisibility(), inputs);
        }
        return lct;
    }

    private TriggerType createLocalizedTriggerType(TriggerType tt, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Output> outputs = ModuleTypeI18nUtil.getLocalizedOutputs(this.i18nProvider, tt.getOutputs(), bundle, moduleTypeUID, locale);
        TriggerType ltt = null;
        if (tt instanceof CompositeTriggerType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeTriggerType)tt).getChildren(), bundle, moduleTypeUID, "module-type", locale);
            ltt = new CompositeTriggerType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, tt.getTags(), tt.getVisibility(), outputs, modules);
        } else {
            ltt = new TriggerType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, tt.getTags(), tt.getVisibility(), outputs);
        }
        return ltt;
    }
}

