/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ModuleI18nUtil;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.RuleTemplateI18nUtil;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.RuleTemplateProvider;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.osgi.framework.Bundle;

public class TemplateResourceBundleProvider
extends AbstractResourceBundleProvider<RuleTemplate>
implements RuleTemplateProvider {
    public TemplateResourceBundleProvider() {
        this.listeners = new LinkedList();
        this.path = String.valueOf(PATH) + "/templates/";
    }

    public Collection<RuleTemplate> getAll() {
        return this.providedObjectsHolder.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderChangeListener(ProviderChangeListener<RuleTemplate> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviderChangeListener(ProviderChangeListener<RuleTemplate> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public RuleTemplate getTemplate(String UID, Locale locale) {
        return this.getPerLocale((RuleTemplate)this.providedObjectsHolder.get(UID), locale);
    }

    public Collection<RuleTemplate> getTemplates(Locale locale) {
        ArrayList<RuleTemplate> templatesList = new ArrayList<RuleTemplate>();
        for (RuleTemplate t : this.providedObjectsHolder.values()) {
            templatesList.add(this.getPerLocale(t, locale));
        }
        return templatesList;
    }

    private RuleTemplate getPerLocale(RuleTemplate defTemplate, Locale locale) {
        if (locale == null || defTemplate == null || this.i18nProvider == null) {
            return defTemplate;
        }
        String uid = defTemplate.getUID();
        Bundle bundle = this.getBundle(uid);
        if (defTemplate instanceof RuleTemplate) {
            String llabel = RuleTemplateI18nUtil.getLocalizedRuleTemplateLabel(this.i18nProvider, bundle, uid, defTemplate.getLabel(), locale);
            String ldescription = RuleTemplateI18nUtil.getLocalizedRuleTemplateDescription(this.i18nProvider, bundle, uid, defTemplate.getDescription(), locale);
            List<ConfigDescriptionParameter> lconfigDescriptions = this.getLocalizedConfigurationDescription(this.i18nProvider, defTemplate.getConfigurationDescriptions(), bundle, uid, "rule-template", locale);
            List lactions = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, defTemplate.getActions(), bundle, uid, "rule-template", locale);
            List lconditions = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, defTemplate.getConditions(), bundle, uid, "rule-template", locale);
            List ltriggers = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, defTemplate.getTriggers(), bundle, uid, "rule-template", locale);
            return new RuleTemplate(uid, llabel, ldescription, defTemplate.getTags(), ltriggers, lconditions, lactions, lconfigDescriptions, defTemplate.getVisibility());
        }
        return null;
    }

    @Override
    protected String getUID(RuleTemplate parsedObject) {
        return parsedObject.getUID();
    }
}

