/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.fsinternetradio.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.binding.fsinternetradio.FSInternetRadioBindingConstants;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.upnp.UpnpDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;

public class FSInternetRadioDiscoveryParticipant
implements UpnpDiscoveryParticipant {
    private static final Map<String, Set<String>> SUPPORTED_RADIO_MODELS = new HashMap<String, Set<String>>();

    static {
        HashSet<String> medionRadios = new HashSet<String>();
        SUPPORTED_RADIO_MODELS.put("MEDION AG", medionRadios);
        medionRadios.add("MD83813");
        medionRadios.add("MD84017");
        medionRadios.add("MD85651");
        medionRadios.add("MD86062");
        medionRadios.add("MD86250");
        medionRadios.add("MD86562");
        medionRadios.add("MD86672");
        medionRadios.add("MD86698");
        medionRadios.add("MD86869");
        medionRadios.add("MD86891");
        medionRadios.add("MD86955");
        medionRadios.add("MD86988");
        medionRadios.add("MD87090");
        medionRadios.add("MD87180");
        medionRadios.add("MD87238");
        medionRadios.add("MD87267");
        HashSet<String> hamaRadios = new HashSet<String>();
        SUPPORTED_RADIO_MODELS.put("HAMA", hamaRadios);
        hamaRadios.add("IR100");
        hamaRadios.add("IR110");
        hamaRadios.add("IR250");
        hamaRadios.add("IR320");
        hamaRadios.add("DIR3000");
        hamaRadios.add("DIR3100");
        hamaRadios.add("DIR3110");
        HashSet<String> ttmicroRadios = new HashSet<String>();
        SUPPORTED_RADIO_MODELS.put("TTMICRO AS", ttmicroRadios);
        ttmicroRadios.add("PINELL SUPERSOUND");
        HashSet<String> revoRadios = new HashSet<String>();
        SUPPORTED_RADIO_MODELS.put("REVO TECHNOLOGIES LTD", revoRadios);
        revoRadios.add("SUPERCONNECT");
        HashSet<String> robertsRadios = new HashSet<String>();
        SUPPORTED_RADIO_MODELS.put("ROBERTS RADIO LIMITED", robertsRadios);
        robertsRadios.add("ROBERTS STREAM 93I");
        HashSet<String> AUNARadios = new HashSet<String>();
        SUPPORTED_RADIO_MODELS.put("AUNA", AUNARadios);
        AUNARadios.add("CONNECT 150");
    }

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return Collections.singleton(FSInternetRadioBindingConstants.THING_TYPE_RADIO);
    }

    public DiscoveryResult createResult(RemoteDevice device) {
        ThingUID uid = this.getThingUID(device);
        if (uid != null) {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            String ip = this.getIp(device);
            if (ip != null) {
                String model;
                properties.put("ip", ip);
                String manufacturer = this.getManufacturer(device);
                if (manufacturer != null) {
                    properties.put("manufacturer", manufacturer);
                }
                if ((model = this.getModel(device)) != null) {
                    properties.put("model", model);
                }
                DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel(device.getDisplayString()).build();
                return result;
            }
        }
        return null;
    }

    private String getManufacturer(RemoteDevice device) {
        DeviceDetails details = device.getDetails();
        if (details != null && details.getManufacturerDetails() != null) {
            return details.getManufacturerDetails().getManufacturer();
        }
        return null;
    }

    private String getModel(RemoteDevice device) {
        DeviceDetails details = device.getDetails();
        if (details != null && details.getModelDetails() != null) {
            return details.getModelDetails().getModelNumber();
        }
        return null;
    }

    private String getIp(RemoteDevice device) {
        DeviceDetails details = device.getDetails();
        if (details != null && details.getBaseURL() != null) {
            return details.getBaseURL().getHost();
        }
        RemoteDeviceIdentity identity = (RemoteDeviceIdentity)device.getIdentity();
        if (identity != null && identity.getDescriptorURL() != null) {
            return identity.getDescriptorURL().getHost();
        }
        return null;
    }

    public ThingUID getThingUID(RemoteDevice device) {
        DeviceDetails details = device.getDetails();
        if (details != null) {
            String modelNumber;
            ManufacturerDetails manufacturerDetails = details.getManufacturerDetails();
            String manufacturer = manufacturerDetails == null ? null : manufacturerDetails.getManufacturer();
            ModelDetails modelDetails = details.getModelDetails();
            if (modelDetails != null && (modelNumber = modelDetails.getModelNumber()) != null) {
                Set<String> supportedRadios;
                Set<String> supportedRadios2;
                if (manufacturer != null && (supportedRadios2 = SUPPORTED_RADIO_MODELS.get(manufacturer.trim().toUpperCase())) != null && supportedRadios2.contains(modelNumber.toUpperCase())) {
                    return new ThingUID(FSInternetRadioBindingConstants.THING_TYPE_RADIO, details.getSerialNumber());
                }
                String modelName = modelDetails.getModelName();
                if (modelName != null && (supportedRadios = SUPPORTED_RADIO_MODELS.get(modelName.trim().toUpperCase())) != null && supportedRadios.contains(modelNumber.toUpperCase())) {
                    return new ThingUID(FSInternetRadioBindingConstants.THING_TYPE_RADIO, details.getSerialNumber());
                }
            }
        }
        return null;
    }
}

