/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class HttpClient {
    private int timeout = 1000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Result get(String address) throws IOException {
        return this.doNetwork(address, "GET", "");
    }

    public Result post(String address, String body) throws IOException {
        return this.doNetwork(address, "POST", body);
    }

    public Result put(String address, String body) throws IOException {
        return this.doNetwork(address, "PUT", body);
    }

    public Result delete(String address) throws IOException {
        return this.doNetwork(address, "DELETE", "");
    }

    protected Result doNetwork(String address, String requestMethod, @Nullable String body) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(address).openConnection();
        try {
            conn.setRequestMethod(requestMethod);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            if (body != null && !body.equals("")) {
                conn.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
                out.write(body);
                out.close();
            }
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            String output = IOUtils.toString((InputStream)in);
            Result result = new Result(output, conn.getResponseCode());
            return result;
        }
        finally {
            conn.disconnect();
        }
    }

    public static class Result {
        private final String body;
        private final int responseCode;

        public Result(String body, int responseCode) {
            this.body = body;
            this.responseCode = responseCode;
        }

        public String getBody() {
            return this.body;
        }

        public int getResponseCode() {
            return this.responseCode;
        }
    }
}

