/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.handler;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.binding.lifx.internal.LifxChannelFactory;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightCommunicationHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightConfig;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightContext;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightCurrentStateUpdater;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightOnlineStateUpdater;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightPropertiesUpdater;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightState;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightStateChanger;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLightInfraredRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLightPowerRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetWifiInfoRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PowerState;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Products;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SignalStrength;
import org.eclipse.smarthome.binding.lifx.internal.util.LifxMessageUtil;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifxLightHandler
extends BaseThingHandler {
    private final Logger logger = LoggerFactory.getLogger(LifxLightHandler.class);
    private static final Duration MIN_STATUS_INFO_UPDATE_INTERVAL = Duration.ofSeconds(1L);
    private static final Duration MAX_STATE_CHANGE_DURATION = Duration.ofSeconds(4L);
    private final LifxChannelFactory channelFactory;
    private Products product;
    private PercentType powerOnBrightness;
    private String logId;
    private final ReentrantLock lock = new ReentrantLock();
    private CurrentLightState currentLightState;
    private LifxLightState pendingLightState;
    private Map<String, State> channelStates;
    private ThingStatusInfo statusInfo;
    private LocalDateTime lastStatusInfoUpdate = LocalDateTime.MIN;
    private LifxLightCommunicationHandler communicationHandler;
    private LifxLightCurrentStateUpdater currentStateUpdater;
    private LifxLightStateChanger lightStateChanger;
    private LifxLightOnlineStateUpdater onlineStateUpdater;
    private LifxLightPropertiesUpdater propertiesUpdater;

    public LifxLightHandler(@NonNull Thing thing, @NonNull LifxChannelFactory channelFactory) {
        super(thing);
        this.channelFactory = channelFactory;
    }

    public void initialize() {
        block6: {
            try {
                try {
                    this.lock.lock();
                    LifxLightConfig configuration = (LifxLightConfig)this.getConfigAs(LifxLightConfig.class);
                    this.logId = this.getLogId(configuration.getMACAddress(), configuration.getHost());
                    this.product = this.getProduct();
                    this.logger.debug("{} : Initializing handler", (Object)this.logId);
                    this.powerOnBrightness = this.getPowerOnBrightness();
                    this.channelStates = new HashMap<String, State>();
                    this.currentLightState = new CurrentLightState();
                    this.pendingLightState = new LifxLightState();
                    LifxLightContext context = new LifxLightContext(this.logId, this.product, configuration, this.currentLightState, this.pendingLightState, this.scheduler);
                    this.communicationHandler = new LifxLightCommunicationHandler(context);
                    this.currentStateUpdater = new LifxLightCurrentStateUpdater(context, this.communicationHandler);
                    this.onlineStateUpdater = new LifxLightOnlineStateUpdater(context, this.communicationHandler);
                    this.propertiesUpdater = new LifxLightPropertiesUpdater(context, this.communicationHandler);
                    this.propertiesUpdater.addPropertiesUpdateListener(arg_0 -> ((LifxLightHandler)this).updateProperties(arg_0));
                    this.lightStateChanger = new LifxLightStateChanger(context, this.communicationHandler);
                    if (configuration.getMACAddress() != null || configuration.getHost() != null) {
                        this.communicationHandler.start();
                        this.currentStateUpdater.start();
                        this.onlineStateUpdater.start();
                        this.propertiesUpdater.start();
                        this.lightStateChanger.start();
                        this.startOrStopSignalStrengthUpdates();
                        break block6;
                    }
                    this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Configure a Device ID or Host");
                }
                catch (Exception e) {
                    this.logger.debug("{} : Error occurred while initializing handler: {}", new Object[]{this.logId, e.getMessage(), e});
                    this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
                    this.lock.unlock();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void dispose() {
        try {
            this.lock.lock();
            this.logger.debug("{} : Disposing handler", (Object)this.logId);
            if (this.communicationHandler != null) {
                this.communicationHandler.stop();
                this.communicationHandler = null;
            }
            if (this.currentStateUpdater != null) {
                this.currentStateUpdater.stop();
                this.currentStateUpdater = null;
            }
            if (this.onlineStateUpdater != null) {
                this.onlineStateUpdater.stop();
                this.onlineStateUpdater = null;
            }
            if (this.propertiesUpdater != null) {
                this.propertiesUpdater.stop();
                this.propertiesUpdater.removePropertiesUpdateListener(arg_0 -> ((LifxLightHandler)this).updateProperties(arg_0));
                this.propertiesUpdater = null;
            }
            if (this.lightStateChanger != null) {
                this.lightStateChanger.stop();
                this.lightStateChanger = null;
            }
            this.currentLightState = null;
            this.pendingLightState = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getLogId(MACAddress macAddress, InetSocketAddress host) {
        return macAddress != null ? macAddress.getHex() : (host != null ? host.getHostString() : "Unknown");
    }

    private PercentType getPowerOnBrightness() {
        ChannelUID channelUID;
        Channel channel = null;
        if (this.product.isColor()) {
            channelUID = new ChannelUID(this.getThing().getUID(), "color");
            channel = this.getThing().getChannel(channelUID.getId());
        } else {
            channelUID = new ChannelUID(this.getThing().getUID(), "brightness");
            channel = this.getThing().getChannel(channelUID.getId());
        }
        if (channel == null) {
            return null;
        }
        Configuration configuration = channel.getConfiguration();
        Object powerOnBrightness = configuration.get("powerOnBrightness");
        return powerOnBrightness == null ? null : new PercentType(powerOnBrightness.toString());
    }

    private Products getProduct() {
        String propertyValue = (String)this.getThing().getProperties().get("productId");
        try {
            long productID = Long.parseLong(propertyValue);
            return Products.getProductFromProductID(productID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Products.getLikelyProduct(this.getThing().getThingTypeUID());
        }
    }

    private void addRemoveZoneChannels(int zones) {
        ArrayList<Channel> newChannels = new ArrayList<Channel>();
        for (Channel channel : this.getThing().getChannels()) {
            String channelId = channel.getUID().getId();
            if (channelId.startsWith("colorzone") || channelId.startsWith("temperaturezone")) continue;
            newChannels.add(channel);
        }
        int i = 0;
        while (i < zones) {
            newChannels.add(this.channelFactory.createColorZoneChannel(this.getThing().getUID(), i));
            newChannels.add(this.channelFactory.createTemperatureZoneChannel(this.getThing().getUID(), i));
            ++i;
        }
        this.updateThing(this.editThing().withChannels(newChannels).build());
        Map properties = this.editProperties();
        properties.put("zones", Integer.toString(zones));
        this.updateProperties(properties);
    }

    public void channelLinked(ChannelUID channelUID) {
        super.channelLinked(channelUID);
        this.startOrStopSignalStrengthUpdates();
    }

    public void channelUnlinked(ChannelUID channelUID) {
        this.startOrStopSignalStrengthUpdates();
    }

    private void startOrStopSignalStrengthUpdates() {
        this.currentStateUpdater.setUpdateSignalStrength(this.isLinked("signalstrength"));
    }

    private void sendPacket(Packet packet) {
        this.communicationHandler.sendPacket(packet);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        block57: {
            block55: {
                if (!(command instanceof RefreshType)) break block55;
                switch (channelUID.getId()) {
                    case "color": 
                    case "brightness": {
                        this.sendPacket(new GetLightPowerRequest());
                        this.sendPacket(new GetRequest());
                        break;
                    }
                    case "temperature": {
                        this.sendPacket(new GetRequest());
                        break;
                    }
                    case "infrared": {
                        this.sendPacket(new GetLightInfraredRequest());
                        break;
                    }
                    case "signalstrength": {
                        this.sendPacket(new GetWifiInfoRequest());
                        break;
                    }
                }
                break block57;
            }
            boolean supportedCommand = true;
            switch (channelUID.getId()) {
                case "color": {
                    if (command instanceof HSBType) {
                        this.handleHSBCommand((HSBType)command);
                        break;
                    }
                    if (command instanceof PercentType) {
                        this.handlePercentCommand((PercentType)command);
                        break;
                    }
                    if (command instanceof OnOffType) {
                        this.handleOnOffCommand((OnOffType)command);
                        break;
                    }
                    if (command instanceof IncreaseDecreaseType) {
                        this.handleIncreaseDecreaseCommand((IncreaseDecreaseType)command);
                        break;
                    }
                    supportedCommand = false;
                    break;
                }
                case "brightness": {
                    if (command instanceof PercentType) {
                        this.handlePercentCommand((PercentType)command);
                        break;
                    }
                    if (command instanceof OnOffType) {
                        this.handleOnOffCommand((OnOffType)command);
                        break;
                    }
                    if (command instanceof IncreaseDecreaseType) {
                        this.handleIncreaseDecreaseCommand((IncreaseDecreaseType)command);
                        break;
                    }
                    supportedCommand = false;
                    break;
                }
                case "temperature": {
                    if (command instanceof PercentType) {
                        this.handleTemperatureCommand((PercentType)command);
                        break;
                    }
                    if (command instanceof IncreaseDecreaseType) {
                        this.handleIncreaseDecreaseTemperatureCommand((IncreaseDecreaseType)command);
                        break;
                    }
                    supportedCommand = false;
                    break;
                }
                case "infrared": {
                    if (command instanceof PercentType) {
                        this.handleInfraredCommand((PercentType)command);
                        break;
                    }
                    if (command instanceof IncreaseDecreaseType) {
                        this.handleIncreaseDecreaseInfraredCommand((IncreaseDecreaseType)command);
                        break;
                    }
                    supportedCommand = false;
                    break;
                }
                default: {
                    try {
                        if (channelUID.getId().startsWith("colorzone")) {
                            int zoneIndex = Integer.parseInt(channelUID.getId().replace("colorzone", ""));
                            if (command instanceof HSBType) {
                                this.handleHSBCommand((HSBType)command, zoneIndex);
                                break;
                            }
                            if (command instanceof PercentType) {
                                this.handlePercentCommand((PercentType)command, zoneIndex);
                                break;
                            }
                            if (command instanceof IncreaseDecreaseType) {
                                this.handleIncreaseDecreaseCommand((IncreaseDecreaseType)command, zoneIndex);
                                break;
                            }
                            supportedCommand = false;
                            break;
                        }
                        if (channelUID.getId().startsWith("temperaturezone")) {
                            int zoneIndex = Integer.parseInt(channelUID.getId().replace("temperaturezone", ""));
                            if (command instanceof PercentType) {
                                this.handleTemperatureCommand((PercentType)command, zoneIndex);
                                break;
                            }
                            if (command instanceof IncreaseDecreaseType) {
                                this.handleIncreaseDecreaseTemperatureCommand((IncreaseDecreaseType)command, zoneIndex);
                                break;
                            }
                            supportedCommand = false;
                            break;
                        }
                        supportedCommand = false;
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.logger.error("Failed to parse zone index for a command of a light ({}) : {}", (Object)this.logId, (Object)e.getMessage());
                        supportedCommand = false;
                    }
                }
            }
            if (supportedCommand && !(command instanceof OnOffType) && !"infrared".equals(channelUID.getId())) {
                this.getLightStateForCommand().setPowerState(PowerState.ON);
            }
        }
    }

    private LifxLightState getLightStateForCommand() {
        if (!this.isStateChangePending()) {
            this.pendingLightState.copy(this.currentLightState);
        }
        return this.pendingLightState;
    }

    private boolean isStateChangePending() {
        return this.pendingLightState.getDurationSinceLastChange().minus(MAX_STATE_CHANGE_DURATION).isNegative();
    }

    private void handleTemperatureCommand(PercentType temperature) {
        HSBK newColor = this.getLightStateForCommand().getNullSafeColor();
        newColor.setSaturation(PercentType.ZERO);
        newColor.setTemperature(temperature);
        this.getLightStateForCommand().setColor(newColor);
    }

    private void handleTemperatureCommand(PercentType temperature, int zoneIndex) {
        HSBK newColor = this.getLightStateForCommand().getNullSafeColor(zoneIndex);
        newColor.setSaturation(PercentType.ZERO);
        newColor.setTemperature(temperature);
        this.getLightStateForCommand().setColor(newColor, zoneIndex);
    }

    private void handleHSBCommand(HSBType hsb) {
        this.getLightStateForCommand().setColor(hsb);
    }

    private void handleHSBCommand(HSBType hsb, int zoneIndex) {
        this.getLightStateForCommand().setColor(hsb, zoneIndex);
    }

    private void handlePercentCommand(PercentType brightness) {
        this.getLightStateForCommand().setBrightness(brightness);
    }

    private void handlePercentCommand(PercentType brightness, int zoneIndex) {
        this.getLightStateForCommand().setBrightness(brightness, zoneIndex);
    }

    private void handleOnOffCommand(OnOffType onOff) {
        if (this.powerOnBrightness != null) {
            PercentType newBrightness = onOff == OnOffType.ON ? this.powerOnBrightness : new PercentType(0);
            this.getLightStateForCommand().setBrightness(newBrightness);
        }
        this.getLightStateForCommand().setPowerState(onOff);
    }

    private void handleIncreaseDecreaseCommand(IncreaseDecreaseType increaseDecrease) {
        HSBK baseColor = this.getLightStateForCommand().getNullSafeColor();
        PercentType newBrightness = LifxMessageUtil.increaseDecreasePercentType(increaseDecrease, baseColor.getHSB().getBrightness());
        this.handlePercentCommand(newBrightness);
    }

    private void handleIncreaseDecreaseCommand(IncreaseDecreaseType increaseDecrease, int zoneIndex) {
        HSBK baseColor = this.getLightStateForCommand().getNullSafeColor(zoneIndex);
        PercentType newBrightness = LifxMessageUtil.increaseDecreasePercentType(increaseDecrease, baseColor.getHSB().getBrightness());
        this.handlePercentCommand(newBrightness, zoneIndex);
    }

    private void handleIncreaseDecreaseTemperatureCommand(IncreaseDecreaseType increaseDecrease) {
        PercentType baseTemperature = this.getLightStateForCommand().getNullSafeColor().getTemperature();
        PercentType newTemperature = LifxMessageUtil.increaseDecreasePercentType(increaseDecrease, baseTemperature);
        this.handleTemperatureCommand(newTemperature);
    }

    private void handleIncreaseDecreaseTemperatureCommand(IncreaseDecreaseType increaseDecrease, int zoneIndex) {
        PercentType baseTemperature = this.getLightStateForCommand().getNullSafeColor(zoneIndex).getTemperature();
        PercentType newTemperature = LifxMessageUtil.increaseDecreasePercentType(increaseDecrease, baseTemperature);
        this.handleTemperatureCommand(newTemperature, zoneIndex);
    }

    private void handleInfraredCommand(PercentType infrared) {
        this.getLightStateForCommand().setInfrared(infrared);
    }

    private void handleIncreaseDecreaseInfraredCommand(IncreaseDecreaseType increaseDecrease) {
        PercentType baseInfrared = this.getLightStateForCommand().getInfrared();
        if (baseInfrared != null) {
            PercentType newInfrared = LifxMessageUtil.increaseDecreasePercentType(increaseDecrease, baseInfrared);
            this.handleInfraredCommand(newInfrared);
        }
    }

    private void updateStateIfChanged(@NonNull String channel, @NonNull State newState) {
        State oldState = this.channelStates.get(channel);
        if (oldState == null || !oldState.equals(newState)) {
            this.updateState(channel, newState);
            this.channelStates.put(channel, newState);
        }
    }

    private void updateStatusIfChanged(@NonNull ThingStatus status) {
        this.updateStatusIfChanged(status, ThingStatusDetail.NONE);
    }

    private void updateStatusIfChanged(@NonNull ThingStatus status, @NonNull ThingStatusDetail statusDetail) {
        ThingStatusInfo newStatusInfo = new ThingStatusInfo(status, statusDetail, null);
        Duration durationSinceLastUpdate = Duration.between(this.lastStatusInfoUpdate, LocalDateTime.now());
        boolean intervalElapsed = MIN_STATUS_INFO_UPDATE_INTERVAL.minus(durationSinceLastUpdate).isNegative();
        if (this.statusInfo == null || !this.statusInfo.equals((Object)newStatusInfo) || intervalElapsed) {
            this.statusInfo = newStatusInfo;
            this.lastStatusInfoUpdate = LocalDateTime.now();
            this.updateStatus(status, statusDetail);
        }
    }

    public class CurrentLightState
    extends LifxLightState {
        public boolean isOnline() {
            return LifxLightHandler.this.thing.getStatus() == ThingStatus.ONLINE;
        }

        public boolean isOffline() {
            return LifxLightHandler.this.thing.getStatus() == ThingStatus.OFFLINE;
        }

        public void setOnline() {
            LifxLightHandler.this.updateStatusIfChanged(ThingStatus.ONLINE);
        }

        public void setOnline(MACAddress macAddress) {
            LifxLightHandler.this.updateStatusIfChanged(ThingStatus.ONLINE);
            Configuration configuration = LifxLightHandler.this.editConfiguration();
            configuration.put("deviceId", (Object)macAddress.getAsLabel());
            LifxLightHandler.this.updateConfiguration(configuration);
        }

        public void setOffline() {
            LifxLightHandler.this.updateStatusIfChanged(ThingStatus.OFFLINE);
        }

        public void setOfflineByCommunicationError() {
            LifxLightHandler.this.updateStatusIfChanged(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
        }

        @Override
        public void setColors(HSBK[] colors) {
            if (!LifxLightHandler.this.isStateChangePending() || this.isPendingColorStateChangesApplied(this.getPowerState(), colors)) {
                PowerState powerState = LifxLightHandler.this.isStateChangePending() ? LifxLightHandler.this.pendingLightState.getPowerState() : this.getPowerState();
                this.updateColorChannels(powerState, colors);
            }
            super.setColors(colors);
        }

        @Override
        public void setPowerState(PowerState powerState) {
            if (!LifxLightHandler.this.isStateChangePending() || this.isPendingColorStateChangesApplied(powerState, this.getColors())) {
                HSBK[] colors = LifxLightHandler.this.isStateChangePending() ? LifxLightHandler.this.pendingLightState.getColors() : this.getColors();
                this.updateColorChannels(powerState, colors);
            }
            super.setPowerState(powerState);
        }

        private boolean isPendingColorStateChangesApplied(PowerState powerState, HSBK[] colors) {
            return powerState != null && powerState.equals((Object)LifxLightHandler.this.pendingLightState.getPowerState()) && Arrays.equals(colors, LifxLightHandler.this.pendingLightState.getColors());
        }

        private void updateColorChannels(PowerState powerState, HSBK[] colors) {
            HSBK color = colors != null && colors.length > 0 ? colors[0] : null;
            HSBK updateColor = this.nullSafeUpdateColor(powerState, color);
            HSBType hsb = updateColor.getHSB();
            LifxLightHandler.this.updateStateIfChanged("color", (State)hsb);
            LifxLightHandler.this.updateStateIfChanged("brightness", (State)hsb.getBrightness());
            LifxLightHandler.this.updateStateIfChanged("temperature", (State)updateColor.getTemperature());
            this.updateZoneChannels(powerState, colors);
        }

        private HSBK nullSafeUpdateColor(PowerState powerState, HSBK color) {
            HSBK updateColor;
            HSBK hSBK = updateColor = color != null ? color : LifxBindingConstants.DEFAULT_COLOR;
            if (powerState == PowerState.OFF) {
                updateColor = new HSBK(updateColor);
                updateColor.setBrightness(PercentType.ZERO);
            }
            return updateColor;
        }

        @Override
        public void setInfrared(PercentType infrared) {
            if (!LifxLightHandler.this.isStateChangePending() || infrared.equals((Object)LifxLightHandler.this.pendingLightState.getInfrared())) {
                LifxLightHandler.this.updateStateIfChanged("infrared", (State)infrared);
            }
            super.setInfrared(infrared);
        }

        @Override
        public void setSignalStrength(SignalStrength signalStrength) {
            LifxLightHandler.this.updateStateIfChanged("signalstrength", (State)new DecimalType((long)signalStrength.toQualityRating()));
            super.setSignalStrength(signalStrength);
        }

        private void updateZoneChannels(PowerState powerState, HSBK[] colors) {
            int newZones;
            if (!LifxLightHandler.this.product.isMultiZone() || colors == null || colors.length == 0) {
                return;
            }
            int oldZones = this.getColors() != null ? this.getColors().length : 0;
            if (oldZones != (newZones = colors.length)) {
                LifxLightHandler.this.addRemoveZoneChannels(newZones);
            }
            int i = 0;
            while (i < colors.length) {
                HSBK color = colors[i];
                HSBK updateColor = this.nullSafeUpdateColor(powerState, color);
                LifxLightHandler.this.updateStateIfChanged("colorzone" + i, (State)updateColor.getHSB());
                LifxLightHandler.this.updateStateIfChanged("temperaturezone" + i, (State)updateColor.getTemperature());
                ++i;
            }
        }
    }
}

