/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.listener.LifxLightStateListener;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PowerState;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SignalStrength;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;

public class LifxLightState {
    private PowerState powerState;
    private HSBK[] colors;
    private PercentType infrared;
    private SignalStrength signalStrength;
    private LocalDateTime lastChange = LocalDateTime.MIN;
    private List<LifxLightStateListener> listeners = new CopyOnWriteArrayList<LifxLightStateListener>();

    public void copy(LifxLightState other) {
        this.powerState = other.getPowerState();
        this.colors = other.getColors();
        this.infrared = other.getInfrared();
        this.signalStrength = other.getSignalStrength();
    }

    public PowerState getPowerState() {
        return this.powerState;
    }

    public HSBK getColor() {
        return this.colors != null && this.colors.length > 0 ? new HSBK(this.colors[0]) : null;
    }

    public HSBK getColor(int zoneIndex) {
        return this.colors != null && zoneIndex < this.colors.length ? new HSBK(this.colors[zoneIndex]) : null;
    }

    public HSBK getNullSafeColor() {
        HSBK color = this.getColor();
        return color != null ? color : new HSBK(LifxBindingConstants.DEFAULT_COLOR);
    }

    public HSBK getNullSafeColor(int zoneIndex) {
        HSBK color = this.getColor(zoneIndex);
        return color != null ? color : new HSBK(LifxBindingConstants.DEFAULT_COLOR);
    }

    public HSBK[] getColors() {
        if (this.colors == null) {
            return null;
        }
        HSBK[] colorsCopy = new HSBK[this.colors.length];
        int i = 0;
        while (i < this.colors.length) {
            colorsCopy[i] = this.colors[i] != null ? new HSBK(this.colors[i]) : null;
            ++i;
        }
        return colorsCopy;
    }

    public HSBK[] getNullSafeColors() {
        HSBK[] hSBKArray;
        HSBK[] colors = this.getColors();
        if (colors != null) {
            hSBKArray = colors;
        } else {
            HSBK[] hSBKArray2 = new HSBK[1];
            hSBKArray = hSBKArray2;
            hSBKArray2[0] = new HSBK(LifxBindingConstants.DEFAULT_COLOR);
        }
        return hSBKArray;
    }

    public PercentType getInfrared() {
        return this.infrared;
    }

    public SignalStrength getSignalStrength() {
        return this.signalStrength;
    }

    public void setColor(HSBType newHSB) {
        HSBK newColor = this.getNullSafeColor();
        newColor.setHSB(newHSB);
        this.setColor(newColor);
    }

    public void setColor(HSBType newHSB, int zoneIndex) {
        HSBK newColor = this.getNullSafeColor(zoneIndex);
        newColor.setHSB(newHSB);
        this.setColor(newColor, zoneIndex);
    }

    public void setBrightness(PercentType brightness) {
        HSBK[] newColors;
        HSBK[] hSBKArray = newColors = this.getNullSafeColors();
        int n = newColors.length;
        int n2 = 0;
        while (n2 < n) {
            HSBK newColor = hSBKArray[n2];
            newColor.setBrightness(brightness);
            ++n2;
        }
        this.setColors(newColors);
    }

    public void setBrightness(PercentType brightness, int zoneIndex) {
        HSBK newColor = this.getNullSafeColor(zoneIndex);
        newColor.setBrightness(brightness);
        this.setColor(newColor, zoneIndex);
    }

    public void setColor(HSBK newColor) {
        Object[] newColors = this.getNullSafeColors();
        Arrays.fill(newColors, newColor);
        this.setColors((HSBK[])newColors);
    }

    public void setColor(HSBK newColor, int zoneIndex) {
        HSBK[] newColors = this.getNullSafeColors();
        newColors[zoneIndex] = newColor;
        this.setColors(newColors);
    }

    public void setColors(HSBK[] newColors) {
        HSBK[] oldColors = this.colors;
        this.colors = newColors;
        this.updateLastChange();
        this.listeners.forEach(listener -> listener.handleColorsChange(oldColors, newColors));
    }

    public void setPowerState(OnOffType newOnOff) {
        this.setPowerState(PowerState.fromOnOffType(newOnOff));
    }

    public void setPowerState(PowerState newPowerState) {
        PowerState oldPowerState = this.powerState;
        this.powerState = newPowerState;
        this.updateLastChange();
        this.listeners.forEach(listener -> listener.handlePowerStateChange(oldPowerState, newPowerState));
    }

    public void setTemperature(PercentType temperature) {
        HSBK[] newColors;
        HSBK[] hSBKArray = newColors = this.getNullSafeColors();
        int n = newColors.length;
        int n2 = 0;
        while (n2 < n) {
            HSBK newColor = hSBKArray[n2];
            newColor.setTemperature(temperature);
            ++n2;
        }
        this.setColors(newColors);
    }

    public void setTemperature(PercentType temperature, int zoneIndex) {
        HSBK newColor = this.getNullSafeColor(zoneIndex);
        newColor.setTemperature(temperature);
        this.setColor(newColor, zoneIndex);
    }

    public void setInfrared(PercentType newInfrared) {
        PercentType oldInfrared = this.infrared;
        this.infrared = newInfrared;
        this.updateLastChange();
        this.listeners.forEach(listener -> listener.handleInfraredChange(oldInfrared, newInfrared));
    }

    public void setSignalStrength(SignalStrength newSignalStrength) {
        SignalStrength oldSignalStrength = this.signalStrength;
        this.signalStrength = newSignalStrength;
        this.updateLastChange();
        this.listeners.forEach(listener -> listener.handleSignalStrengthChange(oldSignalStrength, newSignalStrength));
    }

    private void updateLastChange() {
        this.lastChange = LocalDateTime.now();
    }

    public Duration getDurationSinceLastChange() {
        return Duration.between(this.lastChange, LocalDateTime.now());
    }

    public void addListener(LifxLightStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LifxLightStateListener listener) {
        this.listeners.remove(listener);
    }
}

