/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.ByteField;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBKField;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class SetColorRequest
extends Packet {
    public static final int TYPE = 102;
    public static final Field<ByteBuffer> FIELD_STREAM = new ByteField(1);
    public static final HSBKField FIELD_COLOR = new HSBKField();
    public static final Field<Long> FIELD_FADE_TIME = new UInt32Field().little();
    private ByteBuffer stream = ByteBuffer.allocate(1);
    private HSBK color;
    private long fadeTime;

    public ByteBuffer getStream() {
        return this.stream;
    }

    public HSBK getColor() {
        return this.color;
    }

    public long getFadeTime() {
        return this.fadeTime;
    }

    public SetColorRequest() {
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    public SetColorRequest(HSBK color, long fadeTime) {
        this();
        this.color = color;
        this.fadeTime = fadeTime;
    }

    @Override
    public int packetType() {
        return 102;
    }

    @Override
    protected int packetLength() {
        return 13;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.stream = FIELD_STREAM.value(bytes);
        this.color = FIELD_COLOR.value(bytes);
        this.fadeTime = FIELD_FADE_TIME.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_STREAM.bytes(this.stream)).put(FIELD_COLOR.bytes(this.color)).put(FIELD_FADE_TIME.bytes(this.fadeTime));
    }

    @Override
    public int[] expectedResponses() {
        return new int[]{107};
    }
}

