/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.pskstore.StaticPskStore;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.binding.tradfri.internal.CoapCallback;
import org.eclipse.smarthome.binding.tradfri.internal.DeviceUpdateListener;
import org.eclipse.smarthome.binding.tradfri.internal.TradfriCoapClient;
import org.eclipse.smarthome.binding.tradfri.internal.TradfriCoapEndpoint;
import org.eclipse.smarthome.binding.tradfri.internal.TradfriCoapHandler;
import org.eclipse.smarthome.binding.tradfri.internal.config.TradfriGatewayConfig;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriGatewayHandler
extends BaseBridgeHandler
implements CoapCallback {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MIN_SUPPORTED_VERSION = "1.2.42";
    private TradfriCoapClient deviceClient;
    private String gatewayURI;
    private String gatewayInfoURI;
    private DTLSConnector dtlsConnector;
    private CoapEndpoint endPoint;
    private final Set<DeviceUpdateListener> deviceUpdateListeners = new CopyOnWriteArraySet<DeviceUpdateListener>();
    private ScheduledFuture<?> scanJob;

    public TradfriGatewayHandler(@NonNull Bridge bridge) {
        super(bridge);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void initialize() {
        TradfriGatewayConfig configuration = (TradfriGatewayConfig)this.getConfigAs(TradfriGatewayConfig.class);
        if (this.isNullOrEmpty(configuration.host)) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Host must be specified in the configuration!");
            return;
        }
        if (this.isNullOrEmpty(configuration.code)) {
            if (this.isNullOrEmpty(configuration.identity) || this.isNullOrEmpty(configuration.preSharedKey)) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Either security code or identity and pre-shared key must be provided in the configuration!");
                return;
            }
            this.establishConnection();
        } else if (this.isOldFirmware()) {
            this.logger.warn("Gateway with old firmware - please consider upgrading to the latest version.");
            Configuration editedConfig = this.editConfiguration();
            editedConfig.put("identity", (Object)"");
            editedConfig.put("preSharedKey", (Object)configuration.code);
            this.updateConfiguration(editedConfig);
            this.establishConnection();
        } else {
            this.updateStatus(ThingStatus.UNKNOWN);
            this.scheduler.execute(() -> {
                boolean success = this.obtainIdentityAndPreSharedKey();
                if (success) {
                    this.establishConnection();
                }
            });
        }
    }

    private void establishConnection() {
        TradfriGatewayConfig configuration = (TradfriGatewayConfig)this.getConfigAs(TradfriGatewayConfig.class);
        this.gatewayURI = "coaps://" + configuration.host + ":" + configuration.port + "/" + "15001";
        this.gatewayInfoURI = "coaps://" + configuration.host + ":" + configuration.port + "/" + "15011" + "/" + "15012";
        try {
            URI uri = new URI(this.gatewayURI);
            this.deviceClient = new TradfriCoapClient(uri);
        }
        catch (URISyntaxException e) {
            this.logger.error("Illegal gateway URI '{}': {}", (Object)this.gatewayURI, (Object)e.getMessage());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        DtlsConnectorConfig.Builder builder = new DtlsConnectorConfig.Builder(new InetSocketAddress(0));
        builder.setPskStore((PskStore)new StaticPskStore(configuration.identity, configuration.preSharedKey.getBytes()));
        this.dtlsConnector = new DTLSConnector(builder.build());
        this.endPoint = new TradfriCoapEndpoint(this.dtlsConnector, NetworkConfig.getStandard());
        this.deviceClient.setEndpoint((Endpoint)this.endPoint);
        this.updateStatus(ThingStatus.UNKNOWN);
        this.scanJob = this.scheduler.scheduleWithFixedDelay(this::startScan, 0L, 1L, TimeUnit.MINUTES);
    }

    protected boolean obtainIdentityAndPreSharedKey() {
        CoapResponse gatewayResponse;
        String responseText;
        String authUrl;
        String identity;
        block7: {
            String preSharedKey;
            TradfriGatewayConfig configuration;
            block8: {
                JsonObject json;
                block6: {
                    configuration = (TradfriGatewayConfig)this.getConfigAs(TradfriGatewayConfig.class);
                    identity = UUID.randomUUID().toString().replace("-", "");
                    preSharedKey = null;
                    authUrl = null;
                    responseText = null;
                    DtlsConnectorConfig.Builder builder = new DtlsConnectorConfig.Builder(new InetSocketAddress(0));
                    builder.setPskStore((PskStore)new StaticPskStore("Client_identity", configuration.code.getBytes()));
                    DTLSConnector dtlsConnector = new DTLSConnector(builder.build());
                    CoapEndpoint authEndpoint = new CoapEndpoint((Connector)dtlsConnector, NetworkConfig.getStandard());
                    authUrl = "coaps://" + configuration.host + ":" + configuration.port + "/15011/9063";
                    CoapClient deviceClient = new CoapClient(new URI(authUrl));
                    deviceClient.setTimeout(TimeUnit.SECONDS.toMillis(10L));
                    deviceClient.setEndpoint((Endpoint)authEndpoint);
                    json = new JsonObject();
                    json.addProperty("9090", identity);
                    gatewayResponse = deviceClient.post(json.toString(), 0);
                    authEndpoint.destroy();
                    deviceClient.shutdown();
                    if (gatewayResponse != null) break block6;
                    this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "No response from gateway. Might be due to an invalid security code.");
                    return false;
                }
                if (!gatewayResponse.isSuccess()) break block7;
                responseText = gatewayResponse.getResponseText();
                json = new JsonParser().parse(responseText).getAsJsonObject();
                preSharedKey = json.get("9091").getAsString();
                if (!this.isNullOrEmpty(preSharedKey)) break block8;
                this.logger.error("Received pre-shared key is empty for thing {} on gateway at {}", (Object)this.getThing().getUID(), (Object)configuration.host);
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "Pre-shared key was not obtain successfully");
                return false;
            }
            this.logger.info("Received pre-shared key for gateway '{}'", (Object)configuration.host);
            this.logger.debug("Using identity '{}' with pre-shared key '{}'.", (Object)identity, (Object)preSharedKey);
            Configuration editedConfig = this.editConfiguration();
            editedConfig.put("code", null);
            editedConfig.put("identity", (Object)identity);
            editedConfig.put("preSharedKey", (Object)preSharedKey);
            this.updateConfiguration(editedConfig);
            return true;
        }
        try {
            this.logger.warn("Failed obtaining pre-shared key for identity '{}' (response code '{}', response text '{}')", new Object[]{identity, gatewayResponse.getCode(), this.isNullOrEmpty(gatewayResponse.getResponseText()) ? "<empty>" : gatewayResponse.getResponseText()});
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, String.format("Failed obtaining pre-shared key with status code '%s'", gatewayResponse.getCode()));
        }
        catch (URISyntaxException e) {
            this.logger.error("Illegal gateway URI '{}'", authUrl, (Object)e);
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
        }
        catch (JsonParseException e) {
            this.logger.warn("Invalid response recieved from gateway '{}'", responseText, (Object)e);
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, String.format("Invalid response recieved from gateway '%s'", responseText));
        }
        return false;
    }

    public void dispose() {
        if (this.scanJob != null) {
            this.scanJob.cancel(true);
            this.scanJob = null;
        }
        if (this.deviceClient != null) {
            this.deviceClient.shutdown();
            this.deviceClient = null;
        }
        if (this.endPoint != null) {
            this.endPoint.destroy();
            this.endPoint = null;
        }
        super.dispose();
    }

    public void startScan() {
        if (this.endPoint != null) {
            this.requestGatewayInfo();
            this.deviceClient.get(new TradfriCoapHandler(this));
        }
    }

    public String getGatewayURI() {
        return this.gatewayURI;
    }

    public CoapEndpoint getEndpoint() {
        return this.endPoint;
    }

    @Override
    public void onUpdate(JsonElement data) {
        this.logger.debug("onUpdate response: {}", (Object)data);
        if (this.endPoint != null) {
            try {
                JsonArray array = data.getAsJsonArray();
                int i = 0;
                while (i < array.size()) {
                    this.requestDeviceDetails(array.get(i).getAsString());
                    ++i;
                }
            }
            catch (JsonSyntaxException e) {
                this.logger.debug("JSON error: {}", (Object)e.getMessage());
                this.setStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
            }
        }
    }

    private synchronized void requestGatewayInfo() {
        this.deviceClient.setURI(this.gatewayInfoURI);
        this.deviceClient.asyncGet().thenAccept(data -> {
            JsonObject json = new JsonParser().parse(data).getAsJsonObject();
            String firmwareVersion = json.get("9029").getAsString();
            this.getThing().setProperty("firmwareVersion", firmwareVersion);
        });
        this.deviceClient.setURI(this.gatewayURI);
    }

    private synchronized void requestDeviceDetails(String instanceId) {
        this.deviceClient.setURI(String.valueOf(this.gatewayURI) + "/" + instanceId);
        this.deviceClient.asyncGet().thenAccept(data -> {
            this.logger.debug("requestDeviceDetails response: {}", data);
            JsonObject json = new JsonParser().parse(data).getAsJsonObject();
            this.deviceUpdateListeners.forEach(listener -> listener.onUpdate(instanceId, json));
        });
        this.deviceClient.setURI(this.gatewayURI);
    }

    @Override
    public void setStatus(ThingStatus status, ThingStatusDetail statusDetail) {
        if (this.endPoint != null) {
            this.updateStatus(status, statusDetail);
            if (this.dtlsConnector != null && status == ThingStatus.OFFLINE) {
                try {
                    this.dtlsConnector.stop();
                    this.dtlsConnector.start();
                }
                catch (IOException e) {
                    this.logger.debug("Error restarting the DTLS connector: {}", (Object)e.getMessage());
                }
            }
        }
    }

    public void registerDeviceUpdateListener(DeviceUpdateListener listener) {
        this.deviceUpdateListeners.add(listener);
    }

    public void unregisterDeviceUpdateListener(DeviceUpdateListener listener) {
        this.deviceUpdateListeners.remove(listener);
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private boolean isOldFirmware() {
        String currentFirmware = (String)this.thing.getProperties().get("firmwareVersion");
        return currentFirmware == null || MIN_SUPPORTED_VERSION.compareTo(currentFirmware) > 0;
    }

    public void thingUpdated(Thing thing) {
        super.thingUpdated(thing);
        this.logger.info("Bridge configuration updated. Updating paired things (if any).");
        for (Thing t : this.getThing().getThings()) {
            ThingHandler thingHandler = t.getHandler();
            if (thingHandler == null) continue;
            thingHandler.thingUpdated(t);
        }
    }
}

