/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal;

import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.PercentType;

public class TradfriColor {
    private static final double[] PRESET_X = new double[]{24933.0, 30138.0, 33137.0};
    private static final double[] PRESET_Y = new double[]{24691.0, 26909.0, 27211.0};
    public Integer rgbR;
    public Integer rgbG;
    public Integer rgbB;
    public Integer xyX;
    public Integer xyY;
    public Integer brightness;
    public HSBType hsbType;

    private TradfriColor(Integer rgbR, Integer rgbG, Integer rgbB, Integer xyX, Integer xyY, Integer brightness, HSBType hsbType) {
        this.rgbR = rgbR;
        this.rgbG = rgbG;
        this.rgbB = rgbB;
        this.xyX = xyX;
        this.xyY = xyY;
        this.brightness = brightness;
        this.hsbType = hsbType;
    }

    public static TradfriColor fromCie(int xyX, int xyY, int xyBrightness) {
        int brightness = xyBrightness;
        if (brightness > 254) {
            brightness = 254;
        }
        double x = TradfriColor.unnormalize(xyX);
        double y = TradfriColor.unnormalize(xyY);
        double z = 1.0 - x - y;
        double Y = (double)brightness / 254.0;
        double X = Y / y * x;
        double Z = Y / y * z;
        double red = X * 1.656492 - Y * 0.354851 - Z * 0.255038;
        double green = -X * 0.707196 + Y * 1.655397 + Z * 0.036152;
        double blue = X * 0.051713 - Y * 0.121364 + Z * 1.01153;
        if (red > blue && red > green && red > 1.0) {
            green /= red;
            blue /= red;
            red = 1.0;
        } else if (green > blue && green > red && green > 1.0) {
            red /= green;
            blue /= green;
            green = 1.0;
        } else if (blue > red && blue > green && blue > 1.0) {
            red /= blue;
            green /= blue;
            blue = 1.0;
        }
        red = Math.max(0.0, red);
        green = Math.max(0.0, green);
        blue = Math.max(0.0, blue);
        int redRounded = (int)Math.round(red * 255.0);
        int greenRounded = (int)Math.round(green * 255.0);
        int blueRounded = (int)Math.round(blue * 255.0);
        HSBType hsbType = TradfriColor.constructHsbTypeFromRgbWithBrightnessPercent(redRounded, greenRounded, blueRounded, brightness);
        int rgbR = (int)((double)hsbType.getRed().intValue() * 2.55);
        int rgbG = (int)((double)hsbType.getGreen().intValue() * 2.55);
        int rgbB = (int)((double)hsbType.getBlue().intValue() * 2.55);
        return new TradfriColor(rgbR, rgbG, rgbB, xyX, xyY, brightness, hsbType);
    }

    public static TradfriColor fromHSBType(HSBType hsbType) {
        double red = (double)hsbType.getRed().intValue() * 2.55;
        double green = (double)hsbType.getGreen().intValue() * 2.55;
        double blue = (double)hsbType.getBlue().intValue() * 2.55;
        int rgbR = (int)red;
        int rgbG = (int)green;
        int rgbB = (int)blue;
        double X = red * 0.664511 + green * 0.154324 + blue * 0.162028;
        double Y = red * 0.283881 + green * 0.668433 + blue * 0.047685;
        double Z = red * 8.8E-5 + green * 0.07231 + blue * 0.986039;
        double x = X / (X + Y + Z);
        double y = Y / (X + Y + Z);
        int xyX = TradfriColor.normalize(x);
        int xyY = TradfriColor.normalize(y);
        int brightness = (int)((double)hsbType.getBrightness().intValue() * 2.54);
        HSBType hsbTypeConcreteValues = TradfriColor.constructHsbTypeFromRgbWithBrightnessPercent(rgbR, rgbG, rgbB, brightness);
        return new TradfriColor(rgbR, rgbG, rgbB, xyX, xyY, brightness, hsbTypeConcreteValues);
    }

    public static TradfriColor fromColorTemperature(PercentType percentType) {
        int y;
        int x;
        double percent = percentType.doubleValue();
        if (percent < 50.0) {
            double p = percent / 50.0;
            x = (int)Math.round(PRESET_X[0] + p * (PRESET_X[1] - PRESET_X[0]));
            y = (int)Math.round(PRESET_Y[0] + p * (PRESET_Y[1] - PRESET_Y[0]));
        } else {
            double p = (percent - 50.0) / 50.0;
            x = (int)Math.round(PRESET_X[1] + p * (PRESET_X[2] - PRESET_X[1]));
            y = (int)Math.round(PRESET_Y[1] + p * (PRESET_Y[2] - PRESET_Y[1]));
        }
        return new TradfriColor(null, null, null, x, y, null, null);
    }

    private static int normalize(double value) {
        return (int)(value * 65535.0 + 0.5);
    }

    private static double unnormalize(int value) {
        return (double)value / 65535.0;
    }

    private static HSBType constructHsbTypeFromRgbWithBrightnessPercent(int rgbR, int rgbG, int rgbB, int xyBrightness) {
        HSBType hsbFullBright = HSBType.fromRGB((int)rgbR, (int)rgbG, (int)rgbB);
        PercentType brightnessPercent = TradfriColor.xyBrightnessToPercentType(xyBrightness);
        HSBType hsb = new HSBType(hsbFullBright.getHue(), hsbFullBright.getSaturation(), brightnessPercent);
        return hsb;
    }

    public static PercentType calculateColorTemperature(int xyX, int xyY) {
        double x = xyX;
        double y = xyY;
        double value = 0.0;
        if (x > PRESET_X[1] && y > PRESET_Y[1] && x <= PRESET_X[2] && y <= PRESET_Y[2]) {
            value = (x - PRESET_X[1]) / (PRESET_X[2] - PRESET_X[1]) / 2.0 + 0.5;
        } else if (x >= PRESET_X[0] && y >= PRESET_Y[0] && x <= PRESET_X[1] + 2.0 && y <= PRESET_Y[1]) {
            value = (x - PRESET_X[0]) / (PRESET_X[1] - PRESET_X[0]) / 2.0;
        } else if (x < PRESET_X[0]) {
            value = 0.0;
        } else if (x > PRESET_X[2]) {
            value = 1.0;
        }
        return new PercentType((int)Math.round(value * 100.0));
    }

    public static PercentType xyBrightnessToPercentType(int xyBrightness) {
        if (xyBrightness > 254) {
            xyBrightness = 254;
        } else if (xyBrightness < 0) {
            xyBrightness = 0;
        }
        return new PercentType((int)Math.ceil((double)xyBrightness / 2.54));
    }
}

