/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.handler;

import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.wemo.WemoBindingConstants;
import org.eclipse.smarthome.binding.wemo.internal.http.WemoHttpCall;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOParticipant;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WemoCoffeeHandler
extends BaseThingHandler
implements UpnpIOParticipant,
DiscoveryListener {
    private final Logger logger = LoggerFactory.getLogger(WemoCoffeeHandler.class);
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(WemoBindingConstants.THING_TYPE_COFFEE);
    private Map<String, Boolean> subscriptionState = new HashMap<String, Boolean>();
    private final Map<String, String> stateMap = Collections.synchronizedMap(new HashMap());
    protected static final int SUBSCRIPTION_DURATION = 600;
    private UpnpIOService service;
    private final int REFRESH_INTERVAL = 60;
    private ScheduledFuture<?> refreshJob;
    private final Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (!WemoCoffeeHandler.this.isUpnpDeviceRegistered()) {
                    WemoCoffeeHandler.this.logger.debug("WeMo UPnP device {} not yet registered", (Object)WemoCoffeeHandler.this.getUDN());
                }
                WemoCoffeeHandler.this.updateWemoState();
                WemoCoffeeHandler.this.onSubscription();
            }
            catch (Exception e) {
                WemoCoffeeHandler.this.logger.debug("Exception during poll : {}", (Throwable)e);
                WemoCoffeeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
            }
        }
    };

    public WemoCoffeeHandler(Thing thing, UpnpIOService upnpIOService) {
        super(thing);
        this.logger.debug("Creating a WemoCoffeeHandler V0.4 for thing '{}'", (Object)this.getThing().getUID());
        if (upnpIOService != null) {
            this.service = upnpIOService;
        } else {
            this.logger.debug("upnpIOService not set.");
        }
    }

    public void initialize() {
        Configuration configuration = this.getConfig();
        if (configuration.get("udn") != null) {
            this.logger.debug("Initializing WemoCoffeeHandler for UDN '{}'", configuration.get("udn"));
            this.onSubscription();
            this.onUpdate();
            this.updateStatus(ThingStatus.ONLINE);
        } else {
            this.logger.debug("Cannot initalize WemoCoffeeHandler. UDN not set.");
        }
    }

    public void thingDiscovered(DiscoveryService source, DiscoveryResult result) {
        if (result.getThingUID().equals((Object)this.getThing().getUID()) && this.getThing().getConfiguration().get("udn").equals(result.getProperties().get("udn"))) {
            this.logger.trace("Discovered UDN '{}' for thing '{}'", result.getProperties().get("udn"), (Object)this.getThing().getUID());
            this.updateStatus(ThingStatus.ONLINE);
            this.onSubscription();
            this.onUpdate();
        }
    }

    public void thingRemoved(DiscoveryService source, ThingUID thingUID) {
        if (thingUID.equals((Object)this.getThing().getUID())) {
            this.logger.trace("Setting status for thing '{}' to OFFLINE", (Object)this.getThing().getUID());
            this.updateStatus(ThingStatus.OFFLINE);
        }
    }

    public void dispose() {
        this.logger.debug("WeMoCoffeeHandler disposed.");
        this.removeSubscription();
        if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
            this.refreshJob.cancel(true);
            this.refreshJob = null;
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        this.logger.trace("Command '{}' received for channel '{}'", (Object)command, (Object)channelUID);
        if (command instanceof RefreshType) {
            try {
                this.updateWemoState();
            }
            catch (Exception e) {
                this.logger.debug("Exception during poll : {}", (Throwable)e);
            }
        } else if (channelUID.getId().equals("state") && command instanceof OnOffType) {
            if (command.equals(OnOffType.ON)) {
                try {
                    String wemoCallResponse;
                    String soapHeader = "\"urn:Belkin:service:deviceevent:1#SetAttributes\"";
                    String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:SetAttributes xmlns:u=\"urn:Belkin:service:deviceevent:1\"><attributeList>&lt;attribute&gt;&lt;name&gt;Brewed&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;LastCleaned&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;ModeTime&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;Brewing&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;TimeRemaining&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;WaterLevelReached&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;Mode&lt;/name&gt;&lt;value&gt;4&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;CleanAdvise&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;FilterAdvise&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;&lt;attribute&gt;&lt;name&gt;Cleaning&lt;/name&gt;&lt;value&gt;NULL&lt;/value&gt;&lt;/attribute&gt;</attributeList></u:SetAttributes></s:Body></s:Envelope>";
                    String wemoURL = this.getWemoURL("deviceevent");
                    if (wemoURL != null && (wemoCallResponse = WemoHttpCall.executeCall(wemoURL, soapHeader, content)) != null) {
                        this.updateState("state", (State)OnOffType.ON);
                        StringType newMode = new StringType("Brewing");
                        this.updateState("coffeeMode", (State)newMode);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to send command '{}' for device '{}': {}", new Object[]{command, this.getThing().getUID(), e.getMessage()});
                    this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
                }
            } else {
                command.equals(OnOffType.OFF);
            }
            this.updateStatus(ThingStatus.ONLINE);
        }
    }

    public void onServiceSubscribed(String service, boolean succeeded) {
        this.logger.debug("WeMo {}: Subscription to service {} {}", new Object[]{this.getUDN(), service, succeeded ? "succeeded" : "failed"});
        this.subscriptionState.put(service, succeeded);
    }

    public void onValueReceived(String variable, String value, String service) {
    }

    private synchronized void onSubscription() {
        if (this.service.isRegistered((UpnpIOParticipant)this)) {
            this.logger.debug("Checking WeMo GENA subscription for '{}'", (Object)this);
            String subscription = "deviceevent1";
            if (this.subscriptionState.get(subscription) == null || !this.subscriptionState.get(subscription).booleanValue()) {
                this.logger.debug("Setting up GENA subscription {}: Subscribing to service {}...", (Object)this.getUDN(), (Object)subscription);
                this.service.addSubscription((UpnpIOParticipant)this, subscription, 600);
                this.subscriptionState.put(subscription, true);
            }
        } else {
            this.logger.debug("Setting up WeMo GENA subscription for '{}' FAILED - service.isRegistered(this) is FALSE", (Object)this);
        }
    }

    private synchronized void removeSubscription() {
        this.logger.debug("Removing WeMo GENA subscription for '{}'", (Object)this);
        if (this.service.isRegistered((UpnpIOParticipant)this)) {
            String subscription = "deviceevent1";
            if (this.subscriptionState.get(subscription) != null && this.subscriptionState.get(subscription).booleanValue()) {
                this.logger.debug("WeMo {}: Unsubscribing from service {}...", (Object)this.getUDN(), (Object)subscription);
                this.service.removeSubscription((UpnpIOParticipant)this, subscription);
            }
            this.subscriptionState = new HashMap<String, Boolean>();
            this.service.unregisterParticipant((UpnpIOParticipant)this);
        }
    }

    private synchronized void onUpdate() {
        if (this.refreshJob == null || this.refreshJob.isCancelled()) {
            Configuration config = this.getThing().getConfiguration();
            int refreshInterval = 60;
            Object refreshConfig = config.get("pollingInterval");
            if (refreshConfig != null) {
                refreshInterval = ((BigDecimal)refreshConfig).intValue();
                this.logger.debug("Setting WemoCoffeeHandler refreshInterval to '{}' seconds", (Object)refreshInterval);
            }
            this.refreshJob = this.scheduler.scheduleWithFixedDelay(this.refreshRunnable, 0L, refreshInterval, TimeUnit.SECONDS);
        }
    }

    private boolean isUpnpDeviceRegistered() {
        return this.service.isRegistered((UpnpIOParticipant)this);
    }

    public String getUDN() {
        return (String)this.getThing().getConfiguration().get("udn");
    }

    protected void updateWemoState() {
        block64: {
            String action = "GetAttributes";
            String actionService = "deviceevent";
            String soapHeader = "\"urn:Belkin:service:" + actionService + ":1#" + action + "\"";
            String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:" + action + " xmlns:u=\"urn:Belkin:service:" + actionService + ":1\">" + "</u:" + action + ">" + "</s:Body>" + "</s:Envelope>";
            try {
                String wemoCallResponse;
                String wemoURL = this.getWemoURL(actionService);
                if (wemoURL == null || (wemoCallResponse = WemoHttpCall.executeCall(wemoURL, soapHeader, content)) == null) break block64;
                try {
                    String stringParser = StringUtils.substringBetween((String)wemoCallResponse, (String)"<attributeList>", (String)"</attributeList>");
                    stringParser = StringEscapeUtils.unescapeXml((String)stringParser);
                    stringParser = StringEscapeUtils.unescapeXml((String)stringParser);
                    this.logger.trace("CoffeeMaker response '{}' for device '{}' received", (Object)stringParser, (Object)this.getThing().getUID());
                    stringParser = "<data>" + stringParser + "</data>";
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(stringParser));
                    Document doc = db.parse(is);
                    NodeList nodes = doc.getElementsByTagName("attribute");
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element element = (Element)nodes.item(i);
                        NodeList deviceIndex = element.getElementsByTagName("name");
                        Element line = (Element)deviceIndex.item(0);
                        String attributeName = WemoCoffeeHandler.getCharacterDataFromElement(line);
                        this.logger.trace("attributeName: {}", (Object)attributeName);
                        NodeList deviceID = element.getElementsByTagName("value");
                        line = (Element)deviceID.item(0);
                        String attributeValue = WemoCoffeeHandler.getCharacterDataFromElement(line);
                        this.logger.trace("attributeValue: {}", (Object)attributeValue);
                        switch (attributeName) {
                            case "Mode": {
                                StringType newMode = new StringType("Brewing");
                                switch (attributeValue) {
                                    case "0": {
                                        this.updateState("state", (State)OnOffType.ON);
                                        newMode = new StringType("Refill");
                                        this.updateState("coffeeMode", (State)newMode);
                                        break;
                                    }
                                    case "1": {
                                        this.updateState("state", (State)OnOffType.OFF);
                                        newMode = new StringType("PlaceCarafe");
                                        this.updateState("coffeeMode", (State)newMode);
                                        break;
                                    }
                                    case "2": {
                                        this.updateState("state", (State)OnOffType.OFF);
                                        newMode = new StringType("RefillWater");
                                        this.updateState("coffeeMode", (State)newMode);
                                        break;
                                    }
                                    case "3": {
                                        this.updateState("state", (State)OnOffType.OFF);
                                        newMode = new StringType("Ready");
                                        this.updateState("coffeeMode", (State)newMode);
                                        break;
                                    }
                                    case "4": {
                                        this.updateState("state", (State)OnOffType.ON);
                                        newMode = new StringType("Brewing");
                                        this.updateState("coffeeMode", (State)newMode);
                                        break;
                                    }
                                    case "5": {
                                        this.updateState("state", (State)OnOffType.OFF);
                                        newMode = new StringType("Brewed");
                                        this.updateState("coffeeMode", (State)newMode);
                                        break;
                                    }
                                    case "6": {
                                        this.updateState("state", (State)OnOffType.OFF);
                                        newMode = new StringType("CleaningBrewing");
                                        this.updateState("coffeeMode", (State)newMode);
                                        break;
                                    }
                                    case "7": {
                                        this.updateState("state", (State)OnOffType.OFF);
                                        newMode = new StringType("CleaningSoaking");
                                        this.updateState("coffeeMode", (State)newMode);
                                        break;
                                    }
                                    case "8": {
                                        this.updateState("state", (State)OnOffType.OFF);
                                        newMode = new StringType("BrewFailCarafeRemoved");
                                        this.updateState("coffeeMode", (State)newMode);
                                    }
                                }
                                break;
                            }
                            case "ModeTime": {
                                if (attributeValue == null) break;
                                State newAttributeValue = new DecimalType(attributeValue);
                                this.updateState("modeTime", newAttributeValue);
                                break;
                            }
                            case "TimeRemaining": {
                                if (attributeValue == null) break;
                                State newAttributeValue = new DecimalType(attributeValue);
                                this.updateState("timeRemaining", newAttributeValue);
                                break;
                            }
                            case "WaterLevelReached": {
                                if (attributeValue == null) break;
                                State newAttributeValue = new DecimalType(attributeValue);
                                this.updateState("waterLevelReached", newAttributeValue);
                                break;
                            }
                            case "CleanAdvise": {
                                if (attributeValue == null) break;
                                State newAttributeValue = attributeValue.equals("0") ? OnOffType.OFF : OnOffType.ON;
                                this.updateState("cleanAdvise", newAttributeValue);
                                break;
                            }
                            case "FilterAdvise": {
                                if (attributeValue == null) break;
                                State newAttributeValue = attributeValue.equals("0") ? OnOffType.OFF : OnOffType.ON;
                                this.updateState("filterAdvise", newAttributeValue);
                                break;
                            }
                            case "Brewed": {
                                State newAttributeValue;
                                if (attributeValue == null || (newAttributeValue = this.getDateTimeState(attributeValue)) == null) break;
                                this.updateState("brewed", newAttributeValue);
                                break;
                            }
                            case "LastCleaned": {
                                State newAttributeValue;
                                if (attributeValue == null || (newAttributeValue = this.getDateTimeState(attributeValue)) == null) break;
                                this.updateState("lastCleaned", newAttributeValue);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse attributeList for WeMo CoffeMaker '{}'", (Object)this.getThing().getUID(), (Object)e);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to get attributes for device '{}'", (Object)this.getThing().getUID(), (Object)e);
            }
        }
    }

    public State getDateTimeState(String attributeValue) {
        if (attributeValue != null) {
            long value = 0L;
            try {
                value = Long.parseLong(attributeValue) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.error("Unable to parse attributeValue '{}' for device '{}'; expected long", (Object)attributeValue, (Object)this.getThing().getUID());
                return null;
            }
            ZonedDateTime zoned = ZonedDateTime.ofInstant(Instant.ofEpochMilli(value), TimeZone.getDefault().toZoneId());
            DateTimeType dateTimeState = new DateTimeType(zoned);
            if (dateTimeState != null) {
                this.logger.trace("New attribute brewed '{}' received", (Object)dateTimeState);
                return dateTimeState;
            }
        }
        return null;
    }

    public String getWemoURL(String actionService) {
        URL descriptorURL = this.service.getDescriptorURL((UpnpIOParticipant)this);
        String wemoURL = null;
        if (descriptorURL != null) {
            String deviceURL = StringUtils.substringBefore((String)descriptorURL.toString(), (String)"/setup.xml");
            wemoURL = String.valueOf(deviceURL) + "/upnp/control/" + actionService + "1";
            return wemoURL;
        }
        return null;
    }

    public static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    public void onStatusChanged(boolean status) {
    }

    public Collection<ThingUID> removeOlderResults(DiscoveryService source, long timestamp, Collection<ThingTypeUID> thingTypeUIDs, ThingUID bridgeUID) {
        return Collections.emptyList();
    }
}

