/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.internal.discovery;

import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.wemo.WemoBindingConstants;
import org.eclipse.smarthome.binding.wemo.handler.WemoBridgeHandler;
import org.eclipse.smarthome.binding.wemo.internal.http.WemoHttpCall;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOParticipant;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WemoLinkDiscoveryService
extends AbstractDiscoveryService
implements UpnpIOParticipant {
    private final Logger logger = LoggerFactory.getLogger(WemoLinkDiscoveryService.class);
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(WemoBindingConstants.THING_TYPE_MZ100);
    public static final String NORMALIZE_ID_REGEX = "[^a-zA-Z0-9_]";
    private static final int SEARCH_TIME = 20;
    private static final int INITIAL_DELAY = 5;
    private static final int SCAN_INTERVAL = 120;
    private final WemoBridgeHandler wemoBridgeHandler;
    private final WemoLinkScan scanningRunnable;
    private ScheduledFuture<?> scanningJob;
    private UpnpIOService service;

    public WemoLinkDiscoveryService(WemoBridgeHandler wemoBridgeHandler, UpnpIOService upnpIOService) {
        super(20);
        this.wemoBridgeHandler = wemoBridgeHandler;
        if (upnpIOService != null) {
            this.service = upnpIOService;
        } else {
            this.logger.debug("upnpIOService not set.");
        }
        this.scanningRunnable = new WemoLinkScan();
        if (wemoBridgeHandler == null) {
            this.logger.warn("no bridge handler for scan given");
        }
        this.activate(null);
    }

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return SUPPORTED_THING_TYPES;
    }

    protected void startScan() {
        block9: {
            this.logger.trace("Starting WeMoEndDevice discovery on WeMo Link {}", (Object)this.wemoBridgeHandler.getThing().getUID());
            try {
                String deviceURL;
                String wemoURL;
                String endDeviceRequest;
                String devUDN = "uuid:" + this.wemoBridgeHandler.getThing().getConfiguration().get("udn").toString();
                this.logger.trace("devUDN = '{}'", (Object)devUDN);
                String soapHeader = "\"urn:Belkin:service:bridge:1#GetEndDevices\"";
                String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:GetEndDevices xmlns:u=\"urn:Belkin:service:bridge:1\"><DevUDN>" + devUDN + "</DevUDN><ReqListType>PAIRED_LIST</ReqListType>" + "</u:GetEndDevices>" + "</s:Body>" + "</s:Envelope>";
                URL descriptorURL = this.service.getDescriptorURL((UpnpIOParticipant)this);
                if (descriptorURL == null || (endDeviceRequest = WemoHttpCall.executeCall(wemoURL = String.valueOf(deviceURL = StringUtils.substringBefore((String)descriptorURL.toString(), (String)"/setup.xml")) + "/upnp/control/bridge1", soapHeader, content)) == null) break block9;
                this.logger.trace("endDeviceRequest answered '{}'", (Object)endDeviceRequest);
                try {
                    String stringParser = StringUtils.substringBetween((String)endDeviceRequest, (String)"<DeviceLists>", (String)"</DeviceLists>");
                    stringParser = StringEscapeUtils.unescapeXml((String)stringParser);
                    if ("0".equals(stringParser)) {
                        this.logger.debug("There are no devices connected with WeMo Link. Exit discovery");
                        return;
                    }
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(stringParser));
                    Document doc = db.parse(is);
                    NodeList nodes = doc.getElementsByTagName("DeviceInfo");
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element element = (Element)nodes.item(i);
                        NodeList deviceIndex = element.getElementsByTagName("DeviceIndex");
                        Element line = (Element)deviceIndex.item(0);
                        this.logger.trace("DeviceIndex: {}", (Object)WemoLinkDiscoveryService.getCharacterDataFromElement(line));
                        NodeList deviceID = element.getElementsByTagName("DeviceID");
                        line = (Element)deviceID.item(0);
                        String endDeviceID = WemoLinkDiscoveryService.getCharacterDataFromElement(line);
                        this.logger.trace("DeviceID: {}", (Object)endDeviceID);
                        NodeList friendlyName = element.getElementsByTagName("FriendlyName");
                        line = (Element)friendlyName.item(0);
                        String endDeviceName = WemoLinkDiscoveryService.getCharacterDataFromElement(line);
                        this.logger.trace("FriendlyName: {}", (Object)endDeviceName);
                        NodeList vendor = element.getElementsByTagName("Manufacturer");
                        line = (Element)vendor.item(0);
                        String endDeviceVendor = WemoLinkDiscoveryService.getCharacterDataFromElement(line);
                        this.logger.trace("Manufacturer: {}", (Object)endDeviceVendor);
                        NodeList model = element.getElementsByTagName("ModelCode");
                        line = (Element)model.item(0);
                        String endDeviceModelID = WemoLinkDiscoveryService.getCharacterDataFromElement(line);
                        endDeviceModelID = endDeviceModelID.replaceAll(NORMALIZE_ID_REGEX, "_");
                        this.logger.trace("ModelCode: {}", (Object)endDeviceModelID);
                        if (SUPPORTED_THING_TYPES.contains(new ThingTypeUID("wemo", endDeviceModelID))) {
                            this.logger.debug("Discovered a WeMo LED Light thing with ID '{}'", (Object)endDeviceID);
                            ThingUID bridgeUID = this.wemoBridgeHandler.getThing().getUID();
                            ThingTypeUID thingTypeUID = new ThingTypeUID("wemo", endDeviceModelID);
                            if (thingTypeUID.equals((Object)WemoBindingConstants.THING_TYPE_MZ100)) {
                                String thingLightId = endDeviceID;
                                ThingUID thingUID = new ThingUID(thingTypeUID, bridgeUID, thingLightId);
                                HashMap<String, String> properties = new HashMap<String, String>(1);
                                properties.put("deviceID", endDeviceID);
                                DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withBridge(this.wemoBridgeHandler.getThing().getUID()).withLabel(endDeviceName).build();
                                this.thingDiscovered(discoveryResult);
                            }
                        } else {
                            this.logger.debug("Discovered an unsupported device :");
                            this.logger.debug("DeviceIndex : {}", (Object)WemoLinkDiscoveryService.getCharacterDataFromElement(line));
                            this.logger.debug("DeviceID    : {}", (Object)endDeviceID);
                            this.logger.debug("FriendlyName: {}", (Object)endDeviceName);
                            this.logger.debug("Manufacturer: {}", (Object)endDeviceVendor);
                            this.logger.debug("ModelCode   : {}", (Object)endDeviceModelID);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse endDevices for bridge '{}'", (Object)this.wemoBridgeHandler.getThing().getUID(), (Object)e);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to get endDevices for bridge '{}'", (Object)this.wemoBridgeHandler.getThing().getUID(), (Object)e);
            }
        }
    }

    protected void startBackgroundDiscovery() {
        this.logger.trace("Start WeMo device background discovery");
        if (this.scanningJob == null || this.scanningJob.isCancelled()) {
            this.scanningJob = AbstractDiscoveryService.scheduler.scheduleWithFixedDelay(this.scanningRunnable, 5L, 120L, TimeUnit.SECONDS);
        } else {
            this.logger.trace("scanningJob active");
        }
    }

    protected void stopBackgroundDiscovery() {
        this.logger.debug("Stop WeMo device background discovery");
        if (this.scanningJob != null && !this.scanningJob.isCancelled()) {
            this.scanningJob.cancel(true);
            this.scanningJob = null;
        }
    }

    public String getUDN() {
        return (String)this.wemoBridgeHandler.getThing().getConfiguration().get("udn");
    }

    public void onServiceSubscribed(String service, boolean succeeded) {
    }

    public void onValueReceived(String variable, String value, String service) {
    }

    public void onStatusChanged(boolean status) {
    }

    public static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    public class WemoLinkScan
    implements Runnable {
        @Override
        public void run() {
            WemoLinkDiscoveryService.this.startScan();
        }
    }
}

