/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.FilterCriteria;
import org.eclipse.smarthome.config.core.ParameterOption;

public class ConfigDescriptionParameterBuilder {
    private String name;
    private ConfigDescriptionParameter.Type type;
    private String groupName;
    private BigDecimal min;
    private BigDecimal max;
    private BigDecimal step;
    private String pattern;
    private Boolean required;
    private Boolean readOnly;
    private Boolean multiple;
    private Integer multipleLimit;
    private String unit;
    private String unitLabel;
    private String context;
    private String defaultValue;
    private String label;
    private String description;
    private Boolean limitToOptions;
    private Boolean advanced;
    private Boolean verify;
    private List<ParameterOption> options = new ArrayList<ParameterOption>();
    private List<FilterCriteria> filterCriteria = new ArrayList<FilterCriteria>();

    private ConfigDescriptionParameterBuilder(String name, ConfigDescriptionParameter.Type type) {
        this.name = name;
        this.type = type;
    }

    public static ConfigDescriptionParameterBuilder create(String name, ConfigDescriptionParameter.Type type) {
        return new ConfigDescriptionParameterBuilder(name, type);
    }

    public ConfigDescriptionParameterBuilder withMinimum(BigDecimal min) {
        this.min = min;
        return this;
    }

    public ConfigDescriptionParameterBuilder withMaximum(BigDecimal max) {
        this.max = max;
        return this;
    }

    public ConfigDescriptionParameterBuilder withStepSize(BigDecimal step) {
        this.step = step;
        return this;
    }

    public ConfigDescriptionParameterBuilder withPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public ConfigDescriptionParameterBuilder withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ConfigDescriptionParameterBuilder withMultiple(Boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public ConfigDescriptionParameterBuilder withMultipleLimit(Integer multipleLimit) {
        this.multipleLimit = multipleLimit;
        return this;
    }

    public ConfigDescriptionParameterBuilder withContext(String context) {
        this.context = context;
        return this;
    }

    public ConfigDescriptionParameterBuilder withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public ConfigDescriptionParameterBuilder withDefault(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConfigDescriptionParameterBuilder withLabel(String label) {
        this.label = label;
        return this;
    }

    public ConfigDescriptionParameterBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigDescriptionParameterBuilder withOptions(List<ParameterOption> options) {
        this.options = options;
        return this;
    }

    public ConfigDescriptionParameterBuilder withAdvanced(Boolean advanced) {
        this.advanced = advanced;
        return this;
    }

    public ConfigDescriptionParameterBuilder withVerify(Boolean verify) {
        this.verify = verify;
        return this;
    }

    public ConfigDescriptionParameterBuilder withLimitToOptions(Boolean limitToOptions) {
        this.limitToOptions = limitToOptions;
        return this;
    }

    public ConfigDescriptionParameterBuilder withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public ConfigDescriptionParameterBuilder withFilterCriteria(List<FilterCriteria> filterCriteria) {
        this.filterCriteria = filterCriteria;
        return this;
    }

    public ConfigDescriptionParameterBuilder withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public ConfigDescriptionParameterBuilder withUnitLabel(String unitLabel) {
        this.unitLabel = unitLabel;
        return this;
    }

    public ConfigDescriptionParameter build() throws IllegalArgumentException {
        return new ConfigDescriptionParameter(this.name, this.type, this.min, this.max, this.step, this.pattern, this.required, this.readOnly, this.multiple, this.context, this.defaultValue, this.label, this.description, this.options, this.filterCriteria, this.groupName, this.advanced, this.limitToOptions, this.multipleLimit, this.unit, this.unitLabel, this.verify);
    }
}

