/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.eclipse.smarthome.config.core.internal.Activator;
import org.eclipse.smarthome.config.core.validation.ConfigValidationMessage;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigValidationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(ConfigValidationException.class);
    private final Bundle bundle;
    private final Collection<ConfigValidationMessage> configValidationMessages;

    public ConfigValidationException(Bundle bundle, Collection<ConfigValidationMessage> configValidationMessages) {
        Preconditions.checkNotNull((Object)bundle, (Object)"Bundle must not be null");
        Preconditions.checkNotNull(configValidationMessages, (Object)"Config validation messages must not be null");
        this.bundle = bundle;
        this.configValidationMessages = configValidationMessages;
    }

    public Map<String, String> getValidationMessages() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ConfigValidationMessage configValidationMessage : this.configValidationMessages) {
            builder.put((Object)configValidationMessage.parameterName, (Object)MessageFormat.format(configValidationMessage.defaultMessage, configValidationMessage.content));
        }
        return builder.build();
    }

    public Map<String, String> getValidationMessages(Locale locale) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ConfigValidationMessage configValidationMessage : this.configValidationMessages) {
            if (Activator.getTranslationProvider() == null) {
                this.logger.warn("TranslationProvider is not available. Will provide default validation message for parameter '{}'.", (Object)configValidationMessage.parameterName);
                builder.put((Object)configValidationMessage.parameterName, (Object)MessageFormat.format(configValidationMessage.defaultMessage, configValidationMessage.content));
                continue;
            }
            String text = Activator.getTranslationProvider().getText(this.bundle, configValidationMessage.messageKey, configValidationMessage.defaultMessage, locale, configValidationMessage.content);
            builder.put((Object)configValidationMessage.parameterName, (Object)text);
        }
        return builder.build();
    }
}

