/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.mdns.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.mdns.MDNSDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mdns.MDNSClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid="discovery.mdns")
public class MDNSDiscoveryService
extends AbstractDiscoveryService
implements ServiceListener {
    private final Logger logger = LoggerFactory.getLogger(MDNSDiscoveryService.class);
    @Deprecated
    private final Set<org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant> oldParticipants = new CopyOnWriteArraySet<org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant>();
    private final Set<MDNSDiscoveryParticipant> participants = new CopyOnWriteArraySet<MDNSDiscoveryParticipant>();
    private MDNSClient mdnsClient;

    public MDNSDiscoveryService() {
        super(5);
    }

    @Reference
    public void setMDNSClient(MDNSClient mdnsClient) {
        this.mdnsClient = mdnsClient;
        if (this.isBackgroundDiscoveryEnabled()) {
            for (MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.participants) {
                mdnsClient.addServiceListener(mDNSDiscoveryParticipant.getServiceType(), (ServiceListener)this);
            }
            for (org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.oldParticipants) {
                mdnsClient.addServiceListener(mDNSDiscoveryParticipant.getServiceType(), (ServiceListener)this);
            }
        }
    }

    public void unsetMDNSClient(MDNSClient mdnsClient) {
        for (MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.participants) {
            mdnsClient.removeServiceListener(mDNSDiscoveryParticipant.getServiceType(), (ServiceListener)this);
        }
        for (org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.oldParticipants) {
            mdnsClient.removeServiceListener(mDNSDiscoveryParticipant.getServiceType(), (ServiceListener)this);
        }
        this.mdnsClient = null;
    }

    protected void startBackgroundDiscovery() {
        for (MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.participants) {
            this.mdnsClient.addServiceListener(mDNSDiscoveryParticipant.getServiceType(), (ServiceListener)this);
        }
        for (org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.oldParticipants) {
            this.mdnsClient.addServiceListener(mDNSDiscoveryParticipant.getServiceType(), (ServiceListener)this);
        }
        this.startScan();
    }

    protected void stopBackgroundDiscovery() {
        for (MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.participants) {
            this.mdnsClient.removeServiceListener(mDNSDiscoveryParticipant.getServiceType(), (ServiceListener)this);
        }
        for (org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.oldParticipants) {
            this.mdnsClient.removeServiceListener(mDNSDiscoveryParticipant.getServiceType(), (ServiceListener)this);
        }
    }

    protected void startScan() {
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                MDNSDiscoveryService.this.scan();
            }
        }, 0L, TimeUnit.SECONDS);
    }

    private void scan() {
        DiscoveryResult result;
        ServiceInfo service;
        int n;
        int n2;
        ServiceInfo[] serviceInfoArray;
        ServiceInfo[] services;
        for (MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.participants) {
            services = this.mdnsClient.list(mDNSDiscoveryParticipant.getServiceType());
            this.logger.debug("{} services found for {}", (Object)services.length, (Object)mDNSDiscoveryParticipant.getServiceType());
            serviceInfoArray = services;
            n2 = services.length;
            n = 0;
            while (n < n2) {
                service = serviceInfoArray[n];
                result = mDNSDiscoveryParticipant.createResult(service);
                if (result != null) {
                    this.thingDiscovered(result);
                }
                ++n;
            }
        }
        for (org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.oldParticipants) {
            services = this.mdnsClient.list(mDNSDiscoveryParticipant.getServiceType());
            this.logger.debug("{} services found for {}", (Object)services.length, (Object)mDNSDiscoveryParticipant.getServiceType());
            serviceInfoArray = services;
            n2 = services.length;
            n = 0;
            while (n < n2) {
                service = serviceInfoArray[n];
                result = mDNSDiscoveryParticipant.createResult(service);
                if (result != null) {
                    this.thingDiscovered(result);
                }
                ++n;
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addMDNSDiscoveryParticipant(MDNSDiscoveryParticipant participant) {
        this.participants.add(participant);
        if (this.mdnsClient != null && this.isBackgroundDiscoveryEnabled()) {
            this.mdnsClient.addServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    protected void removeMDNSDiscoveryParticipant(MDNSDiscoveryParticipant participant) {
        this.participants.remove(participant);
        if (this.mdnsClient != null) {
            this.mdnsClient.removeServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    @Deprecated
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addMDNSDiscoveryParticipant_old(org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant participant) {
        this.oldParticipants.add(participant);
        if (this.mdnsClient != null && this.isBackgroundDiscoveryEnabled()) {
            this.mdnsClient.addServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    @Deprecated
    protected void removeMDNSDiscoveryParticipant_old(org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant participant) {
        this.oldParticipants.remove(participant);
        if (this.mdnsClient != null) {
            this.mdnsClient.removeServiceListener(participant.getServiceType(), (ServiceListener)this);
        }
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        HashSet<ThingTypeUID> supportedThingTypes = new HashSet<ThingTypeUID>();
        for (MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.participants) {
            supportedThingTypes.addAll(mDNSDiscoveryParticipant.getSupportedThingTypeUIDs());
        }
        for (org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.oldParticipants) {
            supportedThingTypes.addAll(mDNSDiscoveryParticipant.getSupportedThingTypeUIDs());
        }
        return supportedThingTypes;
    }

    public void serviceAdded(ServiceEvent serviceEvent) {
        this.considerService(serviceEvent);
    }

    public void serviceRemoved(ServiceEvent serviceEvent) {
        ThingUID thingUID;
        for (MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.participants) {
            if (!mDNSDiscoveryParticipant.getServiceType().equals(serviceEvent.getType())) continue;
            try {
                thingUID = mDNSDiscoveryParticipant.getThingUID(serviceEvent.getInfo());
                if (thingUID == null) continue;
                this.thingRemoved(thingUID);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)mDNSDiscoveryParticipant.getClass().getName(), (Object)e);
            }
        }
        for (org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.oldParticipants) {
            if (!mDNSDiscoveryParticipant.getServiceType().equals(serviceEvent.getType())) continue;
            try {
                thingUID = mDNSDiscoveryParticipant.getThingUID(serviceEvent.getInfo());
                if (thingUID == null) continue;
                this.thingRemoved(thingUID);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)mDNSDiscoveryParticipant.getClass().getName(), (Object)e);
            }
        }
    }

    public void serviceResolved(ServiceEvent serviceEvent) {
        this.considerService(serviceEvent);
    }

    private void considerService(ServiceEvent serviceEvent) {
        if (this.isBackgroundDiscoveryEnabled()) {
            DiscoveryResult result;
            for (MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.participants) {
                if (!mDNSDiscoveryParticipant.getServiceType().equals(serviceEvent.getType())) continue;
                try {
                    result = mDNSDiscoveryParticipant.createResult(serviceEvent.getInfo());
                    if (result == null) continue;
                    this.thingDiscovered(result);
                }
                catch (Exception e) {
                    this.logger.error("Participant '{}' threw an exception", (Object)mDNSDiscoveryParticipant.getClass().getName(), (Object)e);
                }
            }
            for (org.eclipse.smarthome.io.transport.mdns.discovery.MDNSDiscoveryParticipant mDNSDiscoveryParticipant : this.oldParticipants) {
                if (!mDNSDiscoveryParticipant.getServiceType().equals(serviceEvent.getType())) continue;
                try {
                    result = mDNSDiscoveryParticipant.createResult(serviceEvent.getInfo());
                    if (result == null) continue;
                    this.thingDiscovered(result);
                }
                catch (Exception e) {
                    this.logger.error("Participant '{}' threw an exception", (Object)mDNSDiscoveryParticipant.getClass().getName(), (Object)e);
                }
            }
        }
    }
}

