/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.upnp.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.upnp.UpnpDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.jupnp.UpnpService;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid="discovery.upnp")
public class UpnpDiscoveryService
extends AbstractDiscoveryService
implements RegistryListener {
    private final Logger logger = LoggerFactory.getLogger(UpnpDiscoveryService.class);
    @Deprecated
    private final Set<org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant> oldParticipants = new CopyOnWriteArraySet<org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant>();
    private final Set<UpnpDiscoveryParticipant> participants = new CopyOnWriteArraySet<UpnpDiscoveryParticipant>();
    private UpnpService upnpService;

    public UpnpDiscoveryService() {
        super(5);
    }

    protected void activate(Map<String, Object> configProperties) {
        super.activate(configProperties);
        this.startScan();
    }

    @Modified
    protected void modified(Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    @Reference
    protected void setUpnpService(UpnpService upnpService) {
        this.upnpService = upnpService;
    }

    protected void unsetUpnpService(UpnpService upnpService) {
        this.upnpService = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addUpnpDiscoveryParticipant(UpnpDiscoveryParticipant participant) {
        this.participants.add(participant);
        if (this.upnpService != null) {
            Collection devices = this.upnpService.getRegistry().getRemoteDevices();
            for (RemoteDevice device : devices) {
                DiscoveryResult result = participant.createResult(device);
                if (result == null) continue;
                this.thingDiscovered(result);
            }
        }
    }

    protected void removeUpnpDiscoveryParticipant(UpnpDiscoveryParticipant participant) {
        this.participants.remove(participant);
    }

    @Deprecated
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addUpnpDiscoveryParticipant_old(org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant participant) {
        this.oldParticipants.add(participant);
        if (this.upnpService != null) {
            Collection devices = this.upnpService.getRegistry().getRemoteDevices();
            for (RemoteDevice device : devices) {
                DiscoveryResult result = participant.createResult(device);
                if (result == null) continue;
                this.thingDiscovered(result);
            }
        }
    }

    @Deprecated
    protected void removeUpnpDiscoveryParticipant_old(org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant participant) {
        this.oldParticipants.remove(participant);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        HashSet<ThingTypeUID> supportedThingTypes = new HashSet<ThingTypeUID>();
        for (UpnpDiscoveryParticipant upnpDiscoveryParticipant : this.participants) {
            supportedThingTypes.addAll(upnpDiscoveryParticipant.getSupportedThingTypeUIDs());
        }
        for (org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant upnpDiscoveryParticipant : this.oldParticipants) {
            supportedThingTypes.addAll(upnpDiscoveryParticipant.getSupportedThingTypeUIDs());
        }
        return supportedThingTypes;
    }

    protected void startBackgroundDiscovery() {
        this.upnpService.getRegistry().addListener((RegistryListener)this);
    }

    protected void stopBackgroundDiscovery() {
        this.upnpService.getRegistry().removeListener((RegistryListener)this);
    }

    protected void startScan() {
        for (RemoteDevice device : this.upnpService.getRegistry().getRemoteDevices()) {
            this.remoteDeviceAdded(this.upnpService.getRegistry(), device);
        }
        this.upnpService.getRegistry().addListener((RegistryListener)this);
        this.upnpService.getControlPoint().search();
    }

    protected synchronized void stopScan() {
        this.removeOlderResults(this.getTimestampOfLastScan());
        super.stopScan();
        if (!this.isBackgroundDiscoveryEnabled()) {
            this.upnpService.getRegistry().removeListener((RegistryListener)this);
        }
    }

    public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
        DiscoveryResult result;
        for (UpnpDiscoveryParticipant upnpDiscoveryParticipant : this.participants) {
            try {
                result = upnpDiscoveryParticipant.createResult(device);
                if (result == null) continue;
                this.thingDiscovered(result);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)upnpDiscoveryParticipant.getClass().getName(), (Object)e);
            }
        }
        for (org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant upnpDiscoveryParticipant : this.oldParticipants) {
            try {
                result = upnpDiscoveryParticipant.createResult(device);
                if (result == null) continue;
                this.thingDiscovered(result);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)upnpDiscoveryParticipant.getClass().getName(), (Object)e);
            }
        }
    }

    public void remoteDeviceRemoved(Registry registry, RemoteDevice device) {
        ThingUID thingUID;
        for (UpnpDiscoveryParticipant upnpDiscoveryParticipant : this.participants) {
            try {
                thingUID = upnpDiscoveryParticipant.getThingUID(device);
                if (thingUID == null) continue;
                this.thingRemoved(thingUID);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)upnpDiscoveryParticipant.getClass().getName(), (Object)e);
            }
        }
        for (org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant upnpDiscoveryParticipant : this.oldParticipants) {
            try {
                thingUID = upnpDiscoveryParticipant.getThingUID(device);
                if (thingUID == null) continue;
                this.thingRemoved(thingUID);
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)upnpDiscoveryParticipant.getClass().getName(), (Object)e);
            }
        }
    }

    public void remoteDeviceUpdated(Registry registry, RemoteDevice device) {
    }

    public void localDeviceAdded(Registry registry, LocalDevice device) {
    }

    public void localDeviceRemoved(Registry registry, LocalDevice device) {
    }

    public void beforeShutdown(Registry registry) {
    }

    public void afterShutdown() {
    }

    public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device) {
    }

    public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex) {
    }
}

