/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.config.discovery.inbox.Inbox;
import org.eclipse.smarthome.config.discovery.inbox.InboxListener;
import org.eclipse.smarthome.config.discovery.inbox.InboxPredicates;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.AbstractTypedEventSubscriber;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.events.ThingStatusInfoChangedEvent;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.inbox", service={EventSubscriber.class}, property={"service.config.description.uri=system:inbox", "service.config.label=Inbox", "service.config.category=system", "service.pid=org.eclipse.smarthome.inbox"})
@NonNullByDefault
public class AutomaticInboxProcessor
extends AbstractTypedEventSubscriber<ThingStatusInfoChangedEvent>
implements InboxListener,
RegistryChangeListener<Thing> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NonNullByDefault(value={})
    private ThingRegistry thingRegistry;
    @NonNullByDefault(value={})
    private ThingTypeRegistry thingTypeRegistry;
    @NonNullByDefault(value={})
    private Inbox inbox;
    private boolean autoIgnore = true;
    private boolean autoApprove = false;

    public AutomaticInboxProcessor() {
        super(ThingStatusInfoChangedEvent.TYPE);
    }

    public void receiveTypedEvent(ThingStatusInfoChangedEvent event) {
        if (this.autoIgnore) {
            Thing thing = this.thingRegistry.get(event.getThingUID());
            ThingStatus thingStatus = event.getStatusInfo().getStatus();
            this.autoIgnore(thing, thingStatus);
        }
    }

    @Override
    public void thingAdded(Inbox inbox, DiscoveryResult result) {
        Thing thing;
        String value;
        if (this.autoIgnore && (value = this.getRepresentationValue(result)) != null && (thing = (Thing)this.thingRegistry.stream().filter(t -> Objects.equals(value, this.getRepresentationPropertyValueForThing((Thing)t))).filter(t -> Objects.equals(t.getThingTypeUID(), result.getThingTypeUID())).findFirst().orElse(null)) != null) {
            this.logger.debug("Auto-ignoring the inbox entry for the representation value {}", (Object)value);
            inbox.setFlag(result.getThingUID(), DiscoveryResultFlag.IGNORED);
        }
        if (this.autoApprove) {
            inbox.approve(result.getThingUID(), result.getLabel());
        }
    }

    @Override
    public void thingUpdated(Inbox inbox, DiscoveryResult result) {
    }

    @Override
    public void thingRemoved(Inbox inbox, DiscoveryResult result) {
    }

    public void added(Thing element) {
    }

    public void removed(Thing element) {
        this.removePossiblyIgnoredResultInInbox(element);
    }

    public void updated(Thing oldElement, Thing element) {
    }

    private @Nullable String getRepresentationValue(DiscoveryResult result) {
        return result.getRepresentationProperty() != null ? Objects.toString(result.getProperties().get(result.getRepresentationProperty()), null) : null;
    }

    private void autoIgnore(@Nullable Thing thing, ThingStatus thingStatus) {
        if (ThingStatus.ONLINE.equals((Object)thingStatus)) {
            this.checkAndIgnoreInInbox(thing);
        }
    }

    private void checkAndIgnoreInInbox(@Nullable Thing thing) {
        String representationValue;
        if (thing != null && (representationValue = this.getRepresentationPropertyValueForThing(thing)) != null) {
            this.ignoreInInbox(thing.getThingTypeUID(), representationValue);
        }
    }

    private void ignoreInInbox(ThingTypeUID thingtypeUID, String representationValue) {
        List results = this.inbox.stream().filter(InboxPredicates.withRepresentationPropertyValue(representationValue)).filter(InboxPredicates.forThingTypeUID(thingtypeUID)).collect(Collectors.toList());
        if (results.size() == 1) {
            this.logger.debug("Auto-ignoring the inbox entry for the representation value {}", (Object)representationValue);
            this.inbox.setFlag(((DiscoveryResult)results.get(0)).getThingUID(), DiscoveryResultFlag.IGNORED);
        }
    }

    private void removePossiblyIgnoredResultInInbox(@Nullable Thing thing) {
        String representationValue;
        if (thing != null && (representationValue = this.getRepresentationPropertyValueForThing(thing)) != null) {
            this.removeFromInbox(thing.getThingTypeUID(), representationValue);
        }
    }

    private @Nullable String getRepresentationPropertyValueForThing(Thing thing) {
        ThingType thingType = this.thingTypeRegistry.getThingType(thing.getThingTypeUID());
        if (thingType != null) {
            String representationProperty = thingType.getRepresentationProperty();
            if (representationProperty == null) {
                return null;
            }
            Map properties = thing.getProperties();
            if (properties.containsKey(representationProperty)) {
                return (String)properties.get(representationProperty);
            }
            Configuration configuration = thing.getConfiguration();
            if (configuration.containsKey(representationProperty)) {
                return String.valueOf(configuration.get(representationProperty));
            }
        }
        return null;
    }

    private void removeFromInbox(ThingTypeUID thingtypeUID, String representationValue) {
        List results = this.inbox.stream().filter(InboxPredicates.withRepresentationPropertyValue(representationValue)).filter(InboxPredicates.forThingTypeUID(thingtypeUID)).filter(InboxPredicates.withFlag(DiscoveryResultFlag.IGNORED)).collect(Collectors.toList());
        if (results.size() == 1) {
            this.logger.debug("Removing the ignored result from the inbox for the representation value {}", (Object)representationValue);
            this.inbox.remove(((DiscoveryResult)results.get(0)).getThingUID());
        }
    }

    private void approveAllInboxEntries() {
        for (DiscoveryResult result : this.inbox.getAll()) {
            if (!result.getFlag().equals((Object)DiscoveryResultFlag.NEW)) continue;
            this.inbox.approve(result.getThingUID(), result.getLabel());
        }
    }

    protected void activate(@Nullable Map<String, @Nullable Object> properties) {
        if (properties != null) {
            Object value = properties.get("autoIgnore");
            this.autoIgnore = value == null || !value.toString().equals("false");
            value = properties.get("autoApprove");
            boolean bl = this.autoApprove = value != null && value.toString().equals("true");
            if (this.autoApprove) {
                this.approveAllInboxEntries();
            }
        }
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
        thingRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        thingRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.thingRegistry = null;
    }

    @Reference
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference
    protected void setInbox(Inbox inbox) {
        this.inbox = inbox;
        inbox.addInboxListener(this);
    }

    protected void unsetInbox(Inbox inbox) {
        inbox.removeInboxListener(this);
        this.inbox = null;
    }
}

