/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import com.google.common.collect.HashMultimap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceCallback;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceRegistry;
import org.eclipse.smarthome.config.discovery.ExtendedDiscoveryService;
import org.eclipse.smarthome.config.discovery.ScanListener;
import org.eclipse.smarthome.config.discovery.inbox.Inbox;
import org.eclipse.smarthome.config.discovery.inbox.InboxPredicates;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryServiceRegistry.class})
@NonNullByDefault
public final class DiscoveryServiceRegistryImpl
implements DiscoveryServiceRegistry,
DiscoveryListener {
    private final HashMultimap<DiscoveryService, DiscoveryResult> cachedResults = HashMultimap.create();
    private final List<DiscoveryService> discoveryServices = new CopyOnWriteArrayList<DiscoveryService>();
    private final Set<DiscoveryListener> listeners = new CopyOnWriteArraySet<DiscoveryListener>();
    private final Logger logger = LoggerFactory.getLogger(DiscoveryServiceRegistryImpl.class);
    private @Nullable Inbox inbox;
    @NonNullByDefault(value={})
    private ThingRegistry thingRegistry;
    @NonNullByDefault(value={})
    private SafeCaller safeCaller;
    private final DiscoveryServiceCallback discoveryServiceCallback = new DiscoveryServiceCallback(){

        @Override
        public @Nullable Thing getExistingThing(ThingUID thingUID) {
            ThingRegistry thingRegistryReference = DiscoveryServiceRegistryImpl.this.thingRegistry;
            if (thingRegistryReference == null) {
                DiscoveryServiceRegistryImpl.this.logger.warn("ThingRegistry not set");
                return null;
            }
            return thingRegistryReference.get(thingUID);
        }

        @Override
        public @Nullable DiscoveryResult getExistingDiscoveryResult(ThingUID thingUID) {
            Inbox inboxReference = DiscoveryServiceRegistryImpl.this.inbox;
            if (inboxReference == null) {
                DiscoveryServiceRegistryImpl.this.logger.warn("Inbox not set");
                return null;
            }
            List<Object> ret = new ArrayList();
            ret = inboxReference.stream().filter(InboxPredicates.withFlag(DiscoveryResultFlag.NEW).and(InboxPredicates.forThingUID(thingUID))).collect(Collectors.toList());
            if (ret.size() > 0) {
                return (DiscoveryResult)ret.get(0);
            }
            return null;
        }
    };

    @Override
    public boolean abortScan(ThingTypeUID thingTypeUID) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForThingType = this.getDiscoveryServices(thingTypeUID);
        if (discoveryServicesForThingType.isEmpty()) {
            this.logger.warn("No discovery service for thing type '{}' found!", (Object)thingTypeUID);
            return false;
        }
        return this.abortScans(discoveryServicesForThingType);
    }

    @Override
    public boolean abortScan(String bindingId) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForBinding = this.getDiscoveryServices(bindingId);
        if (discoveryServicesForBinding.isEmpty()) {
            this.logger.warn("No discovery service for binding '{}' found!", (Object)bindingId);
            return false;
        }
        return this.abortScans(discoveryServicesForBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryListener(DiscoveryListener listener) throws IllegalStateException {
        HashMultimap<DiscoveryService, DiscoveryResult> hashMultimap = this.cachedResults;
        synchronized (hashMultimap) {
            Set entries = this.cachedResults.entries();
            for (Map.Entry entry : entries) {
                listener.thingDiscovered((DiscoveryService)entry.getKey(), (DiscoveryResult)entry.getValue());
            }
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean startScan(ThingTypeUID thingTypeUID, @Nullable ScanListener listener) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForThingType = this.getDiscoveryServices(thingTypeUID);
        if (discoveryServicesForThingType.isEmpty()) {
            this.logger.warn("No discovery service for thing type '{}' found!", (Object)thingTypeUID);
            return false;
        }
        return this.startScans(discoveryServicesForThingType, listener);
    }

    @Override
    public boolean startScan(String bindingId, @Nullable ScanListener listener) throws IllegalStateException {
        Set<DiscoveryService> discoveryServicesForBinding = this.getDiscoveryServices(bindingId);
        if (discoveryServicesForBinding.isEmpty()) {
            this.logger.warn("No discovery service for binding id '{}' found!", (Object)bindingId);
            return false;
        }
        return this.startScans(discoveryServicesForBinding, listener);
    }

    @Override
    public boolean supportsDiscovery(ThingTypeUID thingTypeUID) {
        return !this.getDiscoveryServices(thingTypeUID).isEmpty();
    }

    @Override
    public boolean supportsDiscovery(String bindingId) {
        return !this.getDiscoveryServices(bindingId).isEmpty();
    }

    @Override
    public List<ThingTypeUID> getSupportedThingTypes() {
        ArrayList<ThingTypeUID> thingTypeUIDs = new ArrayList<ThingTypeUID>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            thingTypeUIDs.addAll(discoveryService.getSupportedThingTypes());
        }
        return thingTypeUIDs;
    }

    @Override
    public List<String> getSupportedBindings() {
        ArrayList<String> bindings = new ArrayList<String>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
            for (ThingTypeUID thingTypeUID : supportedThingTypes) {
                bindings.add(thingTypeUID.getBindingId());
            }
        }
        return bindings;
    }

    @Override
    public synchronized void removeDiscoveryListener(DiscoveryListener listener) throws IllegalStateException {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void thingDiscovered(final DiscoveryService source, final DiscoveryResult result) {
        HashMultimap<DiscoveryService, DiscoveryResult> hashMultimap = this.cachedResults;
        synchronized (hashMultimap) {
            this.cachedResults.remove((Object)source, (Object)result);
            this.cachedResults.put((Object)source, (Object)result);
        }
        for (final DiscoveryListener listener : this.listeners) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public @Nullable Void run() {
                        listener.thingDiscovered(source, result);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener {} on Thing discovered event!", (Object)listener.getClass().getName(), (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void thingRemoved(final DiscoveryService source, final ThingUID thingUID) {
        HashMultimap<DiscoveryService, DiscoveryResult> hashMultimap = this.cachedResults;
        synchronized (hashMultimap) {
            Iterator it = this.cachedResults.get((Object)source).iterator();
            while (it.hasNext()) {
                if (!((DiscoveryResult)it.next()).getThingUID().equals((Object)thingUID)) continue;
                it.remove();
            }
        }
        for (final DiscoveryListener listener : this.listeners) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public @Nullable Void run() {
                        listener.thingRemoved(source, thingUID);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener '{}' on Thing removed event!", (Object)listener.getClass().getName(), (Object)ex);
            }
        }
    }

    @Override
    public Collection<ThingUID> removeOlderResults(final DiscoveryService source, final long timestamp, final @Nullable Collection<ThingTypeUID> thingTypeUIDs, final @Nullable ThingUID bridgeUID) {
        HashSet<ThingUID> removedResults = new HashSet<ThingUID>();
        for (final DiscoveryListener listener : this.listeners) {
            try {
                Collection<ThingUID> olderResults = AccessController.doPrivileged(new PrivilegedAction<Collection<ThingUID>>(){

                    @Override
                    public @Nullable Collection<ThingUID> run() {
                        return listener.removeOlderResults(source, timestamp, thingTypeUIDs, bridgeUID);
                    }
                });
                if (olderResults == null) continue;
                removedResults.addAll(olderResults);
            }
            catch (Exception ex) {
                this.logger.error("Cannot notify the DiscoveryListener '{}' on all things removed event!", (Object)listener.getClass().getName(), (Object)ex);
            }
        }
        return removedResults;
    }

    private boolean abortScans(Set<DiscoveryService> discoveryServices) {
        boolean allServicesAborted = true;
        for (DiscoveryService discoveryService : discoveryServices) {
            Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
            try {
                this.logger.debug("Abort scan for thing types '{}' on '{}'...", supportedThingTypes, (Object)discoveryService.getClass().getName());
                discoveryService.abortScan();
                this.logger.debug("Scan for thing types '{}' aborted on '{}'.", supportedThingTypes, (Object)discoveryService.getClass().getName());
            }
            catch (Exception ex) {
                this.logger.error("Cannot abort scan for thing types '{}' on '{}'!", new Object[]{supportedThingTypes, discoveryService.getClass().getName(), ex});
                allServicesAborted = false;
            }
        }
        return allServicesAborted;
    }

    private boolean startScans(Set<DiscoveryService> discoveryServices, @Nullable ScanListener listener) {
        boolean atLeastOneDiscoveryServiceHasBeenStarted = false;
        if (discoveryServices.size() > 1) {
            this.logger.debug("Trying to start {} scans with an aggregating listener.", (Object)discoveryServices.size());
            AggregatingScanListener aggregatingScanListener = new AggregatingScanListener(discoveryServices.size(), listener);
            for (DiscoveryService discoveryService : discoveryServices) {
                if (this.startScan(discoveryService, (ScanListener)aggregatingScanListener)) {
                    atLeastOneDiscoveryServiceHasBeenStarted = true;
                    continue;
                }
                this.logger.debug("Reducing number of discovery services in aggregating listener, because discovery service failed to start scan.");
                aggregatingScanListener.reduceNumberOfDiscoveryServices();
            }
        } else if (this.startScan(discoveryServices.iterator().next(), listener)) {
            atLeastOneDiscoveryServiceHasBeenStarted = true;
        }
        return atLeastOneDiscoveryServiceHasBeenStarted;
    }

    private boolean startScan(DiscoveryService discoveryService, @Nullable ScanListener listener) {
        Collection<ThingTypeUID> supportedThingTypes = discoveryService.getSupportedThingTypes();
        try {
            this.logger.debug("Triggering scan for thing types '{}' on '{}'...", supportedThingTypes, (Object)discoveryService.getClass().getSimpleName());
            discoveryService.startScan(listener);
            return true;
        }
        catch (Exception ex) {
            this.logger.error("Cannot trigger scan for thing types '{}' on '{}'!", new Object[]{supportedThingTypes, discoveryService.getClass().getSimpleName(), ex});
            return false;
        }
    }

    private synchronized Set<DiscoveryService> getDiscoveryServices(ThingTypeUID thingTypeUID) throws IllegalStateException {
        HashSet<DiscoveryService> discoveryServices = new HashSet<DiscoveryService>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> discoveryThingTypes = discoveryService.getSupportedThingTypes();
            if (!discoveryThingTypes.contains(thingTypeUID)) continue;
            discoveryServices.add(discoveryService);
        }
        return discoveryServices;
    }

    private synchronized Set<DiscoveryService> getDiscoveryServices(String bindingId) throws IllegalStateException {
        HashSet<DiscoveryService> discoveryServices = new HashSet<DiscoveryService>();
        for (DiscoveryService discoveryService : this.discoveryServices) {
            Collection<ThingTypeUID> discoveryThingTypes = discoveryService.getSupportedThingTypes();
            for (ThingTypeUID thingTypeUID : discoveryThingTypes) {
                if (!thingTypeUID.getBindingId().equals(bindingId)) continue;
                discoveryServices.add(discoveryService);
            }
        }
        return discoveryServices;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addDiscoveryService(DiscoveryService discoveryService) {
        discoveryService.addDiscoveryListener(this);
        if (discoveryService instanceof ExtendedDiscoveryService) {
            ((ExtendedDiscoveryService)this.safeCaller.create((Object)((ExtendedDiscoveryService)((Object)discoveryService))).build()).setDiscoveryServiceCallback(this.discoveryServiceCallback);
        }
        this.discoveryServices.add(discoveryService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDiscoveryService(DiscoveryService discoveryService) {
        this.discoveryServices.remove(discoveryService);
        discoveryService.removeDiscoveryListener(this);
        HashMultimap<DiscoveryService, DiscoveryResult> hashMultimap = this.cachedResults;
        synchronized (hashMultimap) {
            this.cachedResults.removeAll((Object)discoveryService);
        }
    }

    protected void deactivate() {
        this.discoveryServices.clear();
        this.listeners.clear();
        this.cachedResults.clear();
    }

    private int getMaxScanTimeout(Set<DiscoveryService> discoveryServices) {
        int result = 0;
        for (DiscoveryService discoveryService : discoveryServices) {
            if (discoveryService.getScanTimeout() <= result) continue;
            result = discoveryService.getScanTimeout();
        }
        return result;
    }

    @Override
    public int getMaxScanTimeout(ThingTypeUID thingTypeUID) {
        return this.getMaxScanTimeout(this.getDiscoveryServices(thingTypeUID));
    }

    @Override
    public int getMaxScanTimeout(String bindingId) {
        return this.getMaxScanTimeout(this.getDiscoveryServices(bindingId));
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setInbox(Inbox inbox) {
        this.inbox = inbox;
    }

    protected void unsetInbox(Inbox inbox) {
        this.inbox = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = safeCaller;
    }

    protected void unsetSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = null;
    }

    private final class AggregatingScanListener
    implements ScanListener {
        private final @Nullable ScanListener listener;
        private int finishedDiscoveryServices = 0;
        private boolean errorOccurred = false;
        private int numberOfDiscoveryServices;

        private AggregatingScanListener(@Nullable int numberOfDiscoveryServices, ScanListener listener) {
            this.numberOfDiscoveryServices = numberOfDiscoveryServices;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void onFinished() {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                ++this.finishedDiscoveryServices;
                DiscoveryServiceRegistryImpl.this.logger.debug("Finished {} of {} discovery services.", (Object)this.finishedDiscoveryServices, (Object)this.numberOfDiscoveryServices);
                if (!this.errorOccurred && this.finishedDiscoveryServices == this.numberOfDiscoveryServices && this.listener != null) {
                    this.listener.onFinished();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onErrorOccurred(@Nullable Exception exception) {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                if (!this.errorOccurred) {
                    if (this.listener != null) {
                        this.listener.onErrorOccurred(exception);
                    }
                    this.errorOccurred = true;
                } else if (!(exception instanceof CancellationException) && exception != null) {
                    DiscoveryServiceRegistryImpl.this.logger.warn("Error occurred while executing discovery service: {}", (Object)exception.getMessage(), (Object)exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reduceNumberOfDiscoveryServices() {
            AggregatingScanListener aggregatingScanListener = this;
            synchronized (aggregatingScanListener) {
                --this.numberOfDiscoveryServices;
                if (!this.errorOccurred && this.finishedDiscoveryServices == this.numberOfDiscoveryServices && this.listener != null) {
                    this.listener.onFinished();
                }
            }
        }
    }
}

