/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioManager;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;

public class AudioConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_PLAY = "play";
    private static final String SUBCMD_STREAM = "stream";
    private static final String SUBCMD_SOURCES = "sources";
    private static final String SUBCMD_SINKS = "sinks";
    private AudioManager audioManager;

    public AudioConsoleCommandExtension() {
        super("audio", "Commands around audio enablement features.");
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("play <sink> <filename>", "plays a sound file from the sounds folder through the optionally specified audio sink(s)"), this.buildCommandUsage("stream <sink> <url>", "streams the sound from the url through the optionally specified audio sink(s)"), this.buildCommandUsage(SUBCMD_SOURCES, "lists the audio sources"), this.buildCommandUsage(SUBCMD_SINKS, "lists the audio sinks"));
    }

    public void execute(String[] args, Console console) {
        block22: {
            block20: {
                String subCommand;
                if (args.length <= 0) break block20;
                switch (subCommand = args[0]) {
                    case "play": {
                        if (args.length > 1) {
                            this.play((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), console);
                        } else {
                            console.println("Specify file to play, and optionally the sink(s) to use (e.g. 'play javasound hello.mp3')");
                        }
                        return;
                    }
                    case "stream": {
                        if (args.length > 1) {
                            this.stream((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), console);
                        } else {
                            console.println("Specify url to stream from, and optionally the sink(s) to use");
                        }
                        return;
                    }
                    case "sources": {
                        this.listSources(console);
                        return;
                    }
                    case "sinks": {
                        this.listSinks(console);
                        return;
                    }
                }
                break block22;
            }
            this.printUsage(console);
        }
    }

    private void listSources(Console console) {
        if (this.audioManager.getSourceIds().size() > 0) {
            for (String source : this.audioManager.getSourceIds()) {
                console.println(source);
            }
        } else {
            console.println("No audio sources found.");
        }
    }

    private void listSinks(Console console) {
        if (this.audioManager.getSinkIds().size() > 0) {
            for (String sink : this.audioManager.getSinkIds()) {
                console.println(sink);
            }
        } else {
            console.println("No audio sinks found.");
        }
    }

    private void play(String[] args, Console console) {
        if (args.length == 1) {
            try {
                this.audioManager.playFile(args[0]);
            }
            catch (AudioException e) {
                console.println(e.getMessage());
            }
        } else if (args.length == 2) {
            Set<String> sinks = this.audioManager.getSinks(args[0]);
            for (String aSink : sinks) {
                try {
                    this.audioManager.playFile(args[1], aSink);
                }
                catch (AudioException e) {
                    console.println(e.getMessage());
                }
            }
        }
    }

    private void stream(String[] args, Console console) {
        if (args.length == 1) {
            try {
                this.audioManager.stream(args[0]);
            }
            catch (AudioException e) {
                console.println(e.getMessage());
            }
        } else if (args.length == 2) {
            Set<String> sinks = this.audioManager.getSinks(args[0]);
            for (String aSink : sinks) {
                try {
                    this.audioManager.stream(args[1], aSink);
                }
                catch (AudioException e) {
                    console.println(e.getMessage());
                }
            }
        }
    }

    protected void setAudioManager(AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    protected void unsetAudioManager(AudioManager audioManager) {
        this.audioManager = null;
    }
}

