/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.profiles;

import java.util.function.Function;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.internal.CommunicationManager;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.util.ThingHandlerHelper;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileCallbackImpl
implements ProfileCallback {
    private final Logger logger = LoggerFactory.getLogger(ProfileCallbackImpl.class);
    private final EventPublisher eventPublisher;
    private final ItemChannelLink link;
    private final Function<ThingUID, Thing> thingProvider;
    private final Function<String, Item> itemProvider;
    private final SafeCaller safeCaller;

    public ProfileCallbackImpl(EventPublisher eventPublisher, SafeCaller safeCaller, ItemChannelLink link, Function<ThingUID, Thing> thingProvider, Function<String, Item> itemProvider) {
        this.eventPublisher = eventPublisher;
        this.safeCaller = safeCaller;
        this.link = link;
        this.thingProvider = thingProvider;
        this.itemProvider = itemProvider;
    }

    @Override
    public void handleCommand(Command command) {
        Thing thing = this.thingProvider.apply(this.link.getLinkedUID().getThingUID());
        if (thing != null) {
            ThingHandler handler = thing.getHandler();
            if (handler != null) {
                if (ThingHandlerHelper.isHandlerInitialized(thing)) {
                    this.logger.debug("Delegating command '{}' for item '{}' to handler for channel '{}'", new Object[]{command, this.link.getItemName(), this.link.getLinkedUID()});
                    ((ThingHandler)this.safeCaller.create((Object)handler).withTimeout(CommunicationManager.THINGHANDLER_EVENT_TIMEOUT).onTimeout(() -> this.logger.warn("Handler for thing '{}' takes more than {}ms for handling a command", (Object)handler.getThing().getUID(), (Object)CommunicationManager.THINGHANDLER_EVENT_TIMEOUT)).build()).handleCommand(this.link.getLinkedUID(), command);
                } else {
                    this.logger.debug("Not delegating command '{}' for item '{}' to handler for channel '{}', because handler is not initialized (thing must be in status UNKNOWN, ONLINE or OFFLINE but was {}).", new Object[]{command, this.link.getItemName(), this.link.getLinkedUID(), thing.getStatus()});
                }
            } else {
                this.logger.warn("Cannot delegate command '{}' for item '{}' to handler for channel '{}', because no handler is assigned. Maybe the binding is not installed or not propertly initialized.", new Object[]{command, this.link.getItemName(), this.link.getLinkedUID()});
            }
        } else {
            this.logger.warn("Cannot delegate command '{}' for item '{}' to handler for channel '{}', because no thing with the UID '{}' could be found.", new Object[]{command, this.link.getItemName(), this.link.getLinkedUID(), this.link.getLinkedUID().getThingUID()});
        }
    }

    @Override
    public void handleUpdate(State state) {
        Thing thing = this.thingProvider.apply(this.link.getLinkedUID().getThingUID());
        if (thing != null) {
            ThingHandler handler = thing.getHandler();
            if (handler != null) {
                if (ThingHandlerHelper.isHandlerInitialized(thing)) {
                    this.logger.debug("Delegating update '{}' for item '{}' to handler for channel '{}'", new Object[]{state, this.link.getItemName(), this.link.getLinkedUID()});
                    ((ThingHandler)this.safeCaller.create((Object)handler).withTimeout(CommunicationManager.THINGHANDLER_EVENT_TIMEOUT).onTimeout(() -> this.logger.warn("Handler for thing '{}' takes more than {}ms for handling an update", (Object)handler.getThing().getUID(), (Object)CommunicationManager.THINGHANDLER_EVENT_TIMEOUT)).build()).handleUpdate(this.link.getLinkedUID(), state);
                } else {
                    this.logger.debug("Not delegating update '{}' for item '{}' to handler for channel '{}', because handler is not initialized (thing must be in status UNKNOWN, ONLINE or OFFLINE but was {}).", new Object[]{state, this.link.getItemName(), this.link.getLinkedUID(), thing.getStatus()});
                }
            } else {
                this.logger.warn("Cannot delegate update '{}' for item '{}' to handler for channel '{}', because no handler is assigned. Maybe the binding is not installed or not propertly initialized.", new Object[]{state, this.link.getItemName(), this.link.getLinkedUID()});
            }
        } else {
            this.logger.warn("Cannot delegate update '{}' for item '{}' to handler for channel '{}', because no thing with the UID '{}' could be found.", new Object[]{state, this.link.getItemName(), this.link.getLinkedUID(), this.link.getLinkedUID().getThingUID()});
        }
    }

    @Override
    public void sendCommand(Command command) {
        this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)this.link.getItemName(), (Command)command, (String)this.link.getLinkedUID().toString()));
    }

    @Override
    public void sendUpdate(State state) {
        Item item = this.itemProvider.apply(this.link.getItemName());
        State acceptedState = ItemUtil.convertToAcceptedState((State)state, (Item)item);
        this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)this.link.getItemName(), (State)acceptedState, (String)this.link.getLinkedUID().toString()));
    }
}

