/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.items.ManagedItemProvider;
import org.eclipse.smarthome.core.items.RegistryHook;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.StateDescriptionProvider;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class ItemRegistryImpl
extends AbstractRegistry<Item, String, ItemProvider>
implements ItemRegistry {
    private final List<StateDescriptionProvider> stateDescriptionProviders = Collections.synchronizedList(new ArrayList());
    private final List<RegistryHook<Item>> registryHooks = new CopyOnWriteArrayList<RegistryHook<Item>>();

    public ItemRegistryImpl() {
        super(ItemProvider.class);
    }

    @Override
    public Item getItem(String name) throws ItemNotFoundException {
        Item item = (Item)this.get(name);
        if (item == null) {
            throw new ItemNotFoundException(name);
        }
        return item;
    }

    @Override
    public Item getItemByPattern(String name) throws ItemNotFoundException, ItemNotUniqueException {
        Collection<Item> items = this.getItems(name);
        if (items.isEmpty()) {
            throw new ItemNotFoundException(name);
        }
        if (items.size() > 1) {
            throw new ItemNotUniqueException(name, items);
        }
        Item item = items.iterator().next();
        if (item == null) {
            throw new ItemNotFoundException(name);
        }
        return item;
    }

    @Override
    public Collection<Item> getItems() {
        return this.getAll();
    }

    @Override
    public Collection<Item> getItemsOfType(String type) {
        ArrayList<Item> matchedItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!item.getType().equals(type)) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    @Override
    public Collection<Item> getItems(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        ArrayList<Item> matchedItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!item.getName().matches(regex)) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    private void addToGroupItems(Item item, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            if (groupName == null) continue;
            try {
                Item groupItem = this.getItem(groupName);
                if (!(groupItem instanceof GroupItem)) continue;
                ((GroupItem)groupItem).addMember(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    private void replaceInGroupItems(Item oldItem, Item newItem, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            if (groupName == null) continue;
            try {
                Item groupItem = this.getItem(groupName);
                if (!(groupItem instanceof GroupItem)) continue;
                ((GroupItem)groupItem).replaceMember(oldItem, newItem);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    private void initializeItem(Item item) throws IllegalArgumentException {
        ItemUtil.assertValidItemName(item.getName());
        this.injectServices(item);
        if (item instanceof GroupItem) {
            this.addMembersToGroupItem((GroupItem)item);
        }
        this.addToGroupItems(item, item.getGroupNames());
    }

    private void injectServices(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.setEventPublisher(this.eventPublisher);
            genericItem.setStateDescriptionProviders(this.stateDescriptionProviders);
        }
    }

    private void clearServices(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.setEventPublisher(null);
            genericItem.setStateDescriptionProviders(null);
        }
    }

    private void addMembersToGroupItem(GroupItem groupItem) {
        for (Item i : this.getItems()) {
            if (!i.getGroupNames().contains(groupItem.getName())) continue;
            groupItem.addMember(i);
        }
    }

    private void removeFromGroupItems(Item item, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            if (groupName == null) continue;
            try {
                Item groupItem = this.getItem(groupName);
                if (!(groupItem instanceof GroupItem)) continue;
                ((GroupItem)groupItem).removeMember(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onAddElement(Item element) throws IllegalArgumentException {
        this.initializeItem(element);
    }

    @Override
    protected void onRemoveElement(Item element) {
        this.clearServices(element);
        this.removeFromGroupItems(element, element.getGroupNames());
    }

    @Override
    protected void onUpdateElement(Item oldItem, Item item) {
        this.clearServices(oldItem);
        this.injectServices(item);
        List<String> oldNames = oldItem.getGroupNames();
        List<String> newNames = item.getGroupNames();
        List<String> commonNames = oldNames.stream().filter(name -> newNames.contains(name)).collect(Collectors.toList());
        this.removeFromGroupItems(oldItem, oldNames.stream().filter(name -> !commonNames.contains(name)).collect(Collectors.toList()));
        this.replaceInGroupItems(oldItem, item, commonNames);
        this.addToGroupItems(item, newNames.stream().filter(name -> !commonNames.contains(name)).collect(Collectors.toList()));
        if (item instanceof GroupItem) {
            this.addMembersToGroupItem((GroupItem)item);
        }
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
        for (Item item : this.getItems()) {
            ((GenericItem)item).setEventPublisher(eventPublisher);
        }
    }

    @Override
    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
        for (Item item : this.getItems()) {
            ((GenericItem)item).setEventPublisher(null);
        }
    }

    @Override
    public Collection<Item> getItemsByTag(String ... tags) {
        ArrayList<Item> filteredItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!this.itemHasTags(item, tags)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    private boolean itemHasTags(Item item, String ... tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (!item.hasTag(tag)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public <T extends GenericItem> Collection<T> getItemsByTag(Class<T> typeFilter, String ... tags) {
        ArrayList<GenericItem> filteredItems = new ArrayList<GenericItem>();
        Collection<Item> items = this.getItemsByTag(tags);
        for (Item item : items) {
            if (!typeFilter.isInstance(item)) continue;
            filteredItems.add((GenericItem)item);
        }
        return filteredItems;
    }

    @Override
    public Collection<Item> getItemsByTagAndType(String type, String ... tags) {
        ArrayList<Item> filteredItems = new ArrayList<Item>();
        for (Item item : this.getItemsOfType(type)) {
            if (!this.itemHasTags(item, tags)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    @Override
    public Item remove(String itemName, boolean recursive) {
        if (this.managedProvider != null) {
            return ((ManagedItemProvider)this.managedProvider).remove(itemName, recursive);
        }
        throw new IllegalStateException("ManagedProvider is not available");
    }

    @Override
    protected void notifyListenersAboutAddedElement(Item element) {
        super.notifyListenersAboutAddedElement(element);
        this.postEvent(ItemEventFactory.createAddedEvent(element));
    }

    @Override
    protected void notifyListenersAboutRemovedElement(Item element) {
        super.notifyListenersAboutRemovedElement(element);
        this.postEvent(ItemEventFactory.createRemovedEvent(element));
    }

    @Override
    protected void notifyListenersAboutUpdatedElement(Item oldElement, Item element) {
        super.notifyListenersAboutUpdatedElement(oldElement, element);
        this.postEvent(ItemEventFactory.createUpdateEvent(element, oldElement));
    }

    @Override
    public void added(Provider<Item> provider, Item element) {
        for (RegistryHook<Item> registryHook : this.registryHooks) {
            registryHook.beforeAdding(element);
        }
        super.added(provider, element);
    }

    @Override
    protected void addProvider(Provider<Item> provider) {
        for (Item element : provider.getAll()) {
            for (RegistryHook<Item> registryHook : this.registryHooks) {
                registryHook.beforeAdding(element);
            }
        }
        super.addProvider(provider);
    }

    @Override
    public void removed(Provider<Item> provider, Item element) {
        super.removed(provider, element);
        for (RegistryHook<Item> registryHook : this.registryHooks) {
            registryHook.afterRemoving(element);
        }
    }

    @Override
    protected void removeProvider(Provider<Item> provider) {
        super.removeProvider(provider);
        for (Item element : provider.getAll()) {
            for (RegistryHook<Item> registryHook : this.registryHooks) {
                registryHook.afterRemoving(element);
            }
        }
    }

    @Override
    public void addRegistryHook(RegistryHook<Item> hook) {
        this.registryHooks.add(hook);
    }

    @Override
    public void removeRegistryHook(RegistryHook<Item> hook) {
        this.registryHooks.remove(hook);
    }

    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext.getBundleContext());
    }

    @Override
    protected void deactivate() {
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addStateDescriptionProvider(StateDescriptionProvider provider) {
        List<StateDescriptionProvider> list = this.stateDescriptionProviders;
        synchronized (list) {
            this.stateDescriptionProviders.add(provider);
            Collections.sort(this.stateDescriptionProviders, new Comparator<StateDescriptionProvider>(){

                @Override
                public int compare(StateDescriptionProvider provider1, StateDescriptionProvider provider2) {
                    return provider2.getRank().compareTo(provider1.getRank());
                }
            });
            for (Item item : this.getItems()) {
                ((GenericItem)item).setStateDescriptionProviders(this.stateDescriptionProviders);
            }
        }
    }

    protected void removeStateDescriptionProvider(StateDescriptionProvider provider) {
        this.stateDescriptionProviders.remove(provider);
        for (Item item : this.getItems()) {
            ((GenericItem)item).setStateDescriptionProviders(this.stateDescriptionProviders);
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedProvider(ManagedItemProvider provider) {
        super.setManagedProvider(provider);
    }

    protected void unsetManagedProvider(ManagedItemProvider provider) {
        super.unsetManagedProvider(provider);
    }
}

