/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupItem
extends GenericItem
implements StateChangeListener {
    public static final @NonNull String TYPE = "Group";
    private final Logger logger = LoggerFactory.getLogger(GroupItem.class);
    protected final GenericItem baseItem;
    protected final CopyOnWriteArrayList<Item> members;
    protected GroupFunction function;

    public GroupItem(@NonNull String name) {
        this(name, null, null);
    }

    public GroupItem(@NonNull String name, GenericItem baseItem) {
        this(name, baseItem, new GroupFunction.Equality());
    }

    public GroupItem(@NonNull String name, GenericItem baseItem, GroupFunction function) {
        super(TYPE, name);
        if (baseItem == null || function == null) {
            this.baseItem = null;
            this.function = null;
        } else {
            this.function = function;
            this.baseItem = baseItem;
        }
        this.members = new CopyOnWriteArrayList();
    }

    public Item getBaseItem() {
        return this.baseItem;
    }

    public GroupFunction getFunction() {
        return this.function;
    }

    public Set<Item> getMembers() {
        return ImmutableSet.copyOf(this.members);
    }

    public Set<Item> getAllMembers() {
        return ImmutableSet.copyOf(this.getMembers(i -> !(i instanceof GroupItem)));
    }

    private void collectMembers(Collection<Item> allMembers, Collection<Item> members) {
        for (Item member : members) {
            if (allMembers.contains(member)) continue;
            allMembers.add(member);
            if (!(member instanceof GroupItem)) continue;
            this.collectMembers(allMembers, ((GroupItem)member).members);
        }
    }

    public Set<Item> getMembers(Predicate<Item> filterItem) {
        HashSet<Item> allMembers = new HashSet<Item>();
        this.collectMembers(allMembers, this.members);
        return allMembers.stream().filter(filterItem).collect(Collectors.toSet());
    }

    public void addMember(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Item must not be null!");
        }
        this.members.addIfAbsent(item);
        this.registerStateListener(item);
    }

    private void registerStateListener(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.addStateChangeListener(this);
        }
    }

    private void unregisterStateListener(Item old) {
        if (old instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)old;
            genericItem.removeStateChangeListener(this);
        }
    }

    public void replaceMember(Item oldItem, Item newItem) {
        if (oldItem == null || newItem == null) {
            throw new IllegalArgumentException("Items must not be null!");
        }
        int index = this.members.indexOf(oldItem);
        if (index > -1) {
            Item old = this.members.set(index, newItem);
            this.unregisterStateListener(old);
        }
        this.registerStateListener(newItem);
    }

    public void removeMember(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Item must not be null!");
        }
        this.members.remove(item);
        this.unregisterStateListener(item);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        if (this.baseItem != null) {
            return this.baseItem.getAcceptedDataTypes();
        }
        ArrayList<Class<? extends State>> acceptedDataTypes = null;
        for (Item item : this.members) {
            if (acceptedDataTypes == null) {
                acceptedDataTypes = new ArrayList<Class<? extends State>>(item.getAcceptedDataTypes());
                continue;
            }
            acceptedDataTypes.retainAll(item.getAcceptedDataTypes());
        }
        return acceptedDataTypes == null ? Collections.unmodifiableList(Collections.EMPTY_LIST) : Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        if (this.baseItem != null) {
            return this.baseItem.getAcceptedCommandTypes();
        }
        ArrayList<Class<? extends Command>> acceptedCommandTypes = null;
        for (Item item : this.members) {
            if (acceptedCommandTypes == null) {
                acceptedCommandTypes = new ArrayList<Class<? extends Command>>(item.getAcceptedCommandTypes());
                continue;
            }
            acceptedCommandTypes.retainAll(item.getAcceptedCommandTypes());
        }
        return acceptedCommandTypes == null ? Collections.unmodifiableList(Collections.EMPTY_LIST) : Collections.unmodifiableList(acceptedCommandTypes);
    }

    public void send(Command command) {
        if (this.getAcceptedCommandTypes().contains(command.getClass())) {
            this.internalSend(command);
        } else {
            this.logger.warn("Command '{}' has been ignored for group '{}' as it is not accepted.", (Object)command.toString(), (Object)this.getName());
        }
    }

    @Override
    protected void internalSend(Command command) {
        if (this.eventPublisher != null) {
            for (Item member : this.members) {
                this.eventPublisher.post(ItemEventFactory.createCommandEvent(member.getName(), command));
            }
        }
    }

    @Override
    public State getStateAs(Class<? extends State> typeClass) {
        State newState = null;
        if (this.function != null) {
            newState = this.function.getStateAs(this.getAllMembers(), typeClass);
        }
        if (newState == null && this.baseItem != null) {
            this.baseItem.setState(this.state);
            newState = this.baseItem.getStateAs(typeClass);
        }
        if (newState == null) {
            newState = super.getStateAs(typeClass);
        }
        return newState;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" (");
        sb.append("Type=");
        sb.append(this.getClass().getSimpleName());
        sb.append(", ");
        if (this.getBaseItem() != null) {
            sb.append("BaseType=");
            sb.append(this.baseItem.getClass().getSimpleName());
            sb.append(", ");
        }
        sb.append("Members=");
        sb.append(this.members.size());
        sb.append(", ");
        sb.append("State=");
        sb.append(this.getState());
        sb.append(", ");
        sb.append("Label=");
        sb.append(this.getLabel());
        sb.append(", ");
        sb.append("Category=");
        sb.append(this.getCategory());
        if (!this.getTags().isEmpty()) {
            sb.append(", ");
            sb.append("Tags=[");
            sb.append(Joiner.on((String)", ").join(this.getTags()));
            sb.append("]");
        }
        if (!this.getGroupNames().isEmpty()) {
            sb.append(", ");
            sb.append("Groups=[");
            sb.append(Joiner.on((String)", ").join(this.getGroupNames()));
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void stateChanged(Item item, State oldState, State newState) {
    }

    @Override
    public void stateUpdated(Item item, State state) {
        State oldState = this.state;
        if (this.function != null && this.baseItem != null) {
            State calculatedState = this.function.calculate(this.getMembers());
            calculatedState = ItemUtil.convertToAcceptedState(calculatedState, this.baseItem);
            this.setState(calculatedState);
        }
        if (!oldState.equals(this.state)) {
            this.sendGroupStateChangedEvent(item.getName(), this.state, oldState);
        }
    }

    @Override
    public void setState(State state) {
        State oldState = this.state;
        if (this.baseItem != null) {
            this.baseItem.setState(state);
            this.state = this.baseItem.getState();
        } else {
            this.state = state;
        }
        this.notifyListeners(oldState, state);
    }

    private void sendGroupStateChangedEvent(String memberName, State newState, State oldState) {
        if (this.eventPublisher != null) {
            this.eventPublisher.post(ItemEventFactory.createGroupStateChangedEvent(this.getName(), memberName, newState, oldState));
        }
    }
}

