/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.item;

import com.google.gson.JsonObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ActiveItem;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ManagedItemProvider;
import org.eclipse.smarthome.core.items.dto.GroupItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTOMapper;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.items.RollershutterItem;
import org.eclipse.smarthome.core.library.items.SwitchItem;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.io.rest.DTOMapper;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.eclipse.smarthome.io.rest.core.item.EnrichedItemDTO;
import org.eclipse.smarthome.io.rest.core.item.EnrichedItemDTOMapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
@Api(value="items")
@Component(service={RESTResource.class, ItemResource.class})
public class ItemResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(ItemResource.class);
    public static final String PATH_ITEMS = "items";
    @Context
    UriInfo uriInfo;
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;
    private ManagedItemProvider managedItemProvider;
    private DTOMapper dtoMapper;
    private final Set<ItemFactory> itemFactories = new HashSet<ItemFactory>();

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedItemProvider(ManagedItemProvider managedItemProvider) {
        this.managedItemProvider = managedItemProvider;
    }

    protected void unsetManagedItemProvider(ManagedItemProvider managedItemProvider) {
        this.managedItemProvider = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setDTOMapper(DTOMapper dtoMapper) {
        this.dtoMapper = dtoMapper;
    }

    protected void unsetDTOMapper(DTOMapper dtoMapper) {
        this.dtoMapper = dtoMapper;
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available items.", response=EnrichedItemDTO.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EnrichedItemDTO.class, responseContainer="List")})
    public Response getItems(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @QueryParam(value="type") @ApiParam(value="item type filter", required=false) String type, @QueryParam(value="tags") @ApiParam(value="item tag filter", required=false) String tags, @DefaultValue(value="false") @QueryParam(value="recursive") @ApiParam(value="get member items recursivly", required=false) boolean recursive, @QueryParam(value="fields") @ApiParam(value="limit output to the given fields (comma separated)", required=false) String fields) {
        Locale locale = LocaleUtil.getLocale((String)language);
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Stream itemStream = this.getItems(type, tags).stream().map(item -> EnrichedItemDTOMapper.map(item, recursive, this.uriInfo.getBaseUri(), locale));
        itemStream = this.dtoMapper.limitToFields(itemStream, fields);
        return Response.ok((Object)new Stream2JSONInputStream(itemStream)).build();
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a single item.", response=EnrichedItemDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EnrichedItemDTO.class), @ApiResponse(code=404, message="Item not found")})
    public Response getItemData(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="itemname") @ApiParam(value="item name", required=true) String itemname) {
        Locale locale = LocaleUtil.getLocale((String)language);
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Item item = this.getItem(itemname);
        if (item != null) {
            this.logger.debug("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
            return this.getItemResponse(Response.Status.OK, item, locale, null);
        }
        this.logger.info("Received HTTP GET request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
        return ItemResource.getItemNotFoundResponse(itemname);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]*}/state")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Gets the state of an item.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Item not found")})
    public Response getPlainItemState(@PathParam(value="itemname") @ApiParam(value="item name", required=true) String itemname) {
        Item item = this.getItem(itemname);
        if (item != null) {
            this.logger.debug("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
            return Response.ok((Object)item.getState().toFullString()).build();
        }
        this.logger.info("Received HTTP GET request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
        return ItemResource.getItemNotFoundResponse(itemname);
    }

    @PUT
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]*}/state")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Updates the state of an item.")
    @ApiResponses(value={@ApiResponse(code=202, message="Accepted"), @ApiResponse(code=404, message="Item not found"), @ApiResponse(code=400, message="Item state null")})
    public Response putItemState(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="itemname") @ApiParam(value="item name", required=true) String itemname, @ApiParam(value="valid item state (e.g. ON, OFF)", required=true) String value) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Item item = this.getItem(itemname);
        if (item != null) {
            State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)value);
            if (state != null) {
                this.logger.debug("Received HTTP PUT request at '{}' with value '{}'.", (Object)this.uriInfo.getPath(), (Object)value);
                this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)itemname, (State)state));
                return this.getItemResponse(Response.Status.ACCEPTED, null, locale, null);
            }
            this.logger.warn("Received HTTP PUT request at '{}' with an invalid status value '{}'.", (Object)this.uriInfo.getPath(), (Object)value);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)("State could not be parsed: " + value));
        }
        this.logger.info("Received HTTP PUT request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
        return ItemResource.getItemNotFoundResponse(itemname);
    }

    @POST
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]*}")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Sends a command to an item.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Item not found"), @ApiResponse(code=400, message="Item command null")})
    public Response postItemCommand(@PathParam(value="itemname") @ApiParam(value="item name", required=true) String itemname, @ApiParam(value="valid item command (e.g. ON, OFF, UP, DOWN, REFRESH)", required=true) String value) {
        Item item = this.getItem(itemname);
        Command command = null;
        if (item != null) {
            if ("toggle".equalsIgnoreCase(value) && (item instanceof SwitchItem || item instanceof RollershutterItem)) {
                if (OnOffType.ON.equals((Object)item.getStateAs(OnOffType.class))) {
                    command = OnOffType.OFF;
                }
                if (OnOffType.OFF.equals((Object)item.getStateAs(OnOffType.class))) {
                    command = OnOffType.ON;
                }
                if (UpDownType.UP.equals((Object)item.getStateAs(UpDownType.class))) {
                    command = UpDownType.DOWN;
                }
                if (UpDownType.DOWN.equals((Object)item.getStateAs(UpDownType.class))) {
                    command = UpDownType.UP;
                }
            } else {
                command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)value);
            }
            if (command != null) {
                this.logger.debug("Received HTTP POST request at '{}' with value '{}'.", (Object)this.uriInfo.getPath(), (Object)value);
                this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)itemname, (Command)command));
                Response.ResponseBuilder resbuilder = Response.ok();
                resbuilder.type("text/plain");
                return resbuilder.build();
            }
            this.logger.warn("Received HTTP POST request at '{}' with an invalid status value '{}'.", (Object)this.uriInfo.getPath(), (Object)value);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logger.info("Received HTTP POST request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
        throw new WebApplicationException(404);
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemName: [a-zA-Z_0-9]*}/members/{memberItemName: [a-zA-Z_0-9]*}")
    @ApiOperation(value="Adds a new member to a group item.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Item or member item not found or item is not of type group item."), @ApiResponse(code=405, message="Member item is not editable.")})
    public Response addMember(@PathParam(value="itemName") @ApiParam(value="item name", required=true) String itemName, @PathParam(value="memberItemName") @ApiParam(value="member item name", required=true) String memberItemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            if (!(item instanceof GroupItem)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            GroupItem groupItem = (GroupItem)item;
            Item memberItem = this.itemRegistry.getItem(memberItemName);
            if (!(memberItem instanceof GenericItem)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (this.managedItemProvider.get((Object)memberItemName) == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
            }
            GenericItem genericMemberItem = (GenericItem)memberItem;
            genericMemberItem.addGroupName(groupItem.getName());
            this.managedItemProvider.update((Identifiable)genericMemberItem);
            return Response.ok().build();
        }
        catch (ItemNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemName: [a-zA-Z_0-9]*}/members/{memberItemName: [a-zA-Z_0-9]*}")
    @ApiOperation(value="Removes an existing member from a group item.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Item or member item not found or item is not of type group item."), @ApiResponse(code=405, message="Member item is not editable.")})
    public Response removeMember(@PathParam(value="itemName") @ApiParam(value="item name", required=true) String itemName, @PathParam(value="memberItemName") @ApiParam(value="member item name", required=true) String memberItemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            if (!(item instanceof GroupItem)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            GroupItem groupItem = (GroupItem)item;
            Item memberItem = this.itemRegistry.getItem(memberItemName);
            if (!(memberItem instanceof GenericItem)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (this.managedItemProvider.get((Object)memberItemName) == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
            }
            GenericItem genericMemberItem = (GenericItem)memberItem;
            genericMemberItem.removeGroupName(groupItem.getName());
            this.managedItemProvider.update((Identifiable)genericMemberItem);
            return Response.ok().build();
        }
        catch (ItemNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]*}")
    @ApiOperation(value="Removes an item from the registry.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Item not found or item is not editable.")})
    public Response removeItem(@PathParam(value="itemname") @ApiParam(value="item name", required=true) @NonNull String itemname) {
        if (this.managedItemProvider.remove((Object)itemname) == null) {
            this.logger.info("Received HTTP DELETE request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]*}/tags/{tag}")
    @ApiOperation(value="Adds a tag to an item.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Item not found."), @ApiResponse(code=405, message="Item not editable.")})
    public Response addTag(@PathParam(value="itemname") @ApiParam(value="item name", required=true) String itemname, @PathParam(value="tag") @ApiParam(value="tag", required=true) String tag) {
        Item item = this.getItem(itemname);
        if (item == null) {
            this.logger.info("Received HTTP PUT request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (this.managedItemProvider.get((Object)itemname) == null) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        ((ActiveItem)item).addTag(tag);
        this.managedItemProvider.update((Identifiable)item);
        return Response.ok().build();
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]*}/tags/{tag}")
    @ApiOperation(value="Removes a tag from an item.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Item not found."), @ApiResponse(code=405, message="Item not editable.")})
    public Response removeTag(@PathParam(value="itemname") @ApiParam(value="item name", required=true) String itemname, @PathParam(value="tag") @ApiParam(value="tag", required=true) String tag) {
        Item item = this.getItem(itemname);
        if (item == null) {
            this.logger.info("Received HTTP DELETE request at '{}' for the unknown item '{}'.", (Object)this.uriInfo.getPath(), (Object)itemname);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (this.managedItemProvider.get((Object)itemname) == null) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        ((ActiveItem)item).removeTag(tag);
        this.managedItemProvider.update((Identifiable)item);
        return Response.ok().build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]*}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Adds a new item to the registry or updates the existing item.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=201, message="Item created."), @ApiResponse(code=400, message="Item null."), @ApiResponse(code=404, message="Item not found."), @ApiResponse(code=405, message="Item not editable.")})
    public Response createOrUpdateItem(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="itemname") @ApiParam(value="item name", required=true) String itemname, @ApiParam(value="item data", required=true) GroupItemDTO item) {
        Locale locale = LocaleUtil.getLocale((String)language);
        if (item == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ActiveItem newItem = this.createActiveItem(item);
        if (newItem == null) {
            this.logger.warn("Received HTTP PUT request at '{}' with an invalid item type '{}'.", (Object)this.uriInfo.getPath(), (Object)item.type);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (this.getItem(itemname) == null) {
            this.managedItemProvider.add((Identifiable)newItem);
            return this.getItemResponse(Response.Status.CREATED, (Item)newItem, locale, null);
        }
        if (this.managedItemProvider.get((Object)itemname) != null) {
            this.managedItemProvider.update((Identifiable)newItem);
            return this.getItemResponse(Response.Status.OK, (Item)newItem, locale, null);
        }
        this.logger.warn("Cannot update existing item '{}', because is not managed.", (Object)itemname);
        return JSONResponse.createErrorResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (String)("Cannot update non-managed Item " + itemname));
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Adds a list of items to the registry or updates the existing items.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=400, message="Item list is null.")})
    public Response createOrUpdateItems(@ApiParam(value="array of item data", required=true) GroupItemDTO[] items) {
        if (items == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList<GroupItemDTO> wrongTypes = new ArrayList<GroupItemDTO>();
        ArrayList<ActiveItem> activeItems = new ArrayList<ActiveItem>();
        GroupItemDTO[] groupItemDTOArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            GroupItemDTO item = groupItemDTOArray[n2];
            ActiveItem activeItem = this.createActiveItem(item);
            if (activeItem == null) {
                wrongTypes.add(item);
            } else {
                activeItems.add(activeItem);
            }
            ++n2;
        }
        ArrayList<ActiveItem> createdItems = new ArrayList<ActiveItem>();
        ArrayList<ActiveItem> updatedItems = new ArrayList<ActiveItem>();
        ArrayList<ActiveItem> failedItems = new ArrayList<ActiveItem>();
        for (ActiveItem activeItem : activeItems) {
            String itemName = activeItem.getName();
            if (this.getItem(itemName) == null) {
                this.managedItemProvider.add((Identifiable)activeItem);
                createdItems.add(activeItem);
                continue;
            }
            if (this.managedItemProvider.get((Object)itemName) != null) {
                this.managedItemProvider.update((Identifiable)activeItem);
                updatedItems.add(activeItem);
                continue;
            }
            this.logger.warn("Cannot update existing item '{}', because it is not managed.", (Object)itemName);
            failedItems.add(activeItem);
        }
        ArrayList<JsonObject> responseList = new ArrayList<JsonObject>();
        for (GroupItemDTO groupItemDTO : wrongTypes) {
            responseList.add(this.buildStatusObject(groupItemDTO.name, "error", "Received HTTP PUT request at '" + this.uriInfo.getPath() + "' with an invalid item type '" + groupItemDTO.type + "'."));
        }
        for (ActiveItem activeItem : failedItems) {
            responseList.add(this.buildStatusObject(activeItem.getName(), "error", "Cannot update non-managed item"));
        }
        for (ActiveItem activeItem : createdItems) {
            responseList.add(this.buildStatusObject(activeItem.getName(), "created", null));
        }
        for (ActiveItem activeItem : updatedItems) {
            responseList.add(this.buildStatusObject(activeItem.getName(), "updated", null));
        }
        return JSONResponse.createResponse((Response.Status)Response.Status.OK, responseList, null);
    }

    private ActiveItem createActiveItem(GroupItemDTO item) {
        ActiveItem activeItem = ItemDTOMapper.map((ItemDTO)item, this.itemFactories);
        if (activeItem != null) {
            activeItem.setLabel(item.label);
            if (item.category != null) {
                activeItem.setCategory(item.category);
            }
            if (item.groupNames != null) {
                activeItem.addGroupNames(item.groupNames);
            }
            if (item.tags != null) {
                activeItem.addTags((Collection)item.tags);
            }
        }
        return activeItem;
    }

    private JsonObject buildStatusObject(String itemName, String status, String message) {
        JsonObject jo = new JsonObject();
        jo.addProperty("name", itemName);
        jo.addProperty("status", status);
        jo.addProperty("message", message);
        return jo;
    }

    private static Response getItemNotFoundResponse(String itemname) {
        String message = "Item " + itemname + " does not exist!";
        return JSONResponse.createResponse((Response.Status)Response.Status.NOT_FOUND, null, (String)message);
    }

    private Response getItemResponse(Response.Status status, Item item, Locale locale, String errormessage) {
        EnrichedItemDTO entity = item != null ? EnrichedItemDTOMapper.map(item, true, this.uriInfo.getBaseUri(), locale) : null;
        return JSONResponse.createResponse((Response.Status)status, entity, (String)errormessage);
    }

    private Item getItem(String itemname) {
        return (Item)this.itemRegistry.get((Object)itemname);
    }

    private Collection<Item> getItems(String type, String tags) {
        Collection items;
        if (tags == null) {
            items = type == null ? this.itemRegistry.getItems() : this.itemRegistry.getItemsOfType(type);
        } else {
            String[] tagList = tags.split(",");
            items = type == null ? this.itemRegistry.getItemsByTag(tagList) : this.itemRegistry.getItemsByTagAndType(type, tagList);
        }
        return items;
    }

    public boolean isSatisfied() {
        return this.itemRegistry != null && this.managedItemProvider != null && this.eventPublisher != null && !this.itemFactories.isEmpty() && this.dtoMapper != null;
    }
}

