/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sitemap.internal;

import java.io.IOException;
import org.eclipse.smarthome.io.rest.sitemap.SitemapSubscriptionService;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapEvent;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapWidgetEvent;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitemapEventOutput
extends EventOutput {
    private final Logger logger = LoggerFactory.getLogger(SitemapEventOutput.class);
    private final String subscriptionId;
    private final SitemapSubscriptionService subscriptions;

    public SitemapEventOutput(SitemapSubscriptionService subscriptions, String subscriptionId) {
        this.subscriptions = subscriptions;
        this.subscriptionId = subscriptionId;
    }

    public void write(OutboundEvent chunk) throws IOException {
        if (chunk.getName().equals("subscriptionId") && chunk.getData().equals(this.subscriptionId)) {
            super.write((Object)chunk);
        } else {
            SitemapEvent event = (SitemapEvent)chunk.getData();
            String sitemapName = event.sitemapName;
            String pageId = event.pageId;
            if (sitemapName != null && sitemapName.equals(this.subscriptions.getSitemapName(this.subscriptionId)) && pageId != null && pageId.equals(this.subscriptions.getPageId(this.subscriptionId))) {
                super.write((Object)chunk);
                if (this.logger.isDebugEnabled() && event instanceof SitemapWidgetEvent) {
                    this.logger.debug("Sent sitemap event for widget {} to subscription {}.", (Object)((SitemapWidgetEvent)event).widgetId, (Object)this.subscriptionId);
                }
            }
        }
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }
}

