/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt.reconnect;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.ConfigurationException;
import org.eclipse.smarthome.io.transport.mqtt.MqttException;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.AbstractReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicReconnectStrategy
extends AbstractReconnectStrategy {
    private final Logger logger = LoggerFactory.getLogger(PeriodicReconnectStrategy.class);
    private final int reconnectFrequency;
    private final int firstReconnectAfter;
    private ScheduledExecutorService scheduler = null;
    private ScheduledFuture<?> scheduledTask;

    public PeriodicReconnectStrategy() {
        this(10000, 60000);
    }

    public PeriodicReconnectStrategy(int reconnectFrequency, int firstReconnectAfter) {
        this.reconnectFrequency = reconnectFrequency;
        this.firstReconnectAfter = firstReconnectAfter;
    }

    @Override
    public synchronized void start() {
        if (this.scheduler == null) {
            this.scheduler = Executors.newScheduledThreadPool(1);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
            this.scheduledTask = null;
        }
    }

    public synchronized boolean isStarted() {
        return this.scheduler != null;
    }

    @Override
    public synchronized void lostConnection() {
        if (this.scheduler == null) {
            return;
        }
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            return;
        }
        this.logger.info("Try to restore connection to '{}' every {}ms", (Object)this.getBrokerConnection().getName(), (Object)this.getReconnectFrequency());
        this.scheduledTask = this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.getBrokerConnection().start();
            }
            catch (ConfigurationException | MqttException e) {
                this.logger.warn("Broker connection couldn't be started", (Throwable)e);
            }
        }, this.getFirstReconnectAfter(), this.getReconnectFrequency(), TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void connectionEstablished() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
            this.scheduledTask = null;
        }
    }

    @Override
    public synchronized boolean isReconnecting() {
        return this.scheduledTask != null;
    }

    public int getReconnectFrequency() {
        return this.reconnectFrequency;
    }

    public int getFirstReconnectAfter() {
        return this.firstReconnectAfter;
    }
}

