/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.persistence.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.persistence.PersistenceManager;
import org.eclipse.smarthome.core.persistence.PersistenceServiceConfiguration;
import org.eclipse.smarthome.core.persistence.SimpleFilter;
import org.eclipse.smarthome.core.persistence.SimpleItemConfiguration;
import org.eclipse.smarthome.core.persistence.config.SimpleAllConfig;
import org.eclipse.smarthome.core.persistence.config.SimpleGroupConfig;
import org.eclipse.smarthome.core.persistence.config.SimpleItemConfig;
import org.eclipse.smarthome.core.persistence.strategy.SimpleCronStrategy;
import org.eclipse.smarthome.core.persistence.strategy.SimpleStrategy;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.persistence.persistence.AllConfig;
import org.eclipse.smarthome.model.persistence.persistence.CronStrategy;
import org.eclipse.smarthome.model.persistence.persistence.Filter;
import org.eclipse.smarthome.model.persistence.persistence.GroupConfig;
import org.eclipse.smarthome.model.persistence.persistence.ItemConfig;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceConfiguration;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceModel;
import org.eclipse.smarthome.model.persistence.persistence.Strategy;

public class PersistenceModelManager
implements ModelRepositoryChangeListener {
    private ModelRepository modelRepository;
    private PersistenceManager manager;

    protected void activate() {
        this.modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        for (String modelName : this.modelRepository.getAllModelNamesOfType("persist")) {
            String serviceName = modelName.substring(0, modelName.length() - ".persist".length());
            this.manager.startEventHandling(serviceName);
        }
    }

    protected void deactivate() {
        this.modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        for (String modelName : this.modelRepository.getAllModelNamesOfType("persist")) {
            this.manager.stopEventHandling(modelName);
        }
    }

    protected void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    protected void unsetModelRepository(ModelRepository modelRepository) {
        this.modelRepository = null;
    }

    protected void setPersistenceManager(PersistenceManager manager) {
        this.manager = manager;
    }

    protected void unsetPersistenceManager(PersistenceManager manager) {
        this.manager = null;
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith(".persist")) {
            PersistenceModel model;
            String dbId = modelName.substring(0, modelName.length() - ".persist".length());
            if (type == EventType.REMOVED || type == EventType.MODIFIED) {
                this.manager.removeConfig(dbId);
            }
            if ((type == EventType.ADDED || type == EventType.MODIFIED) && (model = (PersistenceModel)this.modelRepository.getModel(modelName)) != null) {
                this.manager.addConfig(dbId, new PersistenceServiceConfiguration(this.mapConfigs((List<PersistenceConfiguration>)model.getConfigs()), this.mapStrategies((List<Strategy>)model.getDefaults()), this.mapStrategies((List<Strategy>)model.getStrategies())));
            }
        }
    }

    private List<SimpleItemConfiguration> mapConfigs(List<PersistenceConfiguration> configs) {
        LinkedList<SimpleItemConfiguration> lst = new LinkedList<SimpleItemConfiguration>();
        for (PersistenceConfiguration config : configs) {
            lst.add(this.mapConfig(config));
        }
        return lst;
    }

    private SimpleItemConfiguration mapConfig(PersistenceConfiguration config) {
        LinkedList<Object> items = new LinkedList<Object>();
        for (EObject item : config.getItems()) {
            if (item instanceof AllConfig) {
                items.add(new SimpleAllConfig());
                continue;
            }
            if (item instanceof GroupConfig) {
                items.add(new SimpleGroupConfig(((GroupConfig)item).getGroup()));
                continue;
            }
            if (!(item instanceof ItemConfig)) continue;
            items.add(new SimpleItemConfig(((ItemConfig)item).getItem()));
        }
        return new SimpleItemConfiguration(items, config.getAlias(), this.mapStrategies((List<Strategy>)config.getStrategies()), this.mapFilters((List<Filter>)config.getFilters()));
    }

    private List<SimpleStrategy> mapStrategies(List<Strategy> strategies) {
        LinkedList<SimpleStrategy> lst = new LinkedList<SimpleStrategy>();
        for (Strategy strategy : strategies) {
            lst.add(this.mapStrategy(strategy));
        }
        return lst;
    }

    private SimpleStrategy mapStrategy(Strategy strategy) {
        if (strategy instanceof CronStrategy) {
            return new SimpleCronStrategy(strategy.getName(), ((CronStrategy)strategy).getCronExpression());
        }
        return new SimpleStrategy(strategy.getName());
    }

    private List<SimpleFilter> mapFilters(List<Filter> filters) {
        LinkedList<SimpleFilter> lst = new LinkedList<SimpleFilter>();
        for (Filter filter : filters) {
            lst.add(this.mapFilter(filter));
        }
        return lst;
    }

    private SimpleFilter mapFilter(Filter filter) {
        return new SimpleFilter();
    }
}

