/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.WebAppConfig;
import org.eclipse.smarthome.ui.classic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.classic.render.RenderException;
import org.eclipse.smarthome.ui.classic.render.WidgetRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(PageRenderer.class);
    List<WidgetRenderer> widgetRenderers = new ArrayList<WidgetRenderer>();

    public void addWidgetRenderer(WidgetRenderer widgetRenderer) {
        widgetRenderer.setConfig(this.config);
        this.widgetRenderers.add(widgetRenderer);
    }

    public void removeWidgetRenderer(WidgetRenderer widgetRenderer) {
        this.widgetRenderers.remove(widgetRenderer);
    }

    public StringBuilder processPage(String id, String sitemap, String label, EList<Widget> children, boolean async) throws RenderException {
        String snippet = this.getSnippet(async ? "layer" : "main");
        snippet = snippet.replaceAll("%id%", id);
        String labelPlain = label;
        if (labelPlain.contains("[") && labelPlain.endsWith("]")) {
            labelPlain = labelPlain.replace("[", "").replace("]", "");
        }
        snippet = StringUtils.replace((String)snippet, (String)"%labelstyle%", (String)"");
        snippet = StringUtils.replace((String)snippet, (String)"%label%", (String)StringEscapeUtils.escapeHtml((String)labelPlain));
        snippet = StringUtils.replace((String)snippet, (String)"%servletname%", (String)"app");
        snippet = StringUtils.replace((String)snippet, (String)"%sitemap%", (String)sitemap);
        String[] parts = snippet.split("%children%");
        StringBuilder pre_children = new StringBuilder(parts[0]);
        StringBuilder post_children = new StringBuilder(parts[1]);
        if (parts.length == 2) {
            this.processChildren(pre_children, post_children, children);
        } else if (parts.length > 2) {
            this.logger.error("Snippet '{}' contains multiple %children% sections, but only one is allowed!", (Object)(async ? "layer" : "main"));
        }
        return pre_children.append((CharSequence)post_children);
    }

    private void processChildren(StringBuilder sb_pre, StringBuilder sb_post, EList<Widget> children) throws RenderException {
        if (!children.isEmpty()) {
            boolean frameRequired = false;
            for (Widget w : children) {
                EObject parent = this.itemUIRegistry.getParent(w);
                if (w instanceof Frame || parent instanceof Frame || parent instanceof List) continue;
                frameRequired = true;
            }
            if (frameRequired) {
                String frameSnippet = this.getSnippet("frame");
                String[] parts = (frameSnippet = StringUtils.replace((String)frameSnippet, (String)"%label%", (String)"")).split("%children%");
                if (parts.length > 1) {
                    sb_pre.append(parts[0]);
                }
                if (parts.length > 2) {
                    sb_post.insert(0, parts[1]);
                }
                if (parts.length > 2) {
                    this.logger.error("Snippet 'frame' contains multiple %children% sections, but only one is allowed!");
                }
            }
        }
        for (Widget w : children) {
            StringBuilder new_pre = new StringBuilder();
            StringBuilder new_post = new StringBuilder();
            StringBuilder widgetSB = new StringBuilder();
            EList<Widget> nextChildren = this.renderWidget(w, widgetSB);
            if (nextChildren != null) {
                String[] parts = widgetSB.toString().split("%children%");
                if (parts.length == 1) {
                    new_pre.append((CharSequence)widgetSB);
                }
                if (parts.length > 1) {
                    new_pre.append(parts[0]);
                    new_post.insert(0, parts[1]);
                }
                if (parts.length > 2) {
                    String widgetType = w.eClass().getInstanceTypeName().substring(w.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
                    this.logger.error("Snippet for widget '{}' contains multiple %children% sections, but only one is allowed!", (Object)widgetType);
                }
                this.processChildren(new_pre, new_post, nextChildren);
                sb_pre.append((CharSequence)new_pre);
                sb_pre.append((CharSequence)new_post);
                continue;
            }
            sb_pre.append((CharSequence)widgetSB);
        }
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        if (!this.itemUIRegistry.getVisiblity(w)) {
            return null;
        }
        for (WidgetRenderer renderer : this.widgetRenderers) {
            if (!renderer.canRender(w)) continue;
            return renderer.renderWidget(w, sb);
        }
        return null;
    }

    @Override
    public boolean canRender(Widget w) {
        return false;
    }

    @Override
    public void setConfig(WebAppConfig config) {
        this.config = config;
        for (WidgetRenderer renderer : this.widgetRenderers) {
            renderer.setConfig(config);
        }
    }
}

