/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.paper.internal;

import org.eclipse.smarthome.io.net.http.HttpContextFactoryService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class PaperUIApp {
    public static final String WEBAPP_ALIAS = "/paperui";
    private final Logger logger = LoggerFactory.getLogger(PaperUIApp.class);
    protected HttpService httpService;
    private HttpContextFactoryService httpContextFactoryService;

    protected void activate(BundleContext bundleContext) {
        try {
            Bundle paperuiBundle = bundleContext.getBundle();
            this.httpService.registerResources(WEBAPP_ALIAS, "web", this.httpContextFactoryService.createDefaultHttpContext(paperuiBundle));
            this.logger.info("Started Paper UI at /paperui");
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.httpService.unregister(WEBAPP_ALIAS);
        this.logger.info("Stopped Paper UI");
    }

    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    public void setHttpContextFactoryService(HttpContextFactoryService httpContextFactoryService) {
        this.httpContextFactoryService = httpContextFactoryService;
    }

    public void unsetHttpContextFactoryService(HttpContextFactoryService httpContextFactoryService) {
        this.httpContextFactoryService = null;
    }
}

