/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.auth.jaas.internal;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.smarthome.core.auth.Authentication;
import org.eclipse.smarthome.core.auth.AuthenticationException;
import org.eclipse.smarthome.core.auth.AuthenticationProvider;
import org.eclipse.smarthome.core.auth.Credentials;
import org.eclipse.smarthome.core.auth.UsernamePasswordCredentials;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid="org.eclipse.smarthome.jaas")
public class JaasAuthenticationProvider
implements AuthenticationProvider {
    private String realmName;

    public Authentication authenticate(Credentials credentials) throws AuthenticationException {
        if (this.realmName == null) {
            return null;
        }
        if (!(credentials instanceof UsernamePasswordCredentials)) {
            throw new AuthenticationException("Unsupported credentials passed to provider.");
        }
        UsernamePasswordCredentials userCredentials = (UsernamePasswordCredentials)credentials;
        final String name = userCredentials.getUsername();
        final char[] password = userCredentials.getPassword().toCharArray();
        try {
            LoginContext loginContext = new LoginContext(this.realmName, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    Callback[] callbackArray = callbacks;
                    int n = callbacks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Callback callback = callbackArray[n2];
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password);
                        } else if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(name);
                        } else {
                            throw new UnsupportedCallbackException(callback);
                        }
                        ++n2;
                    }
                }
            });
            loginContext.login();
            return this.getAuthentication(name, loginContext.getSubject());
        }
        catch (LoginException e) {
            throw new AuthenticationException("Could not obtain authentication over login context", (Throwable)e);
        }
    }

    private Authentication getAuthentication(String name, Subject subject) {
        return new Authentication(name, this.getRoles(subject.getPrincipals()));
    }

    private String[] getRoles(Set<Principal> principals) {
        String[] roles = new String[principals.size()];
        int i = 0;
        for (Principal principal : principals) {
            roles[i++] = principal.getName();
        }
        return roles;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties) {
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (properties == null) {
            this.realmName = null;
            return;
        }
        Object propertyValue = properties.get("realmName");
        this.realmName = propertyValue != null ? (propertyValue instanceof String ? (String)propertyValue : propertyValue.toString()) : null;
    }

    public boolean supports(Class<? extends Credentials> type) {
        return UsernamePasswordCredentials.class.isAssignableFrom(type);
    }
}

