/**
 * Copyright (c) 2014,2018 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.automation.handler;

import java.util.Map;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;

/**
 * This interface should be implemented by external modules which provide functionality for processing {@link Action}
 * modules. This functionality is called to execute the {@link Action}s of the {@link Rule} when it is needed.
 *
 * @author Yordan Mihaylov - Initial Contribution
 * @author Ana Dimova - Initial Contribution
 * @author Vasil Ilchev - Initial Contribution
 */
@NonNullByDefault
public interface ActionHandler extends ModuleHandler {

    /**
     * Called to execute an {@link Action} of the {@link Rule} when it is needed.
     *
     * @param context an unmodifiable map containing the outputs of the {@link Trigger} that triggered the {@link Rule},
     *                the outputs of all preceding {@link Action}s, and the inputs for this {@link Action}.
     *
     * @return a map with the {@code outputs} which are the result of the {@link Action}'s execution (may be null).
     */
    @Nullable
    Map<String, Object> execute(Map<String, Object> context);

}
