/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.dto;

import java.util.List;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.core.dto.ActionDTOMapper;
import org.eclipse.smarthome.automation.core.dto.ConditionDTOMapper;
import org.eclipse.smarthome.automation.core.dto.TriggerDTOMapper;
import org.eclipse.smarthome.automation.core.util.RuleBuilder;
import org.eclipse.smarthome.automation.dto.RuleDTO;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;

public class RuleDTOMapper {
    public static RuleDTO map(Rule rule) {
        RuleDTO ruleDto = new RuleDTO();
        RuleDTOMapper.fillProperties(rule, ruleDto);
        return ruleDto;
    }

    public static Rule map(RuleDTO ruleDto) {
        return RuleBuilder.create(ruleDto.uid).withActions(ActionDTOMapper.mapDto(ruleDto.actions)).withConditions(ConditionDTOMapper.mapDto(ruleDto.conditions)).withTriggers(TriggerDTOMapper.mapDto(ruleDto.triggers)).withConfiguration(new Configuration(ruleDto.configuration)).withConfigurationDescriptions(ConfigDescriptionDTOMapper.map((List)ruleDto.configDescriptions)).withTemplateUID(ruleDto.templateUID).withVisibility(ruleDto.visibility).withTags(ruleDto.tags).withName(ruleDto.name).withDescription(ruleDto.description).build();
    }

    protected static void fillProperties(Rule from, RuleDTO to) {
        to.triggers = TriggerDTOMapper.map(from.getTriggers());
        to.conditions = ConditionDTOMapper.map(from.getConditions());
        to.actions = ActionDTOMapper.map(from.getActions());
        to.configuration = from.getConfiguration().getProperties();
        to.configDescriptions = ConfigDescriptionDTOMapper.mapParameters((List)from.getConfigurationDescriptions());
        to.templateUID = from.getTemplateUID();
        to.uid = from.getUID();
        to.name = from.getName();
        to.tags = from.getTags();
        to.visibility = from.getVisibility();
        to.description = from.getDescription();
    }
}

