/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.automation.core.dto.ModuleTypeDTOMapper;
import org.eclipse.smarthome.automation.core.dto.TriggerDTOMapper;
import org.eclipse.smarthome.automation.dto.CompositeTriggerTypeDTO;
import org.eclipse.smarthome.automation.dto.TriggerTypeDTO;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;

public class TriggerTypeDTOMapper
extends ModuleTypeDTOMapper {
    public static TriggerTypeDTO map(TriggerType triggerType) {
        return TriggerTypeDTOMapper.map(triggerType, new TriggerTypeDTO());
    }

    public static CompositeTriggerTypeDTO map(CompositeTriggerType triggerType) {
        CompositeTriggerTypeDTO triggerTypeDto = TriggerTypeDTOMapper.map((TriggerType)triggerType, new CompositeTriggerTypeDTO());
        triggerTypeDto.children = TriggerDTOMapper.map(triggerType.getChildren());
        return triggerTypeDto;
    }

    public static TriggerType map(CompositeTriggerTypeDTO triggerTypeDto) {
        if (triggerTypeDto.children == null || triggerTypeDto.children.isEmpty()) {
            return new TriggerType(triggerTypeDto.uid, ConfigDescriptionDTOMapper.map((List)triggerTypeDto.configDescriptions), triggerTypeDto.label, triggerTypeDto.description, triggerTypeDto.tags, triggerTypeDto.visibility, triggerTypeDto.outputs);
        }
        return new CompositeTriggerType(triggerTypeDto.uid, ConfigDescriptionDTOMapper.map((List)triggerTypeDto.configDescriptions), triggerTypeDto.label, triggerTypeDto.description, triggerTypeDto.tags, triggerTypeDto.visibility, triggerTypeDto.outputs, TriggerDTOMapper.mapDto(triggerTypeDto.children));
    }

    public static List<TriggerTypeDTO> map(Collection<TriggerType> types) {
        if (types == null) {
            return null;
        }
        ArrayList<TriggerTypeDTO> dtos = new ArrayList<TriggerTypeDTO>(types.size());
        for (TriggerType type : types) {
            if (type instanceof CompositeTriggerType) {
                dtos.add((TriggerTypeDTO)TriggerTypeDTOMapper.map((CompositeTriggerType)type));
                continue;
            }
            dtos.add(TriggerTypeDTOMapper.map(type));
        }
        return dtos;
    }

    private static <T extends TriggerTypeDTO> T map(TriggerType triggerType, T triggerTypeDto) {
        TriggerTypeDTOMapper.fillProperties((ModuleType)triggerType, triggerTypeDto);
        triggerTypeDto.outputs = triggerType.getOutputs();
        return triggerTypeDto;
    }
}

