/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.ModuleHandlerCallback;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleManager;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusDetail;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.Connection;
import org.eclipse.smarthome.automation.core.internal.ConnectionValidator;
import org.eclipse.smarthome.automation.core.internal.RuleEventFactory;
import org.eclipse.smarthome.automation.core.internal.RuleRegistryImpl;
import org.eclipse.smarthome.automation.core.internal.TriggerHandlerCallbackImpl;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeModuleHandlerFactory;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedAction;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedCondition;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedModule;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedRule;
import org.eclipse.smarthome.automation.core.internal.ruleengine.WrappedTrigger;
import org.eclipse.smarthome.automation.core.util.ReferenceResolver;
import org.eclipse.smarthome.automation.events.RuleStatusInfoEvent;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class RuleEngineImpl
implements RuleManager,
RegistryChangeListener<ModuleType> {
    public static final char OUTPUT_SEPARATOR = '.';
    private static final String DISABLED_RULE_STORAGE = "automation_rules_disabled";
    private long scheduleReinitializationDelay;
    @NonNullByDefault(value={})
    private final Map<String, WrappedRule> managedRules = new ConcurrentHashMap<String, WrappedRule>();
    @NonNullByDefault(value={})
    private final Map<String, TriggerHandlerCallbackImpl> thCallbacks = new HashMap<String, TriggerHandlerCallbackImpl>();
    @NonNullByDefault(value={})
    private final Map<String, Set<String>> mapModuleTypeToRules = new HashMap<String, Set<String>>();
    @NonNullByDefault(value={})
    private final Map<String, ModuleHandlerFactory> moduleHandlerFactories;
    private final Set<ModuleHandlerFactory> allModuleHandlerFactories = new CopyOnWriteArraySet<ModuleHandlerFactory>();
    private @Nullable Storage<Boolean> disabledRulesStorage;
    private boolean isDisposed = false;
    protected Logger logger = LoggerFactory.getLogger((String)RuleEngineImpl.class.getName());
    @NonNullByDefault(value={})
    private RuleRegistryImpl ruleRegistry;
    @NonNullByDefault(value={})
    private final Map<String, Map<String, Object>> contextMap;
    @NonNullByDefault(value={})
    private ModuleTypeRegistry mtRegistry;
    @NonNullByDefault(value={})
    private CompositeModuleHandlerFactory compositeFactory;
    @NonNullByDefault(value={})
    private final Map<String, Future<?>> scheduleTasks = new HashMap(31);
    private @Nullable ScheduledExecutorService executor;
    @NonNullByDefault(value={})
    private RegistryChangeListener<Rule> listener;
    private @Nullable EventPublisher eventPublisher;
    private static final String SOURCE = RuleEngineImpl.class.getSimpleName();
    private final ModuleHandlerCallback moduleHandlerCallback = new ModuleHandlerCallback(){

        public @Nullable Boolean isEnabled(String ruleUID) {
            return RuleEngineImpl.this.isEnabled(ruleUID);
        }

        public void setEnabled(String uid, boolean isEnabled) {
            RuleEngineImpl.this.setEnabled(uid, isEnabled);
        }

        public @Nullable RuleStatusInfo getStatusInfo(String ruleUID) {
            return RuleEngineImpl.this.getStatusInfo(ruleUID);
        }

        public @Nullable RuleStatus getStatus(String ruleUID) {
            return RuleEngineImpl.this.getStatus(ruleUID);
        }

        public void runNow(String uid) {
            RuleEngineImpl.this.runNow(uid);
        }

        public void runNow(String uid, boolean considerConditions, @Nullable Map<String, Object> context) {
            RuleEngineImpl.this.runNow(uid, considerConditions, context);
        }
    };

    public RuleEngineImpl() {
        this.contextMap = new HashMap<String, Map<String, Object>>();
        this.moduleHandlerFactories = new HashMap<String, ModuleHandlerFactory>(20);
    }

    @Activate
    protected void activate() {
        this.compositeFactory = new CompositeModuleHandlerFactory(this.mtRegistry, this);
        for (Rule rule : this.ruleRegistry.getAll()) {
            String uid = rule.getUID();
            Storage<Boolean> disabledRulesStorage = this.disabledRulesStorage;
            if (disabledRulesStorage != null && disabledRulesStorage.get(uid) != null) continue;
            this.setEnabled(uid, true);
        }
    }

    @Reference
    protected void setModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.mtRegistry = moduleTypeRegistry;
        this.mtRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    protected void unsetModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.mtRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.mtRegistry = null;
    }

    @Reference
    protected void setRuleRegistry(RuleRegistry ruleRegistry) {
        if (ruleRegistry instanceof RuleRegistryImpl) {
            this.ruleRegistry = (RuleRegistryImpl)ruleRegistry;
            this.scheduleReinitializationDelay = this.ruleRegistry.getScheduleReinitializationDelay();
            this.listener = new RegistryChangeListener<Rule>(){

                public void added(Rule rule) {
                    RuleEngineImpl.this.addRule(rule);
                }

                public void removed(Rule rule) {
                    RuleEngineImpl.this.removeRule(rule.getUID());
                }

                public void updated(Rule oldRule, Rule rule) {
                    this.removed(oldRule);
                    this.added(rule);
                }
            };
            ruleRegistry.addRegistryChangeListener(this.listener);
            for (Rule rule : ruleRegistry.getAll()) {
                this.addRule(rule);
            }
        } else {
            this.logger.error("Unexpected RuleRegistry service: {}", (Object)ruleRegistry);
        }
    }

    protected void unsetRuleRegistry(RuleRegistry ruleRegistry) {
        if (this.ruleRegistry == ruleRegistry) {
            ruleRegistry.removeRegistryChangeListener(this.listener);
            this.listener = null;
            this.ruleRegistry = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setStorageService(StorageService storageService) {
        this.disabledRulesStorage = storageService.getStorage(DISABLED_RULE_STORAGE, this.getClass().getClassLoader());
    }

    protected void unsetStorageService(StorageService storageService) {
        this.disabledRulesStorage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(ModuleType moduleType) {
        String moduleTypeName = moduleType.getUID();
        for (ModuleHandlerFactory moduleHandlerFactory : this.allModuleHandlerFactories) {
            Collection moduleTypes = moduleHandlerFactory.getTypes();
            if (!moduleTypes.contains(moduleTypeName)) continue;
            RuleEngineImpl ruleEngineImpl = this;
            synchronized (ruleEngineImpl) {
                this.moduleHandlerFactories.put(moduleTypeName, moduleHandlerFactory);
                break;
            }
        }
        HashSet<String> rules = null;
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
            if (rulesPerModule != null) {
                rules = new HashSet<String>();
                rules.addAll(rulesPerModule);
            }
        }
        if (rules != null) {
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.UNINITIALIZED) continue;
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    public void removed(ModuleType moduleType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(ModuleType oldElement, ModuleType moduleType) {
        if (moduleType.equals((Object)oldElement)) {
            return;
        }
        String moduleTypeName = moduleType.getUID();
        HashSet<String> rules = null;
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
            if (rulesPerModule != null) {
                rules = new HashSet<String>();
                rules.addAll(rulesPerModule);
            }
        }
        if (rules != null) {
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus == null || !ruleStatus.equals((Object)RuleStatus.IDLE) && !ruleStatus.equals((Object)RuleStatus.RUNNING)) continue;
                this.unregister(this.getManagedRule(rUID), RuleStatusDetail.HANDLER_MISSING_ERROR, "Update Module Type " + moduleType.getUID());
                this.setStatus(rUID, new RuleStatusInfo(RuleStatus.INITIALIZING));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        this.logger.debug("ModuleHandlerFactory added.");
        this.allModuleHandlerFactories.add(moduleHandlerFactory);
        Collection moduleTypes = moduleHandlerFactory.getTypes();
        Set notInitializedRules = null;
        for (String moduleTypeName : moduleTypes) {
            HashSet<String> rules = null;
            RuleEngineImpl ruleEngineImpl = this;
            synchronized (ruleEngineImpl) {
                this.moduleHandlerFactories.put(moduleTypeName, moduleHandlerFactory);
                Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
                if (rulesPerModule != null) {
                    rules = new HashSet<String>();
                    rules.addAll(rulesPerModule);
                }
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.UNINITIALIZED) continue;
                notInitializedRules = notInitializedRules != null ? notInitializedRules : new HashSet(20);
                notInitializedRules.add(rUID);
            }
        }
        if (notInitializedRules != null) {
            for (String rUID : notInitializedRules) {
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    protected void removeModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        if (moduleHandlerFactory instanceof CompositeModuleHandlerFactory) {
            this.compositeFactory.deactivate();
            this.compositeFactory = null;
        }
        this.allModuleHandlerFactories.remove(moduleHandlerFactory);
        Collection moduleTypes = moduleHandlerFactory.getTypes();
        this.removeMissingModuleTypes(moduleTypes);
        for (String moduleTypeName : moduleTypes) {
            this.moduleHandlerFactories.remove(moduleTypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRule(Rule newRule) {
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            if (this.isDisposed) {
                throw new IllegalStateException("RuleEngineImpl is disposed!");
            }
        }
        String rUID = newRule.getUID();
        WrappedRule rule = new WrappedRule(newRule);
        this.managedRules.put(rUID, rule);
        RuleStatusInfo initStatusInfo = this.disabledRulesStorage == null || this.disabledRulesStorage.get(rUID) == null ? new RuleStatusInfo(RuleStatus.INITIALIZING) : new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.DISABLED);
        rule.setStatusInfo(initStatusInfo);
        WrappedRule oldRule = this.getManagedRule(rUID);
        if (oldRule != null) {
            this.unregister(oldRule);
        }
        if (this.isEnabled(rUID).booleanValue()) {
            this.setRule(rule);
        }
    }

    private void setRule(WrappedRule rule) {
        if (this.isDisposed) {
            return;
        }
        String rUID = rule.getUID();
        this.setStatus(rUID, new RuleStatusInfo(RuleStatus.INITIALIZING));
        try {
            for (WrappedAction action : rule.getActions()) {
                this.updateMapModuleTypeToRule(rUID, ((Action)action.unwrap()).getTypeUID());
                action.setConnections(ConnectionValidator.getConnections(action.getInputs()));
            }
            for (WrappedCondition condition : rule.getConditions()) {
                this.updateMapModuleTypeToRule(rUID, ((Condition)condition.unwrap()).getTypeUID());
                condition.setConnections(ConnectionValidator.getConnections(condition.getInputs()));
            }
            for (WrappedTrigger trigger : rule.getTriggers()) {
                this.updateMapModuleTypeToRule(rUID, ((Trigger)trigger.unwrap()).getTypeUID());
            }
            this.validateModuleIDs(rule);
            this.autoMapConnections(rule);
            ConnectionValidator.validateConnections(this.mtRegistry, rule.unwrap());
        }
        catch (IllegalArgumentException e) {
            this.setStatus(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.INVALID_RULE, "Validation of rule " + rUID + " has failed! " + e.getLocalizedMessage()));
            return;
        }
        String errMsgs = this.setModuleHandlers(rUID, rule.getModules());
        if (errMsgs == null) {
            this.register(rule);
            this.setStatus(rUID, new RuleStatusInfo(RuleStatus.IDLE));
            Future<?> f = this.scheduleTasks.remove(rUID);
            if (f != null && !f.isDone()) {
                f.cancel(true);
            }
            if (this.scheduleTasks.isEmpty() && this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
            }
        } else {
            this.setStatus(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.HANDLER_INITIALIZING_ERROR, errMsgs));
            this.unregister(rule);
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void postRuleStatusInfoEvent(String ruleUID, RuleStatusInfo statusInfo) {
        if (this.eventPublisher != null) {
            EventPublisher ep = this.eventPublisher;
            RuleStatusInfoEvent event = RuleEventFactory.createRuleStatusInfoEvent(statusInfo, ruleUID, SOURCE);
            try {
                ep.post((Event)event);
            }
            catch (Exception ex) {
                this.logger.error("Could not post event of type '{}'.", (Object)event.getType(), (Object)ex);
            }
        }
    }

    private <T extends WrappedModule<?, ?>> @Nullable String setModuleHandlers(String rUID, List<T> modules) {
        StringBuilder sb = null;
        for (WrappedModule mm : modules) {
            String message;
            Object m = mm.unwrap();
            try {
                ModuleHandler moduleHandler = this.getModuleHandler((Module)m, rUID);
                if (moduleHandler != null) {
                    if (mm instanceof WrappedAction) {
                        ((WrappedAction)mm).setModuleHandler((ActionHandler)moduleHandler);
                        continue;
                    }
                    if (mm instanceof WrappedCondition) {
                        ((WrappedCondition)mm).setModuleHandler((ConditionHandler)moduleHandler);
                        continue;
                    }
                    if (!(mm instanceof WrappedTrigger)) continue;
                    ((WrappedTrigger)mm).setModuleHandler((TriggerHandler)moduleHandler);
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder();
                }
                message = "Missing handler '" + m.getTypeUID() + "' for module '" + m.getId() + "'";
                sb.append(message).append("\n");
                this.logger.trace(message);
            }
            catch (Throwable t) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                message = "Getting handler '" + m.getTypeUID() + "' for module '" + m.getId() + "' failed: " + t.getMessage();
                sb.append(message).append("\n");
                this.logger.trace(message);
            }
        }
        return sb != null ? sb.toString() : null;
    }

    private synchronized TriggerHandlerCallbackImpl getTriggerHandlerCallback(String ruleUID) {
        TriggerHandlerCallbackImpl result = this.thCallbacks.get(ruleUID);
        if (result == null) {
            result = new TriggerHandlerCallbackImpl(this, ruleUID);
            this.thCallbacks.put(ruleUID, result);
        }
        return result;
    }

    private <T extends WrappedModule<?, ?>> void removeModuleHandlers(List<T> modules, String ruleUID) {
        for (WrappedModule mm : modules) {
            Object m = mm.unwrap();
            Object handler = mm.getModuleHandler();
            if (handler == null) continue;
            ModuleHandlerFactory factory = this.getModuleHandlerFactory(m.getTypeUID());
            if (factory != null) {
                factory.ungetHandler(m, ruleUID, handler);
            }
            mm.setModuleHandler(null);
        }
    }

    private void register(WrappedRule rule) {
        String ruleUID = rule.getUID();
        TriggerHandlerCallbackImpl thCallback = this.getTriggerHandlerCallback(ruleUID);
        rule.getTriggers().forEach(trigger -> {
            TriggerHandler triggerHandler = (TriggerHandler)trigger.getModuleHandler();
            if (triggerHandler != null) {
                triggerHandler.setCallback((ModuleHandlerCallback)thCallback);
            }
        });
        rule.getConditions().forEach(condition -> {
            ConditionHandler conditionHandler = (ConditionHandler)condition.getModuleHandler();
            if (conditionHandler != null) {
                conditionHandler.setCallback(this.moduleHandlerCallback);
            }
        });
        rule.getActions().forEach(action -> {
            ActionHandler actionHandler = (ActionHandler)action.getModuleHandler();
            if (actionHandler != null) {
                actionHandler.setCallback(this.moduleHandlerCallback);
            }
        });
    }

    private void unregister(@Nullable WrappedRule r, @Nullable RuleStatusDetail detail, @Nullable String msg) {
        if (r != null) {
            this.unregister(r);
            this.setStatus(r.getUID(), new RuleStatusInfo(RuleStatus.UNINITIALIZED, detail, msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(WrappedRule r) {
        String rUID = r.getUID();
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            TriggerHandlerCallbackImpl callback = this.thCallbacks.remove(rUID);
            if (callback != null) {
                callback.dispose();
            }
        }
        this.removeModuleHandlers(r.getModules(), rUID);
    }

    private @Nullable ModuleHandler getModuleHandler(Module m, String ruleUID) {
        String moduleTypeId = m.getTypeUID();
        ModuleHandlerFactory mhf = this.getModuleHandlerFactory(moduleTypeId);
        if (mhf == null || this.mtRegistry.get((Object)moduleTypeId) == null) {
            return null;
        }
        return mhf.getHandler(m, ruleUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ModuleHandlerFactory getModuleHandlerFactory(String moduleTypeId) {
        ModuleType mt;
        ModuleHandlerFactory mhf = null;
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            mhf = this.moduleHandlerFactories.get(moduleTypeId);
        }
        if (mhf == null && ((mt = (ModuleType)this.mtRegistry.get((Object)moduleTypeId)) instanceof CompositeTriggerType || mt instanceof CompositeConditionType || mt instanceof CompositeActionType)) {
            mhf = this.compositeFactory;
        }
        return mhf;
    }

    public synchronized void updateMapModuleTypeToRule(String rUID, String moduleTypeId) {
        Set<String> rules = this.mapModuleTypeToRules.get(moduleTypeId);
        if (rules == null) {
            rules = new HashSet<String>(11);
        }
        rules.add(rUID);
        this.mapModuleTypeToRules.put(moduleTypeId, rules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeRule(String rUID) {
        WrappedRule r = this.managedRules.remove(rUID);
        if (r != null) {
            this.unregister(r);
            RuleEngineImpl ruleEngineImpl = this;
            synchronized (ruleEngineImpl) {
                Iterator<Map.Entry<String, Set<String>>> it = this.mapModuleTypeToRules.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Set<String>> e = it.next();
                    Set<String> rules = e.getValue();
                    if (rules == null || !rules.contains(rUID)) continue;
                    rules.remove(rUID);
                    if (rules.size() >= 1) continue;
                    it.remove();
                }
            }
            this.scheduleTasks.remove(rUID);
            return true;
        }
        return false;
    }

    private @Nullable WrappedRule getManagedRule(String rUID) {
        return this.managedRules.get(rUID);
    }

    protected @Nullable Rule getRule(String rUID) {
        WrappedRule managedRule = this.getManagedRule(rUID);
        return managedRule != null ? managedRule.unwrap() : null;
    }

    public synchronized void setEnabled(String uid, boolean enable) {
        WrappedRule rule = this.managedRules.get(uid);
        if (rule == null) {
            throw new IllegalArgumentException(String.format("No rule with id=%s was found!", uid));
        }
        if (enable) {
            if (this.disabledRulesStorage != null) {
                this.disabledRulesStorage.remove(uid);
            }
            if (this.getStatus(rule.getUID()) == RuleStatus.UNINITIALIZED) {
                this.register(rule);
                this.setStatus(rule.getUID(), new RuleStatusInfo(RuleStatus.IDLE));
            }
        } else {
            if (this.disabledRulesStorage != null) {
                this.disabledRulesStorage.put(uid, (Object)true);
            }
            this.unregister(rule, RuleStatusDetail.DISABLED, null);
        }
    }

    public @Nullable RuleStatusInfo getStatusInfo(String ruleUID) {
        if (ruleUID == null) {
            return null;
        }
        WrappedRule rule = this.managedRules.get(ruleUID);
        if (rule == null) {
            return null;
        }
        return rule.getStatusInfo();
    }

    public @Nullable RuleStatus getStatus(String ruleUID) {
        RuleStatusInfo statusInfo = this.getStatusInfo(ruleUID);
        return statusInfo == null ? null : statusInfo.getStatus();
    }

    public @Nullable Boolean isEnabled(String ruleUID) {
        return this.getStatus(ruleUID) == null ? null : Boolean.valueOf(!this.getStatusInfo(ruleUID).getStatusDetail().equals((Object)RuleStatusDetail.DISABLED));
    }

    private void setStatus(String ruleUID, RuleStatusInfo newStatusInfo) {
        WrappedRule rule = this.managedRules.get(ruleUID);
        if (rule == null) {
            return;
        }
        rule.setStatusInfo(newStatusInfo);
        this.postRuleStatusInfoEvent(ruleUID, newStatusInfo);
    }

    protected void scheduleRuleInitialization(final String rUID) {
        Future<?> f = this.scheduleTasks.get(rUID);
        if (f == null || f.isDone()) {
            ScheduledExecutorService ex = this.getScheduledExecutor();
            f = ex.schedule(new Runnable(){

                @Override
                public void run() {
                    WrappedRule managedRule = RuleEngineImpl.this.getManagedRule(rUID);
                    if (managedRule == null) {
                        return;
                    }
                    RuleEngineImpl.this.setRule(managedRule);
                }
            }, this.scheduleReinitializationDelay, TimeUnit.MILLISECONDS);
            this.scheduleTasks.put(rUID, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMissingModuleTypes(Collection<String> moduleTypes) {
        Map mapMissingHandlers = null;
        for (String moduleTypeName : moduleTypes) {
            Set<String> rules = null;
            RuleEngineImpl ruleEngineImpl = this;
            synchronized (ruleEngineImpl) {
                rules = this.mapModuleTypeToRules.get(moduleTypeName);
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus == null) continue;
                switch (ruleStatus) {
                    case IDLE: 
                    case RUNNING: {
                        mapMissingHandlers = mapMissingHandlers != null ? mapMissingHandlers : new HashMap(20);
                        ArrayList<String> list = (ArrayList<String>)mapMissingHandlers.get(rUID);
                        if (list == null) {
                            list = new ArrayList<String>(5);
                        }
                        list.add(moduleTypeName);
                        mapMissingHandlers.put(rUID, list);
                        break;
                    }
                }
            }
        }
        if (mapMissingHandlers != null) {
            for (Map.Entry e : mapMissingHandlers.entrySet()) {
                String rUID = (String)e.getKey();
                List missingTypes = (List)e.getValue();
                StringBuffer sb = new StringBuffer();
                sb.append("Missing handlers: ");
                for (String typeUID : missingTypes) {
                    sb.append(typeUID).append(", ");
                }
                this.unregister(this.getManagedRule(rUID), RuleStatusDetail.HANDLER_MISSING_ERROR, sb.substring(0, sb.length() - 2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRule(String ruleUID, TriggerHandlerCallbackImpl.TriggerData td) {
        if (this.thCallbacks.get(ruleUID) == null) {
            return;
        }
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            RuleStatus ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != RuleStatus.IDLE) {
                this.logger.error("Failed to execute rule \u2018{}' with status '{}'", (Object)ruleUID, (Object)ruleStatus.name());
                return;
            }
            this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.RUNNING));
        }
        try {
            this.clearContext(ruleUID);
            this.setTriggerOutputs(ruleUID, td);
            WrappedRule rule = this.managedRules.get(ruleUID);
            boolean isSatisfied = this.calculateConditions(rule);
            if (isSatisfied) {
                this.executeActions(rule, true);
                this.logger.debug("The rule '{}' is executed.", (Object)ruleUID);
            } else {
                this.logger.debug("The rule '{}' is NOT executed, since it has unsatisfied conditions.", (Object)ruleUID);
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to execute rule '{}': {}", (Object)ruleUID, (Object)t.getMessage());
            this.logger.debug("", t);
        }
        ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            if (this.getRuleStatus(ruleUID) == RuleStatus.RUNNING) {
                this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.IDLE));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow(String ruleUID, boolean considerConditions, @Nullable Map<String, Object> context) {
        WrappedRule rule = this.getManagedRule(ruleUID);
        if (rule == null) {
            this.logger.warn("Failed to execute rule '{}': Invalid Rule UID", (Object)ruleUID);
            return;
        }
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            RuleStatus ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != RuleStatus.IDLE) {
                this.logger.error("Failed to execute rule \u2018{}' with status '{}'", (Object)ruleUID, (Object)ruleStatus.name());
                return;
            }
            this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.RUNNING));
        }
        try {
            this.clearContext(ruleUID);
            if (context != null && !context.isEmpty()) {
                this.getContext(ruleUID, null).putAll(context);
            }
            if (considerConditions) {
                if (this.calculateConditions(rule)) {
                    this.executeActions(rule, false);
                }
            } else {
                this.executeActions(rule, false);
            }
            this.logger.debug("The rule '{}' is executed.", (Object)ruleUID);
        }
        catch (Throwable t) {
            this.logger.error("Failed to execute rule '{}': ", (Object)ruleUID, (Object)t);
        }
        ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            if (this.getRuleStatus(ruleUID) == RuleStatus.RUNNING) {
                this.setStatus(ruleUID, new RuleStatusInfo(RuleStatus.IDLE));
            }
        }
    }

    public void runNow(String ruleUID) {
        this.runNow(ruleUID, false, null);
    }

    protected void clearContext(String ruleUID) {
        Map<String, Object> context = this.contextMap.get(ruleUID);
        if (context != null) {
            context.clear();
        }
    }

    private void setTriggerOutputs(String ruleUID, TriggerHandlerCallbackImpl.TriggerData td) {
        Trigger t = td.getTrigger();
        this.updateContext(ruleUID, t.getId(), td.getOutputs());
    }

    private void updateContext(String ruleUID, String moduleUID, Map<String, ?> outputs) {
        Map<String, Object> context = this.getContext(ruleUID, null);
        if (outputs != null) {
            for (Map.Entry<String, ?> entry : outputs.entrySet()) {
                String key = String.valueOf(moduleUID) + '.' + entry.getKey();
                context.put(key, entry.getValue());
            }
        }
    }

    private Map<String, Object> getContext(String ruleUID, @Nullable Set<Connection> connections) {
        Map<String, Object> context = this.contextMap.get(ruleUID);
        if (context == null) {
            context = new HashMap<String, Object>();
            this.contextMap.put(ruleUID, context);
        }
        if (connections != null) {
            StringBuffer sb = new StringBuffer();
            for (Connection c : connections) {
                String outputModuleId = c.getOutputModuleId();
                if (outputModuleId != null) {
                    sb.append(outputModuleId).append('.').append(c.getOutputName());
                    Object outputValue = context.get(sb.toString());
                    sb.setLength(0);
                    if (outputValue == null) continue;
                    if (c.getReference() == null) {
                        context.put(c.getInputName(), outputValue);
                        continue;
                    }
                    context.put(c.getInputName(), ReferenceResolver.resolveComplexDataReference(outputValue, ReferenceResolver.splitReferenceToTokens(c.getReference())));
                    continue;
                }
                String ref = c.getReference();
                Object value = ReferenceResolver.resolveReference(ref, context);
                if (value == null) continue;
                context.put(c.getInputName(), value);
            }
        }
        return context;
    }

    private boolean calculateConditions(WrappedRule rule) {
        List<WrappedCondition> conditions = rule.getConditions();
        if (conditions.size() == 0) {
            return true;
        }
        String ruleUID = rule.getUID();
        RuleStatus ruleStatus = null;
        Iterator<WrappedCondition> it = conditions.iterator();
        while (it.hasNext()) {
            ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != RuleStatus.RUNNING) {
                return false;
            }
            WrappedCondition managedCondition = it.next();
            Condition condition = (Condition)managedCondition.unwrap();
            ConditionHandler tHandler = (ConditionHandler)managedCondition.getModuleHandler();
            Map<String, Object> context = this.getContext(ruleUID, managedCondition.getConnections());
            if (tHandler == null || tHandler.isSatisfied(Collections.unmodifiableMap(context))) continue;
            this.logger.debug("The condition '{}' of rule '{}' is unsatisfied.", new Object[]{condition.getId(), ruleUID});
            return false;
        }
        return true;
    }

    private void executeActions(WrappedRule rule, boolean stopOnFirstFail) {
        String ruleUID = rule.getUID();
        List<WrappedAction> actions = rule.getActions();
        if (actions.size() == 0) {
            return;
        }
        RuleStatus ruleStatus = null;
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != RuleStatus.RUNNING) {
                return;
            }
            WrappedAction managedAction = (WrappedAction)it.next();
            Action action = (Action)managedAction.unwrap();
            ActionHandler aHandler = (ActionHandler)managedAction.getModuleHandler();
            if (aHandler == null) continue;
            Map<String, Object> context = this.getContext(ruleUID, managedAction.getConnections());
            try {
                Map outputs = aHandler.execute(Collections.unmodifiableMap(context));
                if (outputs == null) continue;
                context = this.getContext(ruleUID, null);
                this.updateContext(ruleUID, action.getId(), outputs);
            }
            catch (Throwable t) {
                String errMessage = "Fail to execute action: " + action.getId();
                if (stopOnFirstFail) {
                    RuntimeException re = new RuntimeException(errMessage, t);
                    throw re;
                }
                this.logger.warn(errMessage, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        RuleEngineImpl ruleEngineImpl = this;
        synchronized (ruleEngineImpl) {
            if (this.isDisposed) {
                return;
            }
            this.isDisposed = true;
        }
        if (this.compositeFactory != null) {
            this.compositeFactory.deactivate();
            this.compositeFactory = null;
        }
        for (Future<?> f : this.scheduleTasks.values()) {
            f.cancel(true);
        }
        if (this.scheduleTasks.isEmpty() && this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.scheduleTasks.clear();
        this.contextMap.clear();
        this.unsetRuleRegistry(this.ruleRegistry);
    }

    protected @Nullable RuleStatus getRuleStatus(String rUID) {
        RuleStatusInfo info = this.getStatusInfo(rUID);
        if (info != null) {
            return info.getStatus();
        }
        return null;
    }

    private ScheduledExecutorService getScheduledExecutor() {
        ScheduledExecutorService newExecutor;
        ScheduledExecutorService currentExecutor = this.executor;
        if (currentExecutor != null && !currentExecutor.isShutdown()) {
            return currentExecutor;
        }
        this.executor = newExecutor = Executors.newSingleThreadScheduledExecutor();
        return newExecutor;
    }

    private void validateModuleIDs(WrappedRule rule) {
        for (WrappedModule<Module, ModuleHandler> mm : rule.getModules()) {
            Module m = mm.unwrap();
            String mId = m.getId();
            if (mId.matches("[A-Za-z0-9_-]*")) continue;
            rule.setStatusInfo(new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.INVALID_RULE, "It is null or not fit to the pattern: [A-Za-z0-9_-]*"));
            throw new IllegalArgumentException("Invalid module uid: " + mId + ". It is null or not fit to the pattern: [A-Za-z0-9_-]*");
        }
    }

    private void autoMapConnections(WrappedRule rule) {
        Map<String, String> connectionMap;
        Set<Connection> connections;
        Action a;
        HashMap<Set<String>, OutputRef> triggerOutputTags = new HashMap<Set<String>, OutputRef>(11);
        for (WrappedTrigger mt : rule.getTriggers()) {
            Trigger t = (Trigger)mt.unwrap();
            TriggerType tt = (TriggerType)this.mtRegistry.get((Object)t.getTypeUID());
            if (tt == null) continue;
            this.initTagsMap(t.getId(), tt.getOutputs(), triggerOutputTags);
        }
        HashMap<Set<String>, OutputRef> actionOutputTags = new HashMap<Set<String>, OutputRef>(11);
        for (WrappedAction ma : rule.getActions()) {
            a = (Action)ma.unwrap();
            ActionType at = (ActionType)this.mtRegistry.get((Object)a.getTypeUID());
            if (at == null) continue;
            this.initTagsMap(a.getId(), at.getOutputs(), actionOutputTags);
        }
        if (!triggerOutputTags.isEmpty()) {
            for (WrappedCondition mc : rule.getConditions()) {
                Condition c = (Condition)mc.unwrap();
                boolean isConnectionChanged = false;
                ConditionType ct = (ConditionType)this.mtRegistry.get((Object)c.getTypeUID());
                if (ct == null) continue;
                connections = this.copyConnections(mc.getConnections());
                for (Input input : ct.getInputs()) {
                    if (this.isConnected(input, connections) || !this.addAutoMapConnections(input, triggerOutputTags, connections)) continue;
                    isConnectionChanged = true;
                }
                if (!isConnectionChanged) continue;
                connectionMap = this.getConnectionMap(connections);
                mc.setInputs(connectionMap);
                mc.setConnections(connections);
            }
        }
        if (!triggerOutputTags.isEmpty() || !actionOutputTags.isEmpty()) {
            for (WrappedAction ma : rule.getActions()) {
                a = (Action)ma.unwrap();
                boolean isConnectionChanged = false;
                ActionType at = (ActionType)this.mtRegistry.get((Object)a.getTypeUID());
                if (at == null) continue;
                connections = this.copyConnections(ma.getConnections());
                for (Input input : at.getInputs()) {
                    if (this.isConnected(input, connections)) continue;
                    if (this.addAutoMapConnections(input, triggerOutputTags, connections)) {
                        isConnectionChanged = true;
                    }
                    if (!this.addAutoMapConnections(input, actionOutputTags, connections)) continue;
                    isConnectionChanged = true;
                }
                if (!isConnectionChanged) continue;
                connectionMap = this.getConnectionMap(connections);
                ma.setInputs(connectionMap);
                ma.setConnections(connections);
            }
        }
    }

    private boolean addAutoMapConnections(Input input, Map<Set<String>, OutputRef> outputTagMap, Set<Connection> currentConnections) {
        boolean result = false;
        Set inputTags = input.getTags();
        OutputRef outputRef = null;
        boolean conflict = false;
        if (inputTags.size() > 0) {
            for (Set<String> outTags : outputTagMap.keySet()) {
                if (!outTags.containsAll(inputTags)) continue;
                if (outputRef == null) {
                    outputRef = outputTagMap.get(outTags);
                    continue;
                }
                conflict = true;
                break;
            }
            if (!conflict && outputRef != null) {
                currentConnections.add(new Connection(input.getName(), outputRef.getModuleId(), outputRef.getOutputName(), null));
                result = true;
            }
        }
        return result;
    }

    private void initTagsMap(String moduleId, List<Output> outputs, Map<Set<String>, OutputRef> tagMap) {
        for (Output output : outputs) {
            Set tags = output.getTags();
            if (tags.size() <= 0) continue;
            if (tagMap.get(tags) != null) {
                tagMap.remove(tags);
                continue;
            }
            tagMap.put(tags, new OutputRef(moduleId, output.getName()));
        }
    }

    private boolean isConnected(Input input, Set<Connection> connections) {
        for (Connection connection : connections) {
            if (!connection.getInputName().equals(input.getName())) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> getConnectionMap(Set<Connection> connections) {
        HashMap<String, String> connectionMap = new HashMap<String, String>();
        for (Connection connection : connections) {
            connectionMap.put(connection.getInputName(), String.valueOf(connection.getOutputModuleId()) + "." + connection.getOutputName());
        }
        return connectionMap;
    }

    private Set<Connection> copyConnections(Set<Connection> connections) {
        HashSet<Connection> result = new HashSet<Connection>(connections.size());
        for (Connection c : connections) {
            result.add(new Connection(c.getInputName(), c.getOutputModuleId(), c.getOutputName(), c.getReference()));
        }
        return result;
    }

    class OutputRef {
        private final String moduleId;
        private final String outputName;

        public OutputRef(String moduleId, String outputName) {
            this.moduleId = moduleId;
            this.outputName = outputName;
        }

        public String getModuleId() {
            return this.moduleId;
        }

        public String getOutputName() {
            return this.outputName;
        }
    }
}

