/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleProvider;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.core.ManagedRuleProvider;
import org.eclipse.smarthome.automation.core.internal.RuleEventFactory;
import org.eclipse.smarthome.automation.core.internal.RuleImpl;
import org.eclipse.smarthome.automation.core.internal.template.RuleTemplateRegistry;
import org.eclipse.smarthome.automation.core.util.ConfigurationNormalizer;
import org.eclipse.smarthome.automation.core.util.ReferenceResolver;
import org.eclipse.smarthome.automation.core.util.RuleBuilder;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RuleRegistry.class}, immediate=true, property={"rule.reinitialization.delay:Long=500"})
public class RuleRegistryImpl
extends AbstractRegistry<Rule, String, RuleProvider>
implements RuleRegistry,
RegistryChangeListener<RuleTemplate> {
    private static final long DEFAULT_REINITIALIZATION_DELAY = 500L;
    private static final String CONFIG_PROPERTY_REINITIALIZATION_DELAY = "rule.reinitialization.delay";
    private static final String SOURCE = RuleRegistryImpl.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger((String)RuleRegistryImpl.class.getName());
    private long scheduleReinitializationDelay;
    private ModuleTypeRegistry moduleTypeRegistry;
    private RuleTemplateRegistry templateRegistry;
    private final Map<String, Set<String>> mapTemplateToRules = new HashMap<String, Set<String>>();

    public RuleRegistryImpl() {
        super(RuleProvider.class);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        this.modified(properties);
        super.activate(bundleContext);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        Object value = config == null ? null : config.get(CONFIG_PROPERTY_REINITIALIZATION_DELAY);
        long l = this.scheduleReinitializationDelay = value != null && value instanceof Number ? ((Number)value).longValue() : 500L;
        if (value != null && !(value instanceof Number)) {
            this.logger.warn("Invalid configuration value: {}. It MUST be Number.", value);
        }
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, name="ManagedRuleProvider")
    protected void setManagedProvider(ManagedRuleProvider managedProvider) {
        super.setManagedProvider((ManagedProvider)managedProvider);
    }

    protected void unsetManagedProvider(ManagedRuleProvider managedProvider) {
        super.unsetManagedProvider((ManagedProvider)managedProvider);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void setModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = moduleTypeRegistry;
    }

    protected void unsetModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    protected void setTemplateRegistry(TemplateRegistry<RuleTemplate> templateRegistry) {
        if (templateRegistry instanceof RuleTemplateRegistry) {
            this.templateRegistry = (RuleTemplateRegistry)templateRegistry;
            templateRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        }
    }

    protected void unsetTemplateRegistry(TemplateRegistry<RuleTemplate> templateRegistry) {
        if (templateRegistry instanceof RuleTemplateRegistry) {
            this.templateRegistry = null;
            templateRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        }
    }

    public Rule add(Rule rule) {
        super.add((Identifiable)rule);
        Rule ruleCopy = (Rule)this.get(rule.getUID());
        if (ruleCopy == null) {
            throw new IllegalStateException();
        }
        return ruleCopy;
    }

    protected void notifyListenersAboutAddedElement(Rule element) {
        this.postRuleAddedEvent(element);
        this.postRuleStatusInfoEvent(element.getUID(), new RuleStatusInfo(RuleStatus.UNINITIALIZED));
        super.notifyListenersAboutAddedElement((Identifiable)element);
    }

    protected void notifyListenersAboutUpdatedElement(Rule oldElement, Rule element) {
        this.postRuleUpdatedEvent(element, oldElement);
        super.notifyListenersAboutUpdatedElement((Identifiable)oldElement, (Identifiable)element);
    }

    protected void postRuleAddedEvent(Rule rule) {
        this.postEvent((Event)RuleEventFactory.createRuleAddedEvent(rule, SOURCE));
    }

    protected void postRuleRemovedEvent(Rule rule) {
        this.postEvent((Event)RuleEventFactory.createRuleRemovedEvent(rule, SOURCE));
    }

    protected void postRuleUpdatedEvent(Rule rule, Rule oldRule) {
        this.postEvent((Event)RuleEventFactory.createRuleUpdatedEvent(rule, oldRule, SOURCE));
    }

    protected void postRuleStatusInfoEvent(String ruleUID, RuleStatusInfo statusInfo) {
        this.postEvent((Event)RuleEventFactory.createRuleStatusInfoEvent(statusInfo, ruleUID, SOURCE));
    }

    protected void onRemoveElement(Rule rule) {
        String uid = rule.getUID();
        String templateUID = rule.getTemplateUID();
        if (templateUID != null) {
            this.updateRuleTemplateMapping(templateUID, uid, true);
        }
    }

    protected void notifyListenersAboutRemovedElement(Rule element) {
        super.notifyListenersAboutRemovedElement((Identifiable)element);
        this.postRuleRemovedEvent(element);
    }

    public Collection<Rule> getByTag(String tag) {
        LinkedList<Rule> result = new LinkedList<Rule>();
        if (tag == null) {
            this.forEach(result::add);
        } else {
            this.forEach(rule -> {
                if (rule.getTags().contains(tag)) {
                    result.add((Rule)rule);
                }
            });
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<Rule> getByTags(String ... tags) {
        HashSet<String> tagSet = tags != null ? new HashSet<String>(Arrays.asList(tags)) : null;
        LinkedList<Rule> result = new LinkedList<Rule>();
        if (tagSet != null && !tagSet.isEmpty()) {
            this.forEach(rule -> {
                if (rule.getTags().containsAll(tagSet)) {
                    result.add((Rule)rule);
                }
            });
            return result;
        }
        this.forEach(result::add);
        return result;
    }

    private Rule resolveRuleByTemplate(Rule rule) {
        String templateUID = rule.getTemplateUID();
        if (templateUID == null) {
            return rule;
        }
        RuleTemplate template = this.templateRegistry.get(templateUID);
        String uid = rule.getUID();
        if (template == null) {
            this.updateRuleTemplateMapping(templateUID, uid, false);
            this.logger.debug("Rule template {} does not exist.", (Object)templateUID);
            return rule;
        }
        RuleImpl resolvedRule = (RuleImpl)RuleBuilder.create(template, rule.getUID(), rule.getName(), rule.getConfiguration(), rule.getVisibility()).build();
        this.resolveConfigurations(resolvedRule);
        this.updateRuleTemplateMapping(templateUID, uid, true);
        return resolvedRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRuleTemplateMapping(String templateUID, String ruleUID, boolean resolved) {
        RuleRegistryImpl ruleRegistryImpl = this;
        synchronized (ruleRegistryImpl) {
            Set<String> ruleUIDs = this.mapTemplateToRules.get(templateUID);
            if (ruleUIDs == null) {
                ruleUIDs = new HashSet<String>();
                this.mapTemplateToRules.put(templateUID, ruleUIDs);
            }
            if (resolved) {
                ruleUIDs.remove(ruleUID);
            } else {
                ruleUIDs.add(ruleUID);
            }
        }
    }

    protected void addProvider(Provider<Rule> provider) {
        super.addProvider(provider);
        this.forEach(provider, rule -> {
            try {
                Rule resolvedRule = this.resolveRuleByTemplate((Rule)rule);
                if (rule != resolvedRule && provider instanceof ManagedRuleProvider) {
                    this.update((Identifiable)resolvedRule);
                }
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Added rule '{}' is invalid", (Object)rule.getUID(), (Object)e);
            }
        });
    }

    public void added(Provider<Rule> provider, Rule element) {
        String ruleUID = element.getUID();
        Rule resolvedRule = element;
        try {
            resolvedRule = this.resolveRuleByTemplate(element);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Added rule '{}' is invalid", (Object)ruleUID, (Object)e);
        }
        super.added(provider, (Identifiable)element);
        if (element != resolvedRule) {
            if (provider instanceof ManagedRuleProvider) {
                this.update((Identifiable)resolvedRule);
            } else {
                super.updated(provider, (Identifiable)element, (Identifiable)resolvedRule);
            }
        }
    }

    public void updated(Provider<Rule> provider, Rule oldElement, Rule element) {
        String uid = element.getUID();
        if (oldElement != null && uid.equals(oldElement.getUID())) {
            Rule resolvedRule = element;
            try {
                resolvedRule = this.resolveRuleByTemplate(element);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("The rule '{}' is not updated, the new version is invalid", (Object)uid, (Object)e);
            }
            if (element != resolvedRule && provider instanceof ManagedRuleProvider) {
                this.update((Identifiable)resolvedRule);
            } else {
                super.updated(provider, (Identifiable)oldElement, (Identifiable)resolvedRule);
            }
        } else {
            throw new IllegalArgumentException(String.format("The rule '%s' is not updated, not matching with any existing rule", uid));
        }
    }

    protected void onAddElement(Rule element) throws IllegalArgumentException {
        String uid = element.getUID();
        try {
            this.resolveConfigurations(element);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Added rule '{}' is invalid", (Object)uid, (Object)e);
        }
    }

    protected void onUpdateElement(Rule oldElement, Rule element) throws IllegalArgumentException {
        String uid = element.getUID();
        try {
            this.resolveConfigurations(element);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("The new version of updated rule '{}' is invalid", (Object)uid, (Object)e);
        }
    }

    private void resolveConfigurations(Rule rule) {
        List configDescriptions = rule.getConfigurationDescriptions();
        Configuration configuration = rule.getConfiguration();
        ConfigurationNormalizer.normalizeConfiguration(configuration, ConfigurationNormalizer.getConfigDescriptionMap(configDescriptions));
        Map configurationProperties = configuration.getProperties();
        if (rule.getTemplateUID() == null) {
            String uid = rule.getUID();
            try {
                this.validateConfiguration(configDescriptions, new HashMap<String, Object>(configurationProperties));
                this.resolveModuleConfigReferences(rule.getModules(), configurationProperties);
                ConfigurationNormalizer.normalizeModuleConfigurations(rule.getModules(), this.moduleTypeRegistry);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("The rule '%s' has incorrect configurations", uid), e);
            }
        }
    }

    private void validateConfiguration(List<ConfigDescriptionParameter> configDescriptions, Map<String, Object> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            if (this.isOptionalConfig(configDescriptions)) {
                return;
            }
            StringBuffer statusDescription = new StringBuffer();
            String msg = " '%s';";
            for (ConfigDescriptionParameter configParameter : configDescriptions) {
                if (!configParameter.isRequired()) continue;
                String name = configParameter.getName();
                statusDescription.append(String.format(msg, name));
            }
            throw new IllegalArgumentException("Missing required configuration properties: " + statusDescription.toString());
        }
        for (ConfigDescriptionParameter configParameter : configDescriptions) {
            String configParameterName = configParameter.getName();
            this.processValue(configurations.remove(configParameterName), configParameter);
        }
        if (!configurations.isEmpty()) {
            StringBuffer statusDescription = new StringBuffer();
            String msg = " '%s';";
            for (String name : configurations.keySet()) {
                statusDescription.append(String.format(msg, name));
            }
            throw new IllegalArgumentException("Extra configuration properties: " + statusDescription.toString());
        }
    }

    private boolean isOptionalConfig(List<ConfigDescriptionParameter> configDescriptions) {
        if (configDescriptions != null && !configDescriptions.isEmpty()) {
            boolean required = false;
            for (ConfigDescriptionParameter param : configDescriptions) {
                boolean bl = required = required || param.isRequired();
            }
            return !required;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processValue(Object configValue, ConfigDescriptionParameter configParameter) {
        if (configValue == null) {
            if (!configParameter.isRequired()) return;
            throw new IllegalArgumentException("Required configuration property missing: \"" + configParameter.getName() + "\"!");
        }
        ConfigDescriptionParameter.Type type = configParameter.getType();
        if (!configParameter.isMultiple().booleanValue()) {
            if (this.checkType(type, configValue)) return;
            throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected is " + type.toString() + "!");
        }
        if (!(configValue instanceof List)) throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected is Array with type for elements : " + type.toString() + "!");
        List lConfigValues = (List)configValue;
        for (Object value : lConfigValues) {
            if (this.checkType(type, value)) continue;
            throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected type: " + type);
        }
    }

    private boolean checkType(ConfigDescriptionParameter.Type type, Object configValue) {
        switch (type) {
            case TEXT: {
                return configValue instanceof String;
            }
            case BOOLEAN: {
                return configValue instanceof Boolean;
            }
            case INTEGER: {
                return configValue instanceof BigDecimal || configValue instanceof Integer || configValue instanceof Double && (double)((Double)configValue).intValue() == (Double)configValue;
            }
            case DECIMAL: {
                return configValue instanceof BigDecimal || configValue instanceof Double;
            }
        }
        return false;
    }

    private void resolveModuleConfigReferences(List<? extends Module> modules, Map<String, ?> ruleConfiguration) {
        if (modules != null) {
            StringBuffer statusDescription = new StringBuffer();
            for (Module module : modules) {
                try {
                    ReferenceResolver.updateConfiguration(module.getConfiguration(), ruleConfiguration, this.logger);
                }
                catch (IllegalArgumentException e) {
                    statusDescription.append(" in module[" + module.getId() + "]: " + e.getLocalizedMessage() + ";");
                }
            }
            String string = statusDescription.toString();
            if (!string.isEmpty()) {
                throw new IllegalArgumentException(String.format("Incorrect configurations: %s", string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(RuleTemplate element) {
        String templateUID = element.getUID();
        HashSet<String> rules = new HashSet<String>();
        RuleRegistryImpl ruleRegistryImpl = this;
        synchronized (ruleRegistryImpl) {
            Set<String> rulesForResolving = this.mapTemplateToRules.get(templateUID);
            if (rulesForResolving != null) {
                rules.addAll(rulesForResolving);
            }
        }
        for (String rUID : rules) {
            try {
                Rule unresolvedRule = (Rule)this.get(rUID);
                Rule resolvedRule = this.resolveRuleByTemplate(unresolvedRule);
                Provider provider = this.getProvider(rUID);
                if (provider instanceof ManagedRuleProvider) {
                    this.update((Identifiable)resolvedRule);
                    continue;
                }
                this.updated((Provider<Rule>)provider, unresolvedRule, unresolvedRule);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Resolving the rule '{}' by template '{}' failed", new Object[]{rUID, templateUID, e});
            }
        }
    }

    public void removed(RuleTemplate element) {
    }

    public void updated(RuleTemplate oldElement, RuleTemplate element) {
    }

    long getScheduleReinitializationDelay() {
        return this.scheduleReinitializationDelay;
    }
}

