/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.RuleTemplateProvider;
import org.eclipse.smarthome.automation.template.TemplateProvider;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.osgi.service.component.annotations.Component;

@Component(service={TemplateRegistry.class, RuleTemplateRegistry.class}, immediate=true)
public class RuleTemplateRegistry
extends AbstractRegistry<RuleTemplate, String, RuleTemplateProvider>
implements TemplateRegistry<RuleTemplate> {
    public RuleTemplateRegistry() {
        super(RuleTemplateProvider.class);
    }

    protected void addProvider(Provider<RuleTemplate> provider) {
        if (provider instanceof TemplateProvider) {
            super.addProvider(provider);
        }
    }

    public RuleTemplate get(String templateUID) {
        return this.get(templateUID, null);
    }

    public RuleTemplate get(String templateUID, Locale locale) {
        Map.Entry prt = this.getValueAndProvider(templateUID);
        if (prt == null) {
            return null;
        }
        RuleTemplate t = locale == null ? (RuleTemplate)prt.getValue() : (RuleTemplate)((RuleTemplateProvider)prt.getKey()).getTemplate(templateUID, locale);
        return this.createCopy(t);
    }

    private RuleTemplate createCopy(RuleTemplate template) {
        return new RuleTemplate(template.getUID(), template.getLabel(), template.getDescription(), new HashSet(template.getTags()), new ArrayList(template.getTriggers()), new ArrayList(template.getConditions()), new ArrayList(template.getActions()), new LinkedList(template.getConfigurationDescriptions()), template.getVisibility());
    }

    public Collection<RuleTemplate> getByTag(String tag) {
        return this.getByTag(tag, null);
    }

    public Collection<RuleTemplate> getByTag(String tag, Locale locale) {
        ArrayList<RuleTemplate> result = new ArrayList<RuleTemplate>();
        this.forEach((provider, resultTemplate) -> {
            RuleTemplate t;
            Set tags = resultTemplate.getTags();
            RuleTemplate ruleTemplate = t = locale == null ? resultTemplate : (RuleTemplate)((RuleTemplateProvider)provider).getTemplate(resultTemplate.getUID(), locale);
            if (tag == null || tags.contains(tag)) {
                result.add(t);
            }
        });
        return result;
    }

    public Collection<RuleTemplate> getByTags(String ... tags) {
        return this.getByTags((Locale)null, tags);
    }

    public Collection<RuleTemplate> getByTags(Locale locale, String ... tags) {
        HashSet<String> tagSet = tags != null ? new HashSet<String>(Arrays.asList(tags)) : null;
        ArrayList<RuleTemplate> result = new ArrayList<RuleTemplate>();
        this.forEach((provider, resultTemplate) -> {
            RuleTemplate t;
            Set tTags = resultTemplate.getTags();
            RuleTemplate ruleTemplate = t = locale == null ? resultTemplate : (RuleTemplate)((RuleTemplateProvider)provider).getTemplate(resultTemplate.getUID(), locale);
            if (tTags.containsAll(tagSet)) {
                result.add(t);
            }
        });
        return result;
    }

    public Collection<RuleTemplate> getAll(Locale locale) {
        return this.getByTag(null, locale);
    }
}

