/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.util;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.util.ActionBuilder;
import org.eclipse.smarthome.automation.core.util.ConditionBuilder;
import org.eclipse.smarthome.automation.core.util.TriggerBuilder;
import org.eclipse.smarthome.config.core.Configuration;

@NonNullByDefault
public abstract class ModuleBuilder<B extends ModuleBuilder<B, T>, T extends Module> {
    private @Nullable String id;
    private @Nullable String typeUID;
    protected @Nullable Configuration configuration;
    protected @Nullable String label;
    protected @Nullable String description;

    public static ActionBuilder createAction() {
        return ActionBuilder.create();
    }

    public static ActionBuilder createAction(Action action) {
        return ActionBuilder.create(action);
    }

    public static ConditionBuilder createCondition() {
        return ConditionBuilder.create();
    }

    public static ConditionBuilder createCondition(Condition condition) {
        return ConditionBuilder.create(condition);
    }

    public static TriggerBuilder createTrigger() {
        return TriggerBuilder.create();
    }

    public static TriggerBuilder createTrigger(Trigger trigger) {
        return TriggerBuilder.create(trigger);
    }

    public static <B extends ModuleBuilder<B, T>, T extends Module> ModuleBuilder<B, T> create(Module module) {
        if (module instanceof Action) {
            return ModuleBuilder.createAction((Action)module);
        }
        if (module instanceof Condition) {
            return ModuleBuilder.createCondition((Condition)module);
        }
        if (module instanceof Trigger) {
            return ModuleBuilder.createTrigger((Trigger)module);
        }
        throw new IllegalArgumentException("Parameter must be an instance of Action, Condition or Trigger.");
    }

    protected ModuleBuilder() {
    }

    protected ModuleBuilder(T module) {
        this.id = module.getId();
        this.typeUID = module.getTypeUID();
        this.configuration = new Configuration(module.getConfiguration());
        this.label = module.getLabel();
        this.description = module.getDescription();
    }

    public B withId(String id) {
        this.id = id;
        return this.myself();
    }

    public B withTypeUID(String typeUID) {
        this.typeUID = typeUID;
        return this.myself();
    }

    public B withConfiguration(Configuration configuration) {
        this.configuration = new Configuration(configuration);
        return this.myself();
    }

    public B withLabel(@Nullable String label) {
        this.label = label;
        return this.myself();
    }

    public B withDescription(@Nullable String description) {
        this.description = description;
        return this.myself();
    }

    private B myself() {
        return (B)this;
    }

    protected String getId() {
        String id = this.id;
        if (id == null) {
            throw new IllegalStateException("The ID must not be null.");
        }
        return id;
    }

    protected String getTypeUID() {
        String typeUID = this.typeUID;
        if (typeUID == null) {
            throw new IllegalStateException("The type UID must not be null.");
        }
        return typeUID;
    }

    public abstract T build();
}

