/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.automation.core.internal.RuleImpl;
import org.eclipse.smarthome.automation.core.util.ActionBuilder;
import org.eclipse.smarthome.automation.core.util.ConditionBuilder;
import org.eclipse.smarthome.automation.core.util.TriggerBuilder;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.Configuration;

@NonNullByDefault
public class RuleBuilder {
    @NonNullByDefault(value={})
    private List<Trigger> triggers;
    @NonNullByDefault(value={})
    private List<Condition> conditions;
    @NonNullByDefault(value={})
    private List<Action> actions;
    @NonNullByDefault(value={})
    private Configuration configuration;
    @NonNullByDefault(value={})
    private List<ConfigDescriptionParameter> configDescriptions;
    private @Nullable String templateUID;
    @NonNullByDefault(value={})
    private final String uid;
    private @Nullable String name;
    @NonNullByDefault(value={})
    private Set<String> tags;
    @NonNullByDefault(value={})
    private Visibility visibility;
    private @Nullable String description;

    protected RuleBuilder(Rule rule) {
        this.triggers = new LinkedList<Trigger>(rule.getTriggers());
        this.conditions = new LinkedList<Condition>(rule.getConditions());
        this.actions = new LinkedList<Action>(rule.getActions());
        this.configuration = new Configuration(rule.getConfiguration());
        this.configDescriptions = new LinkedList<ConfigDescriptionParameter>(rule.getConfigurationDescriptions());
        this.templateUID = rule.getTemplateUID();
        this.uid = rule.getUID();
        this.name = rule.getName();
        this.tags = new HashSet<String>(rule.getTags());
        this.visibility = rule.getVisibility();
        this.description = rule.getDescription();
    }

    public static RuleBuilder create(String ruleId) {
        RuleImpl rule = new RuleImpl(ruleId);
        return new RuleBuilder(rule);
    }

    public static RuleBuilder create(Rule r) {
        return RuleBuilder.create(r.getUID()).withActions(r.getActions()).withConditions(r.getConditions()).withTriggers(r.getTriggers()).withConfiguration(r.getConfiguration()).withConfigurationDescriptions(r.getConfigurationDescriptions()).withDescription(r.getDescription()).withName(r.getName()).withTags(r.getTags());
    }

    public static RuleBuilder create(RuleTemplate template, String uid, @Nullable String name, Configuration configuration, Visibility visibility) {
        return RuleBuilder.create(uid).withActions(template.getActions()).withConditions(template.getConditions()).withTriggers(template.getTriggers()).withConfiguration(configuration).withConfigurationDescriptions(template.getConfigurationDescriptions()).withDescription(template.getDescription()).withName(name).withTags(template.getTags());
    }

    public RuleBuilder withName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public RuleBuilder withDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public RuleBuilder withTemplateUID(@Nullable String uid) {
        this.templateUID = uid;
        return this;
    }

    public RuleBuilder withVisibility(@Nullable Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public RuleBuilder withTriggers(Trigger ... triggers) {
        return this.withTriggers(Arrays.asList(triggers));
    }

    public RuleBuilder withTriggers(@Nullable List<? extends Trigger> triggers) {
        if (triggers != null) {
            ArrayList<Trigger> triggerList = new ArrayList<Trigger>(triggers.size());
            triggers.forEach(t -> {
                boolean bl = triggerList.add(TriggerBuilder.create(t).build());
            });
            this.triggers = triggerList;
        }
        return this;
    }

    public RuleBuilder withConditions(Condition ... conditions) {
        return this.withConditions(Arrays.asList(conditions));
    }

    public RuleBuilder withConditions(@Nullable List<? extends Condition> conditions) {
        if (conditions != null) {
            ArrayList<Condition> conditionList = new ArrayList<Condition>(conditions.size());
            conditions.forEach(c -> {
                boolean bl = conditionList.add(ConditionBuilder.create(c).build());
            });
            this.conditions = conditionList;
        }
        return this;
    }

    public RuleBuilder withActions(Action ... actions) {
        return this.withActions(Arrays.asList(actions));
    }

    public RuleBuilder withActions(@Nullable List<? extends Action> actions) {
        if (actions != null) {
            ArrayList<Action> actionList = new ArrayList<Action>(actions.size());
            actions.forEach(a -> {
                boolean bl = actionList.add(ActionBuilder.create(a).build());
            });
            this.actions = actionList;
        }
        return this;
    }

    public RuleBuilder withTags(String ... tags) {
        this.withTags(new HashSet<String>(Arrays.asList(tags)));
        return this;
    }

    public RuleBuilder withTags(@Nullable Set<String> tags) {
        this.tags = tags != null ? new HashSet<String>(tags) : Collections.emptySet();
        return this;
    }

    public RuleBuilder withConfiguration(@Nullable Configuration ruleConfiguration) {
        this.configuration = new Configuration(ruleConfiguration);
        return this;
    }

    public RuleBuilder withConfigurationDescriptions(@Nullable List<ConfigDescriptionParameter> configDescs) {
        this.configDescriptions = configDescs != null ? new LinkedList<ConfigDescriptionParameter>(configDescs) : Collections.emptyList();
        return this;
    }

    public Rule build() {
        return new RuleImpl(this.uid, this.name, this.description, this.tags, this.triggers, this.conditions, this.actions, this.configDescriptions, this.configuration, this.templateUID, this.visibility);
    }
}

