/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.media.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.media.handler.PlayActionHandler;
import org.eclipse.smarthome.automation.module.media.handler.SayActionHandler;
import org.eclipse.smarthome.core.audio.AudioManager;
import org.eclipse.smarthome.core.voice.VoiceManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModuleHandlerFactory.class})
public class MediaModuleHandlerFactory
extends BaseModuleHandlerFactory {
    private static final Collection<String> TYPES = Collections.unmodifiableList(Arrays.asList("media.SayAction", "media.PlayAction"));
    private VoiceManager voiceManager;
    private AudioManager audioManager;

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    public Collection<String> getTypes() {
        return TYPES;
    }

    protected ModuleHandler internalCreate(Module module, String ruleUID) {
        block10: {
            if (!(module instanceof Action)) break block10;
            switch (module.getTypeUID()) {
                case "media.SayAction": {
                    return new SayActionHandler((Action)module, this.voiceManager);
                }
                case "media.PlayAction": {
                    return new PlayActionHandler((Action)module, this.audioManager);
                }
            }
        }
        return null;
    }

    @Reference
    protected void setAudioManager(AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    protected void unsetAudioManager(AudioManager audioManager) {
        this.audioManager = null;
    }

    @Reference
    protected void setVoiceManager(VoiceManager voiceManager) {
        this.voiceManager = voiceManager;
    }

    protected void unsetVoiceManager(VoiceManager voiceManager) {
        this.voiceManager = null;
    }
}

