/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.script.ScriptEngine;
import org.eclipse.smarthome.automation.module.script.ScriptEngineFactory;
import org.eclipse.smarthome.automation.module.script.ScriptExtensionProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ScriptExtensionManager.class})
public class ScriptExtensionManager {
    private Set<ScriptExtensionProvider> scriptExtensionProviders = new CopyOnWriteArraySet<ScriptExtensionProvider>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addScriptExtensionProvider(ScriptExtensionProvider provider) {
        this.scriptExtensionProviders.add(provider);
    }

    public void removeScriptExtensionProvider(ScriptExtensionProvider provider) {
        this.scriptExtensionProviders.remove(provider);
    }

    public void addExtension(ScriptExtensionProvider provider) {
        this.scriptExtensionProviders.add(provider);
    }

    public void removeExtension(ScriptExtensionProvider provider) {
        this.scriptExtensionProviders.remove(provider);
    }

    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            types.addAll(provider.getTypes());
        }
        return types;
    }

    public List<String> getPresets() {
        ArrayList<String> presets = new ArrayList<String>();
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            presets.addAll(provider.getPresets());
        }
        return presets;
    }

    public Object get(String type, String scriptIdentifier) {
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            if (!provider.getTypes().contains(type)) continue;
            return provider.get(scriptIdentifier, type);
        }
        return null;
    }

    public List<String> getDefaultPresets() {
        ArrayList<String> defaultPresets = new ArrayList<String>();
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            defaultPresets.addAll(provider.getDefaultPresets());
        }
        return defaultPresets;
    }

    public void importDefaultPresets(ScriptEngineFactory engineProvider, ScriptEngine scriptEngine, String scriptIdentifier) {
        for (String preset : this.getDefaultPresets()) {
            this.importPreset(preset, engineProvider, scriptEngine, scriptIdentifier);
        }
    }

    public void importPreset(String preset, ScriptEngineFactory engineProvider, ScriptEngine scriptEngine, String scriptIdentifier) {
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            if (!provider.getPresets().contains(preset)) continue;
            Map<String, Object> scopeValues = provider.importPreset(scriptIdentifier, preset);
            engineProvider.scopeValues(scriptEngine, scopeValues);
        }
    }

    public void dispose(String scriptIdentifier) {
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            provider.unload(scriptIdentifier);
        }
    }
}

