/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.module.core.provider.i18n.ModuleTypeI18nService;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeProvider;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={ModuleTypeProvider.class, Provider.class}, property={"provider.type=bundle"})
public class ModuleTypeResourceBundleProvider
extends AbstractResourceBundleProvider<ModuleType>
implements ModuleTypeProvider {
    private ModuleTypeI18nService moduleTypeI18nService;

    public ModuleTypeResourceBundleProvider() {
        this.listeners = new LinkedList();
        this.path = "ESH-INF/automation/moduletypes/";
    }

    @Override
    @Activate
    protected void activate(BundleContext bc) {
        super.activate(bc);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, target="(parser.type=parser.module.type)")
    protected void addParser(Parser<ModuleType> parser, Map<String, String> properties) {
        super.addParser(parser, properties);
    }

    @Override
    protected void removeParser(Parser<ModuleType> parser, Map<String, String> properties) {
        super.removeParser(parser, properties);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        super.setTranslationProvider(i18nProvider);
    }

    @Override
    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        super.unsetTranslationProvider(i18nProvider);
    }

    public Collection<ModuleType> getAll() {
        return this.providedObjectsHolder.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public <T extends ModuleType> T getModuleType(String UID, Locale locale) {
        return (T)this.getPerLocale((ModuleType)this.providedObjectsHolder.get(UID), locale);
    }

    public Collection<ModuleType> getModuleTypes(Locale locale) {
        ArrayList<ModuleType> moduleTypesList = new ArrayList<ModuleType>();
        for (ModuleType mt : this.providedObjectsHolder.values()) {
            moduleTypesList.add(this.getPerLocale(mt, locale));
        }
        return moduleTypesList;
    }

    @Override
    protected String getUID(ModuleType parsedObject) {
        return parsedObject.getUID();
    }

    private ModuleType getPerLocale(ModuleType defModuleType, Locale locale) {
        String uid = defModuleType.getUID();
        Bundle bundle = this.getBundle(uid);
        return this.moduleTypeI18nService.getModuleTypePerLocale(defModuleType, locale, bundle);
    }

    @Reference
    protected void setModuleTypeI18nService(ModuleTypeI18nService moduleTypeI18nService) {
        this.moduleTypeI18nService = moduleTypeI18nService;
    }

    protected void unsetModuleTypeI18nService(ModuleTypeI18nService moduleTypeI18nService) {
        this.moduleTypeI18nService = null;
    }
}

