/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider.i18n;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ModuleI18nUtil;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ModuleTypeI18nUtil;
import org.eclipse.smarthome.automation.module.core.provider.i18n.ModuleTypeI18nService;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.i18n.ConfigI18nLocalizationService;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ModuleTypeI18nServiceImpl
implements ModuleTypeI18nService {
    private final Logger logger = LoggerFactory.getLogger(ModuleTypeI18nServiceImpl.class);
    private TranslationProvider i18nProvider;
    private ConfigI18nLocalizationService localizationService;

    public ModuleType getModuleTypePerLocale(ModuleType defModuleType, Locale locale, Bundle bundle) {
        if (locale == null || defModuleType == null || this.i18nProvider == null) {
            return defModuleType;
        }
        String uid = defModuleType.getUID();
        String llabel = ModuleTypeI18nUtil.getLocalizedModuleTypeLabel(this.i18nProvider, bundle, uid, defModuleType.getLabel(), locale);
        String ldescription = ModuleTypeI18nUtil.getLocalizedModuleTypeDescription(this.i18nProvider, bundle, uid, defModuleType.getDescription(), locale);
        List<ConfigDescriptionParameter> lconfigDescriptions = this.getLocalizedConfigDescriptionParameters(defModuleType.getConfigurationDescriptions(), "module-type", uid, bundle, locale);
        if (defModuleType instanceof ActionType) {
            return this.createLocalizedActionType((ActionType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        if (defModuleType instanceof ConditionType) {
            return this.createLocalizedConditionType((ConditionType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        if (defModuleType instanceof TriggerType) {
            return this.createLocalizedTriggerType((TriggerType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        return null;
    }

    private List<ConfigDescriptionParameter> getLocalizedConfigDescriptionParameters(List<ConfigDescriptionParameter> parameters, String prefix, String uid, Bundle bundle, Locale locale) {
        URI uri = null;
        try {
            uri = new URI(String.valueOf(prefix) + ":" + uid + ".name");
        }
        catch (URISyntaxException e) {
            this.logger.error("Constructed invalid uri '{}:{}.name'", new Object[]{prefix, uid, e});
        }
        ConfigDescription configDescription = new ConfigDescription(uri, parameters);
        return this.localizationService.getLocalizedConfigDescription(bundle, configDescription, locale).getParameters();
    }

    private ActionType createLocalizedActionType(ActionType at, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Input> inputs = ModuleTypeI18nUtil.getLocalizedInputs(this.i18nProvider, at.getInputs(), bundle, moduleTypeUID, locale);
        List<Output> outputs = ModuleTypeI18nUtil.getLocalizedOutputs(this.i18nProvider, at.getOutputs(), bundle, moduleTypeUID, locale);
        ActionType lat = null;
        if (at instanceof CompositeActionType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeActionType)at).getChildren(), bundle, moduleTypeUID, "module-type", locale);
            lat = new CompositeActionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, at.getTags(), at.getVisibility(), inputs, outputs, modules);
        } else {
            lat = new ActionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, at.getTags(), at.getVisibility(), inputs, outputs);
        }
        return lat;
    }

    private ConditionType createLocalizedConditionType(ConditionType ct, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Input> inputs = ModuleTypeI18nUtil.getLocalizedInputs(this.i18nProvider, ct.getInputs(), bundle, moduleTypeUID, locale);
        ConditionType lct = null;
        if (ct instanceof CompositeConditionType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeConditionType)ct).getChildren(), bundle, moduleTypeUID, "module-type", locale);
            lct = new CompositeConditionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, ct.getTags(), ct.getVisibility(), inputs, modules);
        } else {
            lct = new ConditionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, ct.getTags(), ct.getVisibility(), inputs);
        }
        return lct;
    }

    private TriggerType createLocalizedTriggerType(TriggerType tt, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Output> outputs = ModuleTypeI18nUtil.getLocalizedOutputs(this.i18nProvider, tt.getOutputs(), bundle, moduleTypeUID, locale);
        TriggerType ltt = null;
        if (tt instanceof CompositeTriggerType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeTriggerType)tt).getChildren(), bundle, moduleTypeUID, "module-type", locale);
            ltt = new CompositeTriggerType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, tt.getTags(), tt.getVisibility(), outputs, modules);
        } else {
            ltt = new TriggerType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, tt.getTags(), tt.getVisibility(), outputs);
        }
        return ltt;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }

    @Reference
    protected void setConfigI18nLocalizationService(ConfigI18nLocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    protected void unsetConfigI18nLocalizationService(ConfigI18nLocalizationService localizationService) {
        this.localizationService = null;
    }
}

