/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.rest.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleManager;
import org.eclipse.smarthome.automation.RulePredicates;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.dto.ActionDTOMapper;
import org.eclipse.smarthome.automation.core.dto.ConditionDTOMapper;
import org.eclipse.smarthome.automation.core.dto.RuleDTOMapper;
import org.eclipse.smarthome.automation.core.dto.TriggerDTOMapper;
import org.eclipse.smarthome.automation.core.util.ModuleBuilder;
import org.eclipse.smarthome.automation.core.util.RuleBuilder;
import org.eclipse.smarthome.automation.dto.ActionDTO;
import org.eclipse.smarthome.automation.dto.ConditionDTO;
import org.eclipse.smarthome.automation.dto.ModuleDTO;
import org.eclipse.smarthome.automation.dto.RuleDTO;
import org.eclipse.smarthome.automation.dto.TriggerDTO;
import org.eclipse.smarthome.automation.rest.internal.dto.EnrichedRuleDTO;
import org.eclipse.smarthome.automation.rest.internal.dto.EnrichedRuleDTOMapper;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="rules")
@Api(value="rules")
@Component
public class RuleResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(RuleResource.class);
    private RuleRegistry ruleRegistry;
    private RuleManager ruleManager;
    @Context
    private UriInfo uriInfo;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }

    protected void unsetRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    protected void unsetRuleManager(RuleManager ruleManager) {
        this.ruleManager = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get available rules, optionally filtered by tags and/or prefix.", response=EnrichedRuleDTO.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EnrichedRuleDTO.class, responseContainer="Collection")})
    public Response get(@QueryParam(value="prefix") String prefix, @QueryParam(value="tags") List<String> tags) {
        Predicate<Rule> p = r -> true;
        if (prefix != null) {
            p = p.and(RulePredicates.hasPrefix((String)prefix));
        }
        p = p.and(RulePredicates.hasAllTags(tags));
        Collection rules = this.ruleRegistry.stream().filter(p).map(rule -> EnrichedRuleDTOMapper.map(rule, this.ruleManager)).collect(Collectors.toList());
        return Response.ok((Object)rules).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a rule.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", responseHeaders={@ResponseHeader(name="Location", description="Newly created Rule", response=String.class)}), @ApiResponse(code=409, message="Creation of the rule is refused. Rule with the same UID already exists."), @ApiResponse(code=400, message="Creation of the rule is refused. Missing required parameter.")})
    public Response create(@ApiParam(value="rule data", required=true) RuleDTO rule) throws IOException {
        try {
            Rule newRule = this.ruleRegistry.add(RuleDTOMapper.map((RuleDTO)rule));
            return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)("rules/" + URLEncoder.encode(newRule.getUID(), "UTF-8"))).build();
        }
        catch (IllegalArgumentException e) {
            String errMessage = "Creation of the rule is refused: " + e.getMessage();
            this.logger.warn("{}", (Object)errMessage);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.CONFLICT, (String)errMessage);
        }
        catch (RuntimeException e) {
            String errMessage = "Creation of the rule is refused: " + e.getMessage();
            this.logger.warn("{}", (Object)errMessage);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)errMessage);
        }
    }

    @GET
    @Path(value="/{ruleUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule corresponding to the given UID.", response=EnrichedRuleDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EnrichedRuleDTO.class), @ApiResponse(code=404, message="Rule not found")})
    public Response getByUID(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)((Object)EnrichedRuleDTOMapper.map(rule, this.ruleManager))).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="/{ruleUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Removes an existing rule corresponding to the given UID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response remove(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule removedRule = (Rule)this.ruleRegistry.remove((Object)ruleUID);
        if (removedRule == null) {
            this.logger.info("Received HTTP DELETE request at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @PUT
    @Path(value="/{ruleUID}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Updates an existing rule corresponding to the given UID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response update(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @ApiParam(value="rule data", required=true) RuleDTO rule) throws IOException {
        rule.uid = ruleUID;
        Rule oldRule = (Rule)this.ruleRegistry.update((Identifiable)RuleDTOMapper.map((RuleDTO)rule));
        if (oldRule == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @GET
    @Path(value="/{ruleUID}/config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule configuration values.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response getConfiguration(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) throws IOException {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP GET request for config at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)rule.getConfiguration().getProperties()).build();
    }

    @PUT
    @Path(value="/{ruleUID}/config")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Sets the rule configuration values.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response updateConfiguration(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @ApiParam(value="config") Map<String, Object> configurationParameters) throws IOException {
        Map config = ConfigUtil.normalizeTypes(configurationParameters);
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP PUT request for update config at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        rule = RuleBuilder.create((Rule)rule).withConfiguration(new Configuration(config)).build();
        this.ruleRegistry.update((Identifiable)rule);
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/{ruleUID}/enable")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Sets the rule enabled status.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response enableRule(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @ApiParam(value="enable", required=true) String enabled) throws IOException {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP PUT request for set enabled at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.ruleManager.setEnabled(ruleUID, !"false".equalsIgnoreCase(enabled));
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/{ruleUID}/runnow")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Executes actions of the rule.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response runNow(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) throws IOException {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP PUT request for run now at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.ruleManager.runNow(ruleUID);
        return Response.ok().build();
    }

    @GET
    @Path(value="/{ruleUID}/triggers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule triggers.", response=TriggerDTO.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=TriggerDTO.class, responseContainer="List"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response getTriggers(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)TriggerDTOMapper.map((Collection)rule.getTriggers())).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/conditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule conditions.", response=ConditionDTO.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConditionDTO.class, responseContainer="List"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response getConditions(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)ConditionDTOMapper.map((List)rule.getConditions())).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/actions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule actions.", response=ActionDTO.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ActionDTO.class, responseContainer="List"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response getActions(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)ActionDTOMapper.map((Collection)rule.getActions())).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule's module corresponding to the given Category and ID.", response=ModuleDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ModuleDTO.class), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleById(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @PathParam(value="moduleCategory") @ApiParam(value="moduleCategory", required=true) String moduleCategory, @PathParam(value="id") @ApiParam(value="id", required=true) String id) {
        ModuleDTO dto;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (dto = this.getModuleDTO(rule, moduleCategory, id)) != null) {
            return Response.ok((Object)dto).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the module's configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleConfig(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @PathParam(value="moduleCategory") @ApiParam(value="moduleCategory", required=true) String moduleCategory, @PathParam(value="id") @ApiParam(value="id", required=true) String id) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            return Response.ok((Object)module.getConfiguration().getProperties()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config/{param}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Gets the module's configuration parameter.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleConfigParam(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @PathParam(value="moduleCategory") @ApiParam(value="moduleCategory", required=true) String moduleCategory, @PathParam(value="id") @ApiParam(value="id", required=true) String id, @PathParam(value="param") @ApiParam(value="param", required=true) String param) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            return Response.ok(module.getConfiguration().getProperties().get(param)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config/{param}")
    @ApiOperation(value="Sets the module's configuration parameter value.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    @Consumes(value={"text/plain"})
    public Response setModuleConfigParam(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @PathParam(value="moduleCategory") @ApiParam(value="moduleCategory", required=true) String moduleCategory, @PathParam(value="id") @ApiParam(value="id", required=true) String id, @PathParam(value="param") @ApiParam(value="param", required=true) String param, @ApiParam(value="value", required=true) String value) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            Configuration configuration = module.getConfiguration();
            configuration.put(param, ConfigUtil.normalizeType((Object)value));
            module = ModuleBuilder.create((Module)module).withConfiguration(configuration).build();
            this.ruleRegistry.update((Identifiable)rule);
            return Response.ok(null, (String)"text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected <T extends Module> T getModuleById(Collection<T> coll, String id) {
        if (coll == null) {
            return null;
        }
        for (Module module : coll) {
            if (!module.getId().equals(id)) continue;
            return (T)module;
        }
        return null;
    }

    protected Trigger getTrigger(Rule rule, String id) {
        return (Trigger)this.getModuleById(rule.getTriggers(), id);
    }

    protected Condition getCondition(Rule rule, String id) {
        return (Condition)this.getModuleById(rule.getConditions(), id);
    }

    protected Action getAction(Rule rule, String id) {
        return (Action)this.getModuleById(rule.getActions(), id);
    }

    protected Module getModule(Rule rule, String moduleCategory, String id) {
        if (moduleCategory.equals("triggers")) {
            return this.getTrigger(rule, id);
        }
        if (moduleCategory.equals("conditions")) {
            return this.getCondition(rule, id);
        }
        if (moduleCategory.equals("actions")) {
            return this.getAction(rule, id);
        }
        return null;
    }

    protected ModuleDTO getModuleDTO(Rule rule, String moduleCategory, String id) {
        if (moduleCategory.equals("triggers")) {
            Trigger trigger = this.getTrigger(rule, id);
            return trigger == null ? null : TriggerDTOMapper.map((Trigger)trigger);
        }
        if (moduleCategory.equals("conditions")) {
            Condition condition = this.getCondition(rule, id);
            return condition == null ? null : ConditionDTOMapper.map((Condition)condition);
        }
        if (moduleCategory.equals("actions")) {
            Action action = this.getAction(rule, id);
            return action == null ? null : ActionDTOMapper.map((Action)action);
        }
        return null;
    }

    public boolean isSatisfied() {
        return this.ruleRegistry != null && this.ruleManager != null;
    }
}

