/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAddress;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCharacteristic;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCompletionStatus;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.BluetoothService;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.handler.BlueGigaBridgeHandler;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaEventListener;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaAttributeValueEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaFindInformationFoundEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaGroupFoundEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaProcedureCompletedEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaConnectionStatusEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaDisconnectedEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaScanResponseEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir.EirDataType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir.EirPacket;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BgApiResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BluetoothAddressType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.ConnectionStatusFlag;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.ScanResponseType;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothConnectionStatusNotification;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothScanNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueGigaBluetoothDevice
extends BluetoothDevice
implements BlueGigaEventListener {
    private final Logger logger = LoggerFactory.getLogger(BlueGigaBluetoothDevice.class);
    private BluetoothAddressType addressType;
    private final Set<ScanResponseType> scanResponses = new HashSet<ScanResponseType>();
    private final BlueGigaBridgeHandler bgHandler;
    private BlueGigaProcedure procedureProgress = BlueGigaProcedure.NONE;
    private BluetoothCharacteristic procedureCharacteristic = null;
    private int connection = -1;

    public BlueGigaBluetoothDevice(BlueGigaBridgeHandler bgHandler, BluetoothAddress address, BluetoothAddressType addressType) {
        super((BluetoothAdapter)bgHandler, address);
        this.logger.debug("Creating new BlueGiga device {}", (Object)address);
        this.bgHandler = bgHandler;
        this.addressType = addressType;
        bgHandler.addEventListener(this);
    }

    public boolean connect() {
        if (this.connection != -1) {
            return false;
        }
        if (this.bgHandler.bgConnect(this.address, this.addressType)) {
            this.connectionState = BluetoothDevice.ConnectionState.CONNECTING;
            return true;
        }
        this.connectionState = BluetoothDevice.ConnectionState.DISCONNECTED;
        return false;
    }

    public boolean disconnect() {
        if (this.connection == -1) {
            return false;
        }
        return this.bgHandler.bgDisconnect(this.connection);
    }

    public boolean discoverServices() {
        this.procedureProgress = BlueGigaProcedure.GET_SERVICES;
        return this.bgHandler.bgFindPrimaryServices(this.connection);
    }

    public boolean readCharacteristic(BluetoothCharacteristic characteristic) {
        if (characteristic == null || characteristic.getHandle() == 0) {
            return false;
        }
        if (!this.bgHandler.bgReadCharacteristic(this.connection, characteristic.getHandle())) {
            return false;
        }
        if (this.procedureProgress != BlueGigaProcedure.NONE) {
            return false;
        }
        this.procedureProgress = BlueGigaProcedure.CHARACTERISTIC_READ;
        this.procedureCharacteristic = characteristic;
        return true;
    }

    public boolean writeCharacteristic(BluetoothCharacteristic characteristic) {
        if (characteristic == null || characteristic.getHandle() == 0) {
            return false;
        }
        if (this.procedureProgress != BlueGigaProcedure.NONE) {
            return false;
        }
        if (!this.bgHandler.bgWriteCharacteristic(this.connection, characteristic.getHandle(), characteristic.getValue())) {
            return false;
        }
        this.procedureProgress = BlueGigaProcedure.CHARACTERISTIC_WRITE;
        this.procedureCharacteristic = characteristic;
        return true;
    }

    @Override
    public void bluegigaEventReceived(BlueGigaResponse event) {
        if (event instanceof BlueGigaScanResponseEvent) {
            BlueGigaScanResponseEvent scanEvent = (BlueGigaScanResponseEvent)event;
            if (!this.address.equals((Object)new BluetoothAddress(scanEvent.getSender()))) {
                return;
            }
            this.rssi = scanEvent.getRssi();
            this.addressType = scanEvent.getAddressType();
            byte[] manufacturerData = null;
            if (scanEvent.getData() != null) {
                EirPacket eir = new EirPacket(scanEvent.getData());
                for (EirDataType record : eir.getRecords().keySet()) {
                    switch (record) {
                        case EIR_FLAGS: {
                            break;
                        }
                        case EIR_MANUFACTURER_SPECIFIC: {
                            manufacturerData = (byte[])eir.getRecord(EirDataType.EIR_MANUFACTURER_SPECIFIC);
                            if (manufacturerData.length <= 2) break;
                            int id = manufacturerData[0] + (manufacturerData[1] << 8);
                            this.manufacturer = id;
                            break;
                        }
                        case EIR_NAME_SHORT: 
                        case EIR_NAME_LONG: {
                            this.name = (String)eir.getRecord(record);
                            break;
                        }
                        case EIR_SLAVEINTERVALRANGE: {
                            break;
                        }
                        case EIR_SVC_DATA_UUID128: {
                            break;
                        }
                        case EIR_SVC_DATA_UUID16: {
                            break;
                        }
                        case EIR_SVC_DATA_UUID32: {
                            break;
                        }
                        case EIR_SVC_UUID16_INCOMPLETE: 
                        case EIR_SVC_UUID16_COMPLETE: 
                        case EIR_SVC_UUID32_INCOMPLETE: 
                        case EIR_SVC_UUID32_COMPLETE: 
                        case EIR_SVC_UUID128_INCOMPLETE: 
                        case EIR_SVC_UUID128_COMPLETE: {
                            break;
                        }
                        case EIR_TXPOWER: {
                            this.txPower = (int)((Integer)eir.getRecord(EirDataType.EIR_TXPOWER));
                            break;
                        }
                    }
                }
            }
            if (this.connectionState == BluetoothDevice.ConnectionState.DISCOVERING) {
                this.scanResponses.add(scanEvent.getPacketType());
                if ((this.scanResponses.contains((Object)ScanResponseType.CONNECTABLE_ADVERTISEMENT) || this.scanResponses.contains((Object)ScanResponseType.DISCOVERABLE_ADVERTISEMENT) || this.scanResponses.contains((Object)ScanResponseType.NON_CONNECTABLE_ADVERTISEMENT)) && this.scanResponses.contains((Object)ScanResponseType.SCAN_RESPONSE)) {
                    this.connectionState = BluetoothDevice.ConnectionState.DISCONNECTED;
                    this.connection = -1;
                    this.notifyListeners(BluetoothDevice.BluetoothEventType.CONNECTION_STATE, new Object[]{new BluetoothConnectionStatusNotification(BluetoothDevice.ConnectionState.DISCOVERED)});
                    this.bgHandler.deviceDiscovered(this);
                }
            }
            BluetoothScanNotification scanNotification = new BluetoothScanNotification();
            scanNotification.setRssi(scanEvent.getRssi());
            switch (scanEvent.getPacketType()) {
                case CONNECTABLE_ADVERTISEMENT: 
                case NON_CONNECTABLE_ADVERTISEMENT: 
                case DISCOVERABLE_ADVERTISEMENT: {
                    scanNotification.setBeaconType(BluetoothScanNotification.BluetoothBeaconType.BEACON_ADVERTISEMENT);
                    break;
                }
                case SCAN_RESPONSE: {
                    scanNotification.setBeaconType(BluetoothScanNotification.BluetoothBeaconType.BEACON_SCANRESPONSE);
                    break;
                }
            }
            if (manufacturerData != null) {
                scanNotification.setManufacturerData(manufacturerData);
            }
            this.notifyListeners(BluetoothDevice.BluetoothEventType.SCAN_RECORD, new Object[]{scanNotification});
            return;
        }
        if (event instanceof BlueGigaGroupFoundEvent) {
            BlueGigaGroupFoundEvent serviceEvent = (BlueGigaGroupFoundEvent)event;
            if (this.connection != serviceEvent.getConnection()) {
                return;
            }
            this.logger.trace("BlueGiga Group: {} svcs={}", (Object)this, (Object)this.supportedServices);
            BluetoothService service = new BluetoothService(serviceEvent.getUuid(), true, serviceEvent.getStart(), serviceEvent.getEnd());
            this.addService(service);
            return;
        }
        if (event instanceof BlueGigaFindInformationFoundEvent) {
            BlueGigaFindInformationFoundEvent infoEvent = (BlueGigaFindInformationFoundEvent)event;
            if (this.connection != infoEvent.getConnection()) {
                return;
            }
            this.logger.trace("BlueGiga FindInfo: {} svcs={}", (Object)this, (Object)this.supportedServices);
            BluetoothCharacteristic characteristic = new BluetoothCharacteristic(infoEvent.getUuid(), infoEvent.getChrHandle());
            BluetoothService service = this.getServiceByHandle(characteristic.getHandle());
            if (service == null) {
                this.logger.debug("BlueGiga: Unable to find service for handle {}", (Object)characteristic.getHandle());
                return;
            }
            characteristic.setService(service);
            service.addCharacteristic(characteristic);
            return;
        }
        if (event instanceof BlueGigaProcedureCompletedEvent) {
            BlueGigaProcedureCompletedEvent completedEvent = (BlueGigaProcedureCompletedEvent)event;
            if (this.connection != completedEvent.getConnection()) {
                return;
            }
            if (this.procedureProgress == null) {
                this.logger.debug("BlueGiga procedure completed but procedure is null with connection {}, address {}", (Object)this.connection, (Object)this.address);
                return;
            }
            switch (this.procedureProgress) {
                case GET_SERVICES: {
                    this.procedureProgress = BlueGigaProcedure.GET_CHARACTERISTICS;
                    this.bgHandler.bgFindCharacteristics(this.connection);
                    break;
                }
                case GET_CHARACTERISTICS: {
                    this.procedureProgress = BlueGigaProcedure.NONE;
                    this.notifyListeners(BluetoothDevice.BluetoothEventType.SERVICES_DISCOVERED, new Object[0]);
                    break;
                }
                case CHARACTERISTIC_READ: {
                    this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_READ_COMPLETE, new Object[]{this.procedureCharacteristic, BluetoothCompletionStatus.ERROR});
                    this.procedureProgress = BlueGigaProcedure.NONE;
                    this.procedureCharacteristic = null;
                    break;
                }
                case CHARACTERISTIC_WRITE: {
                    BluetoothCompletionStatus result = completedEvent.getResult() == BgApiResponse.SUCCESS ? BluetoothCompletionStatus.SUCCESS : BluetoothCompletionStatus.ERROR;
                    this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_WRITE_COMPLETE, new Object[]{this.procedureCharacteristic, result});
                    this.procedureProgress = BlueGigaProcedure.NONE;
                    this.procedureCharacteristic = null;
                    break;
                }
            }
            return;
        }
        if (event instanceof BlueGigaConnectionStatusEvent) {
            BlueGigaConnectionStatusEvent connectionEvent = (BlueGigaConnectionStatusEvent)event;
            if (!this.address.equals((Object)new BluetoothAddress(connectionEvent.getAddress()))) {
                return;
            }
            if (connectionEvent.getFlags().contains((Object)ConnectionStatusFlag.CONNECTION_CONNECTED)) {
                this.connectionState = BluetoothDevice.ConnectionState.CONNECTED;
                this.connection = connectionEvent.getConnection();
            }
            if (connectionEvent.getFlags().contains((Object)ConnectionStatusFlag.CONNECTION_CONNECTED)) {
                this.notifyListeners(BluetoothDevice.BluetoothEventType.CONNECTION_STATE, new Object[]{new BluetoothConnectionStatusNotification(this.connectionState)});
            }
            return;
        }
        if (event instanceof BlueGigaDisconnectedEvent) {
            BlueGigaDisconnectedEvent disconnectedEvent = (BlueGigaDisconnectedEvent)event;
            if (this.connection != disconnectedEvent.getConnection()) {
                return;
            }
            this.connectionState = BluetoothDevice.ConnectionState.DISCONNECTED;
            this.connection = -1;
            this.notifyListeners(BluetoothDevice.BluetoothEventType.CONNECTION_STATE, new Object[]{new BluetoothConnectionStatusNotification(this.connectionState)});
            return;
        }
        if (event instanceof BlueGigaAttributeValueEvent) {
            BlueGigaAttributeValueEvent valueEvent = (BlueGigaAttributeValueEvent)event;
            BluetoothCharacteristic characteristic = this.getCharacteristicByHandle(valueEvent.getAttHandle());
            if (characteristic == null) {
                this.logger.debug("BlueGiga didn't find characteristic for event {}", (Object)event);
            } else {
                if (this.procedureProgress == BlueGigaProcedure.CHARACTERISTIC_READ && this.procedureCharacteristic != null && this.procedureCharacteristic.getHandle() == valueEvent.getAttHandle()) {
                    this.procedureProgress = BlueGigaProcedure.NONE;
                    this.procedureCharacteristic = null;
                    this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_READ_COMPLETE, new Object[]{characteristic, BluetoothCompletionStatus.SUCCESS});
                }
                this.notifyListeners(BluetoothDevice.BluetoothEventType.CHARACTERISTIC_UPDATED, new Object[]{this.procedureCharacteristic});
            }
        }
    }

    private static enum BlueGigaProcedure {
        NONE,
        GET_SERVICES,
        GET_CHARACTERISTICS,
        CHARACTERISTIC_READ,
        CHARACTERISTIC_WRITE;

    }
}

