/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaPacket;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.AttributeChangeReason;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.AttributeValueType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BgApiResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BluetoothAddressType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.ConnectionStatusFlag;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.ScanResponseType;

public class BlueGigaResponse
extends BlueGigaPacket {
    private int[] buffer = new int[131];
    private int position = 0;
    protected boolean event = false;

    protected BlueGigaResponse(int[] inputBuffer) {
        this.buffer = inputBuffer;
        this.position = 4;
    }

    public boolean isEvent() {
        return this.event;
    }

    protected int deserializeInt8() {
        if (this.buffer[this.position] >= 128) {
            return this.buffer[this.position++] - 256;
        }
        return this.buffer[this.position++];
    }

    protected int deserializeUInt8() {
        return this.buffer[this.position++];
    }

    protected boolean deserializeBoolean() {
        return this.buffer[this.position++] != 0;
    }

    protected int deserializeUInt16() {
        return this.buffer[this.position++] + (this.buffer[this.position++] << 8);
    }

    protected UUID deserializeUuid() {
        long high;
        long low;
        int length = this.buffer[this.position++];
        switch (length) {
            case 2: {
                low = 0L;
                high = ((long)this.buffer[this.position++] << 32) + ((long)this.buffer[this.position++] << 40);
                break;
            }
            case 4: {
                low = 0L;
                high = ((long)this.buffer[this.position++] << 32) + ((long)this.buffer[this.position++] << 40) + ((long)this.buffer[this.position++] << 48) + ((long)this.buffer[this.position++] << 56);
                break;
            }
            case 16: {
                low = (long)this.buffer[this.position++] + ((long)this.buffer[this.position++] << 8) + ((long)this.buffer[this.position++] << 16) + ((long)this.buffer[this.position++] << 24) + ((long)this.buffer[this.position++] << 32) + ((long)this.buffer[this.position++] << 40) + ((long)this.buffer[this.position++] << 48) + ((long)this.buffer[this.position++] << 56);
                high = (long)this.buffer[this.position++] + ((long)this.buffer[this.position++] << 8) + ((long)this.buffer[this.position++] << 16) + ((long)this.buffer[this.position++] << 24) + ((long)this.buffer[this.position++] << 32) + ((long)this.buffer[this.position++] << 40) + ((long)this.buffer[this.position++] << 48) + ((long)this.buffer[this.position++] << 56);
                break;
            }
            default: {
                low = 0L;
                high = 0L;
                this.position += length;
            }
        }
        return new UUID(high, low);
    }

    protected BgApiResponse deserializeBgApiResponse() {
        return BgApiResponse.getBgApiResponse(this.deserializeUInt16());
    }

    public Set<ConnectionStatusFlag> deserializeConnectionStatusFlag() {
        int val = this.deserializeUInt8();
        HashSet<ConnectionStatusFlag> options = new HashSet<ConnectionStatusFlag>();
        ConnectionStatusFlag[] connectionStatusFlagArray = ConnectionStatusFlag.values();
        int n = connectionStatusFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionStatusFlag option = connectionStatusFlagArray[n2];
            if (option != ConnectionStatusFlag.UNKNOWN && (option.getKey() & val) != 0) {
                options.add(option);
            }
            ++n2;
        }
        return options;
    }

    protected AttributeValueType deserializeAttributeValueType() {
        return AttributeValueType.getAttributeValueType(this.deserializeUInt8());
    }

    protected BluetoothAddressType deserializeBluetoothAddressType() {
        return BluetoothAddressType.getBluetoothAddressType(this.deserializeUInt8());
    }

    protected AttributeChangeReason deserializeAttributeChangeReason() {
        return AttributeChangeReason.getAttributeChangeReason(this.deserializeUInt8());
    }

    protected ScanResponseType deserializeScanResponseType() {
        return ScanResponseType.getScanResponseType(this.deserializeUInt8());
    }

    protected long deserializeUInt32() {
        return this.buffer[this.position++] + (this.buffer[this.position++] << 8) + (this.buffer[this.position++] << 16) + (this.buffer[this.position++] << 24);
    }

    protected int[] deserializeUInt8Array() {
        int length = this.buffer[this.position++];
        int[] val = new int[length];
        int cnt = 0;
        while (cnt < length) {
            val[cnt] = this.deserializeUInt8();
            ++cnt;
        }
        return val;
    }

    protected String deserializeAddress() {
        StringBuilder builder = new StringBuilder();
        int cnt = 5;
        while (cnt >= 0) {
            if (cnt < 5) {
                builder.append(':');
            }
            builder.append(String.format("%02X", this.buffer[this.position + cnt]));
            --cnt;
        }
        this.position += 6;
        return builder.toString();
    }
}

