/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaEventListener;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaException;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaHandlerListener;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponsePackets;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueGigaSerialHandler {
    private static final int BLE_MAX_LENGTH = 64;
    private static final int TRANSACTION_TIMEOUT_PERIOD = 50;
    private final Logger logger = LoggerFactory.getLogger(BlueGigaSerialHandler.class);
    private final OutputStream outputStream;
    private final Queue<BlueGigaCommand> sendQueue = new LinkedList<BlueGigaCommand>();
    private final Timer timer = new Timer();
    private TimerTask timerTask = null;
    private Thread parserThread = null;
    private final ExecutorService executor = ThreadPoolManager.getPool((String)"bluegiga");
    private final List<BluetoothListener<? extends BlueGigaResponse>> transactionListeners = new CopyOnWriteArrayList<BluetoothListener<? extends BlueGigaResponse>>();
    private final Set<BlueGigaEventListener> eventListeners = new CopyOnWriteArraySet<BlueGigaEventListener>();
    private final Set<BlueGigaHandlerListener> handlerListeners = new CopyOnWriteArraySet<BlueGigaHandlerListener>();
    private boolean close = false;

    public BlueGigaSerialHandler(final InputStream inputStream, OutputStream outputStream) {
        this.outputStream = outputStream;
        int[] nArray = new int[5];
        nArray[1] = 127;
        nArray[2] = 192;
        nArray[3] = 248;
        nArray[4] = 224;
        final int[] framecheckParams = nArray;
        this.parserThread = new Thread("BlueGigaBLEHandler"){

            @Override
            public void run() {
                int exceptionCnt = 0;
                BlueGigaSerialHandler.this.logger.trace("BlueGiga BLE thread started");
                int[] inputBuffer = new int[64];
                int inputCount = 0;
                int inputLength = 0;
                while (!BlueGigaSerialHandler.this.close) {
                    try {
                        int val = inputStream.read();
                        if (val == -1) continue;
                        inputBuffer[inputCount++] = val;
                        if (inputCount < 4) {
                            if ((val & framecheckParams[inputCount]) != 0) {
                                BlueGigaSerialHandler.this.logger.debug("BlueGiga framing error byte {} = {}", (Object)inputCount, (Object)val);
                                inputCount = 0;
                                continue;
                            }
                        } else if (inputCount == 4 && (inputLength = inputBuffer[1] + (inputBuffer[0] & 0x200) + 4) > 64) {
                            BlueGigaSerialHandler.this.logger.error("BLE length larger than 64 bytes ({})", (Object)inputLength);
                        }
                        if (inputCount != inputLength) continue;
                        BlueGigaResponse responsePacket = BlueGigaResponsePackets.getPacket(inputBuffer);
                        BlueGigaSerialHandler.this.logger.trace("BLE RX: {}", (Object)BlueGigaSerialHandler.this.printHex(inputBuffer, inputLength));
                        BlueGigaSerialHandler.this.logger.trace("BLE RX: {}", (Object)responsePacket);
                        if (responsePacket != null) {
                            if (responsePacket.isEvent()) {
                                BlueGigaSerialHandler.this.notifyEventListeners(responsePacket);
                            } else {
                                BlueGigaSerialHandler.this.notifyTransactionComplete(responsePacket);
                            }
                        }
                        inputCount = 0;
                    }
                    catch (IOException e) {
                        BlueGigaSerialHandler.this.logger.error("BlueGiga BLE IOException: ", (Throwable)e);
                        if (exceptionCnt++ <= 10) continue;
                        BlueGigaSerialHandler.this.logger.error("BlueGiga BLE exception count exceeded");
                        BlueGigaSerialHandler.this.close = true;
                        BlueGigaSerialHandler.this.notifyClosed(e);
                    }
                }
                BlueGigaSerialHandler.this.logger.debug("BlueGiga BLE exited.");
            }
        };
        this.parserThread.setDaemon(true);
        this.parserThread.start();
        int tries = 0;
        while (this.parserThread.getState() == Thread.State.NEW) {
            try {
                Thread.sleep(100L);
                if (++tries <= 10) continue;
                throw new IllegalStateException("BlueGiga handler thread failed to start");
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void close() {
        this.close(0L);
    }

    public void close(long timeout) {
        this.close = true;
        this.executor.shutdownNow();
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        this.timer.cancel();
        try {
            this.parserThread.interrupt();
            this.parserThread.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            this.logger.warn("Interrupted in packet parser thread shutdown join.");
        }
    }

    public boolean isAlive() {
        return this.parserThread != null && this.parserThread.isAlive() && !this.close;
    }

    private synchronized void sendFrame(BlueGigaCommand bleFrame) {
        try {
            int[] payload = bleFrame.serialize();
            this.logger.trace("TX BLE frame: {}", (Object)this.printHex(payload, payload.length));
            int[] nArray = payload;
            int n = payload.length;
            int n2 = 0;
            while (n2 < n) {
                int b = nArray[n2];
                this.outputStream.write(b);
                ++n2;
            }
        }
        catch (IOException e) {
            throw new BlueGigaException("Error sending BLE frame", e);
        }
        this.logger.trace("--> TX BLE frame: {}", (Object)bleFrame);
    }

    private synchronized void sendNextFrame() {
        BlueGigaCommand nextFrame = this.sendQueue.poll();
        if (nextFrame == null) {
            return;
        }
        this.sendFrame(nextFrame);
    }

    public void queueFrame(BlueGigaCommand request) {
        this.logger.trace("TX BLE frame: {}", (Object)request);
        this.checkIfAlive();
        this.sendQueue.add(request);
        this.logger.trace("TX BLE queue: {}", (Object)this.sendQueue.size());
        this.sendNextFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyTransactionComplete(BlueGigaResponse response) {
        boolean processed = false;
        List<BluetoothListener<? extends BlueGigaResponse>> list = this.transactionListeners;
        synchronized (list) {
            for (BluetoothListener<? extends BlueGigaResponse> listener : this.transactionListeners) {
                if (!listener.transactionEvent(response)) continue;
                processed = true;
            }
        }
        return processed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransactionListener(BluetoothListener<? extends BlueGigaResponse> listener) {
        List<BluetoothListener<? extends BlueGigaResponse>> list = this.transactionListeners;
        synchronized (list) {
            if (this.transactionListeners.contains(listener)) {
                return;
            }
            this.transactionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransactionListener(BluetoothListener<?> listener) {
        List<BluetoothListener<? extends BlueGigaResponse>> list = this.transactionListeners;
        synchronized (list) {
            this.transactionListeners.remove(listener);
        }
    }

    public <T extends BlueGigaResponse> Future<T> sendBleRequestAsync(BlueGigaCommand bleCommand, Class<T> expected) {
        this.checkIfAlive();
        class TransactionWaiter
        implements Callable<T>,
        BluetoothListener<T> {
            private boolean complete;
            private BlueGigaResponse response;
            private final /* synthetic */ BlueGigaCommand val$bleCommand;
            private final /* synthetic */ Class val$expected;

            TransactionWaiter(BlueGigaCommand blueGigaCommand, Class clazz) {
                this.val$bleCommand = blueGigaCommand;
                this.val$expected = clazz;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T call() {
                BlueGigaSerialHandler.this.addTransactionListener(this);
                BlueGigaSerialHandler.this.queueFrame(this.val$bleCommand);
                TransactionWaiter transactionWaiter = this;
                synchronized (transactionWaiter) {
                    while (!this.complete) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.complete = true;
                        }
                    }
                }
                BlueGigaSerialHandler.this.removeTransactionListener(this);
                return this.response;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean transactionEvent(BlueGigaResponse bleResponse) {
                if (this.val$bleCommand.hashCode() == bleResponse.hashCode()) {
                    return false;
                }
                if (!this.val$expected.isInstance(bleResponse)) {
                    BlueGigaSerialHandler.this.logger.warn("Ignoring {} response which has not been requested.", (Object)bleResponse.getClass().getSimpleName());
                    return false;
                }
                this.response = bleResponse;
                this.complete = true;
                TransactionWaiter transactionWaiter = this;
                synchronized (transactionWaiter) {
                    this.notify();
                }
                return true;
            }
        }
        TransactionWaiter worker = new TransactionWaiter(bleCommand, expected);
        return this.executor.submit(worker);
    }

    public BlueGigaResponse sendTransaction(BlueGigaCommand bleCommand) {
        this.checkIfAlive();
        Future<BlueGigaResponse> futureResponse = this.sendBleRequestAsync(bleCommand, BlueGigaResponse.class);
        try {
            return futureResponse.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BlueGigaException("Error sending BLE transaction to listeners.", e);
        }
    }

    public <T extends BlueGigaResponse> T sendTransaction(BlueGigaCommand bleCommand, Class<T> expected, long timeout) throws TimeoutException {
        Future<T> futureResponse = this.sendBleRequestAsync(bleCommand, expected);
        try {
            return (T)((BlueGigaResponse)futureResponse.get(timeout, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException | ExecutionException e) {
            futureResponse.cancel(true);
            throw new BlueGigaException("Error sending BLE transaction to listeners: ", e);
        }
    }

    private synchronized void startTransactionTimer() {
        this.resetTransactionTimer();
        this.timerTask = new TransactionTimer();
        this.timer.schedule(this.timerTask, 50L);
    }

    private synchronized void resetTransactionTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEventListeners(BlueGigaResponse response) {
        BlueGigaSerialHandler blueGigaSerialHandler = this;
        synchronized (blueGigaSerialHandler) {
            for (BlueGigaEventListener listener : this.eventListeners) {
                this.executor.submit(() -> listener.bluegigaEventReceived(response));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(BlueGigaEventListener listener) {
        Set<BlueGigaEventListener> set = this.eventListeners;
        synchronized (set) {
            this.eventListeners.add(listener);
        }
    }

    public void addHandlerListener(BlueGigaHandlerListener listener) {
        this.handlerListeners.add(listener);
    }

    public void removeEventListener(BlueGigaEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void removeHandlerListener(BlueGigaHandlerListener listener) {
        this.handlerListeners.remove(listener);
    }

    private String printHex(int[] data, int len) {
        StringBuilder builder = new StringBuilder();
        int cnt = 0;
        while (cnt < len) {
            builder.append(String.format("%02X ", data[cnt]));
            ++cnt;
        }
        return builder.toString();
    }

    private void checkIfAlive() {
        if (!this.isAlive()) {
            throw new IllegalStateException("Bluegiga handler is dead. Most likely because of IO errors. Re-initialization of the BlueGigaSerialHandler is required.");
        }
    }

    private void notifyClosed(Exception reason) {
        for (BlueGigaHandlerListener listener : this.handlerListeners) {
            try {
                listener.bluegigaClosed(reason);
            }
            catch (Exception ex) {
                this.logger.warn("Execution error of a BlueGigaHandlerListener listener.", (Throwable)ex);
            }
        }
    }

    static interface BluetoothListener<T extends BlueGigaResponse> {
        public boolean transactionEvent(BlueGigaResponse var1);
    }

    private class TransactionTimer
    extends TimerTask {
        private TransactionTimer() {
        }

        @Override
        public void run() {
        }
    }
}

