/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb;

import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BgApiResponse;

public class BlueGigaReadResponse
extends BlueGigaResponse {
    public static int COMMAND_CLASS = 2;
    public static int COMMAND_METHOD = 1;
    private int handle;
    private int offset;
    private BgApiResponse result;
    private int[] value;

    public BlueGigaReadResponse(int[] inputBuffer) {
        super(inputBuffer);
        this.event = (inputBuffer[0] & 0x80) != 0;
        this.handle = this.deserializeUInt16();
        this.offset = this.deserializeUInt16();
        this.result = this.deserializeBgApiResponse();
        this.value = this.deserializeUInt8Array();
    }

    public int getHandle() {
        return this.handle;
    }

    public int getOffset() {
        return this.offset;
    }

    public BgApiResponse getResult() {
        return this.result;
    }

    public int[] getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlueGigaReadResponse [handle=");
        builder.append(this.handle);
        builder.append(", offset=");
        builder.append(this.offset);
        builder.append(", result=");
        builder.append((Object)this.result);
        builder.append(", value=");
        int c = 0;
        while (c < this.value.length) {
            if (c > 0) {
                builder.append(' ');
            }
            builder.append(String.format("%02X", this.value[c]));
            ++c;
        }
        builder.append(']');
        return builder.toString();
    }
}

