/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection;

import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;

public class BlueGigaFeatureIndEvent
extends BlueGigaResponse {
    public static int COMMAND_CLASS = 3;
    public static int COMMAND_METHOD = 2;
    private int connection;
    private int[] features;

    public BlueGigaFeatureIndEvent(int[] inputBuffer) {
        super(inputBuffer);
        this.event = (inputBuffer[0] & 0x80) != 0;
        this.connection = this.deserializeUInt8();
        this.features = this.deserializeUInt8Array();
    }

    public int getConnection() {
        return this.connection;
    }

    public int[] getFeatures() {
        return this.features;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlueGigaFeatureIndEvent [connection=");
        builder.append(this.connection);
        builder.append(", features=");
        int c = 0;
        while (c < this.features.length) {
            if (c > 0) {
                builder.append(' ');
            }
            builder.append(String.format("%02X", this.features[c]));
            ++c;
        }
        builder.append(']');
        return builder.toString();
    }
}

