/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir;

import java.util.HashMap;
import java.util.Map;

public enum EirDataType {
    UNKNOWN(-1),
    NONE(0),
    EIR_FLAGS(1),
    EIR_SVC_UUID16_INCOMPLETE(2),
    EIR_SVC_UUID16_COMPLETE(3),
    EIR_SVC_UUID32_INCOMPLETE(4),
    EIR_SVC_UUID32_COMPLETE(5),
    EIR_SVC_UUID128_INCOMPLETE(6),
    EIR_SVC_UUID128_COMPLETE(7),
    EIR_NAME_SHORT(8),
    EIR_NAME_LONG(9),
    EIR_TXPOWER(10),
    EIR_DEVICE_CLASS(13),
    EIR_SIMPLE_PAIRING_RANDOMIZER(15),
    EIR_SECMAN_TK_VALUE(16),
    EIR_SECMAN_OOB_FLAGS(17),
    EIR_SLAVEINTERVALRANGE(18),
    EIR_SVC_SOLICIT_UUID16(20),
    EIR_SVC_SOLICIT_UUID128(21),
    EIR_SVC_DATA_UUID16(22),
    EIR_PUBLIC_TARGET_ADDR(23),
    EIR_RANDOM_TARGET_ADDR(24),
    EIR_APPEARANCE(25),
    EIR_ADVERTISING_INTERVAL(26),
    EIR_LE_DEVICE_ADDRESS(27),
    EIR_LE_ROLE(28),
    EIR_SIMPLE_PAIRING_HASH(29),
    EIR_SVC_SOLICIT_UUID32(31),
    EIR_SVC_DATA_UUID32(32),
    EIR_SVC_DATA_UUID128(33),
    EIR_LE_SEC_CONFIRMATION_VALUE(34),
    EIR_LE_CONNECTION_RANDOM_VALUE(35),
    EIR_URI(36),
    EIR_INDOOR_POSITIONING(37),
    EIR_LE_SUPPORTED_FEATURES(39),
    EIR_MANUFACTURER_SPECIFIC(255);

    private static Map<Integer, EirDataType> codeMapping;
    private int key;

    private EirDataType(int key) {
        this.key = key;
    }

    private static void initMapping() {
        codeMapping = new HashMap<Integer, EirDataType>();
        EirDataType[] eirDataTypeArray = EirDataType.values();
        int n = eirDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EirDataType s = eirDataTypeArray[n2];
            codeMapping.put(s.key, s);
            ++n2;
        }
    }

    public static EirDataType getEirPacketType(int eirDataType) {
        if (codeMapping == null) {
            EirDataType.initMapping();
        }
        if (codeMapping.get(eirDataType) == null) {
            return UNKNOWN;
        }
        return codeMapping.get(eirDataType);
    }

    public int getKey() {
        return this.key;
    }
}

