/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration;

import java.util.HashMap;
import java.util.Map;

public enum GapDiscoverableMode {
    UNKNOWN(-1),
    GAP_NON_DISCOVERABLE(0),
    GAP_LIMITED_DISCOVERABLE(1),
    GAP_GENERAL_DISCOVERABLE(2),
    GAP_BROADCAST(3),
    GAP_USER_DATA(4),
    GAP_ENHANCED_BROADCASTING(128);

    private static Map<Integer, GapDiscoverableMode> codeMapping;
    private int key;

    private GapDiscoverableMode(int key) {
        this.key = key;
    }

    private static void initMapping() {
        codeMapping = new HashMap<Integer, GapDiscoverableMode>();
        GapDiscoverableMode[] gapDiscoverableModeArray = GapDiscoverableMode.values();
        int n = gapDiscoverableModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GapDiscoverableMode s = gapDiscoverableModeArray[n2];
            codeMapping.put(s.key, s);
            ++n2;
        }
    }

    public static GapDiscoverableMode getGapDiscoverableMode(int gapDiscoverableMode) {
        if (codeMapping == null) {
            GapDiscoverableMode.initMapping();
        }
        if (codeMapping.get(gapDiscoverableMode) == null) {
            return UNKNOWN;
        }
        return codeMapping.get(gapDiscoverableMode);
    }

    public int getKey() {
        return this.key;
    }
}

