/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.SocketInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketHandler {
    private final Logger logger = LoggerFactory.getLogger(SocketHandler.class);
    private Map<Integer, SocketInfo> socketsPerPort = new HashMap<Integer, SocketInfo>();
    private HomematicConfig config;

    public SocketHandler(HomematicConfig config) {
        this.config = config;
    }

    public Socket getSocket(int port) throws IOException {
        SocketInfo socketInfo = this.socketsPerPort.get(port);
        if (socketInfo == null) {
            this.logger.trace("Creating new socket for port {}", (Object)port);
            Socket socket = new Socket();
            socket.setSoTimeout(this.config.getTimeout() * 1000);
            socket.setReuseAddress(true);
            socket.connect(new InetSocketAddress(this.config.getGatewayAddress(), port), socket.getSoTimeout());
            socketInfo = new SocketInfo(socket);
            this.socketsPerPort.put(port, socketInfo);
        } else {
            boolean isMaxAliveReached;
            boolean bl = isMaxAliveReached = System.currentTimeMillis() - socketInfo.getCreated() > (long)(this.config.getSocketMaxAlive() * 1000);
            if (isMaxAliveReached) {
                this.logger.debug("Max alive time reached for socket on port {}", (Object)port);
                this.removeSocket(port);
                return this.getSocket(port);
            }
            this.logger.trace("Returning socket for port {}", (Object)port);
        }
        return socketInfo.getSocket();
    }

    public void removeSocket(int port) {
        SocketInfo socketInfo = this.socketsPerPort.get(port);
        if (socketInfo != null) {
            this.logger.trace("Closing Socket on port {}", (Object)port);
            this.socketsPerPort.remove(port);
            this.closeSilent(socketInfo.getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Class<SocketHandler> clazz = SocketHandler.class;
        synchronized (SocketHandler.class) {
            Integer[] portsToRemove;
            Integer[] integerArray = portsToRemove = this.socketsPerPort.keySet().toArray(new Integer[0]);
            int n = portsToRemove.length;
            int n2 = 0;
            while (n2 < n) {
                Integer key = integerArray[n2];
                this.removeSocket(key);
                ++n2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void closeSilent(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }
}

