/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.RpcClient;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.UnknownParameterSetException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.UnknownRpcFailureException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.XmlRpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.XmlRpcResponse;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.RpcResponseParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRpcClient
extends RpcClient<String> {
    private final Logger logger = LoggerFactory.getLogger(XmlRpcClient.class);
    private HttpClient httpClient;

    public XmlRpcClient(HomematicConfig config, HttpClient httpClient) throws IOException {
        super(config);
        this.httpClient = httpClient;
    }

    @Override
    public void dispose() {
    }

    @Override
    public RpcRequest<String> createRpcRequest(String methodName) {
        return new XmlRpcRequest(methodName);
    }

    @Override
    protected String getRpcCallbackUrl() {
        return "http://" + this.config.getCallbackHost() + ":" + this.config.getXmlCallbackPort();
    }

    @Override
    protected synchronized Object[] sendMessage(int port, RpcRequest<String> request) throws IOException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Client XmlRpcRequest (port {}):\n{}", (Object)port, request);
        }
        return this.sendMessage(port, request, 0);
    }

    private synchronized Object[] sendMessage(int port, RpcRequest<String> request, int rpcRetryCounter) throws IOException {
        try {
            BytesContentProvider content = new BytesContentProvider((byte[][])new byte[][]{request.createMessage().getBytes(this.config.getEncoding())});
            String url = String.format("http://%s:%s", this.config.getGatewayAddress(), port);
            if (port == this.config.getGroupPort()) {
                url = String.valueOf(url) + "/groups";
            }
            ContentResponse response = this.httpClient.POST(url).content((ContentProvider)content).timeout((long)this.config.getTimeout(), TimeUnit.SECONDS).header(HttpHeader.CONTENT_TYPE, "text/xml;charset=" + this.config.getEncoding()).send();
            String result = new String(response.getContent(), this.config.getEncoding());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Client XmlRpcResponse (port {}):\n{}", (Object)port, (Object)result);
            }
            Object[] data = new XmlRpcResponse(new ByteArrayInputStream(result.getBytes(this.config.getEncoding())), this.config.getEncoding()).getResponseData();
            return new RpcResponseParser(request).parse(data);
        }
        catch (UnknownParameterSetException | UnknownRpcFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if ("init".equals(request.getMethodName()) || rpcRetryCounter >= 1) {
                throw new IOException(ex.getMessage(), ex);
            }
            this.logger.debug("XmlRpcMessage failure, sending message again {}/{}", (Object)(++rpcRetryCounter), (Object)1);
            return this.sendMessage(port, request, rpcRetryCounter);
        }
    }
}

